/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.workspace.ui.preferences;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.eatop.workspace.natures.EastADLNature;
import org.eclipse.eatop.workspace.ui.preferences.EastADLPreferenceMessages;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.sphinx.platform.ui.dialogs.ProjectSelectionDialog;
import org.eclipse.sphinx.platform.ui.fields.IField;
import org.eclipse.sphinx.platform.ui.fields.IFieldListener;
import org.eclipse.sphinx.platform.ui.fields.SelectionButtonField;
import org.eclipse.sphinx.platform.ui.internal.util.LayoutUtil;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public abstract class PreferenceAndPropertyPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private Link fChangeWorkspaceSettings;
    private SelectionButtonField fUseProjectSettings;
    private IProject fProject;
    private Map<String, Object> fData;
    public static final String DATA_NO_LINK = "PropertyAndPreferencePage.nolink";

    public PreferenceAndPropertyPage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
    }

    public IAdaptable getElement() {
        return this.fProject;
    }

    public void setElement(IAdaptable element) {
        this.fProject = (IProject)element.getAdapter(IResource.class);
    }

    protected abstract boolean hasProjectSpecificOptions(IProject var1);

    protected abstract void enablePreferenceContent(boolean var1);

    protected abstract String getPreferencePageID();

    protected abstract String getPropertyPageID();

    protected Label createDescriptionLabel(Composite parent) {
        if (this.isProjectPreferencePage()) {
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            IFieldListener listener = new IFieldListener(){

                public void dialogFieldChanged(IField field) {
                    boolean enabled = ((SelectionButtonField)field).isSelected();
                    PreferenceAndPropertyPage.this.enableProjectSpecificSettings(enabled);
                    if (enabled && PreferenceAndPropertyPage.this.getData() != null) {
                        PreferenceAndPropertyPage.this.applyData(PreferenceAndPropertyPage.this.getData());
                    }
                    if (enabled) {
                        PreferenceAndPropertyPage.this.useProjectSettingsEnabled();
                    }
                }
            };
            this.fUseProjectSettings = new SelectionButtonField(32);
            this.fUseProjectSettings.addFieldListener(listener);
            this.fUseProjectSettings.setLabelText(EastADLPreferenceMessages.EastADLPreferencePage_enableProjectSpecificSettings);
            this.fUseProjectSettings.fillIntoGrid(composite, 1);
            this.fUseProjectSettings.setSelectionWithoutEvent(true);
            if (this.offerLink()) {
                this.fChangeWorkspaceSettings = this.createLink(composite, EastADLPreferenceMessages.EastADLPreferencePage_configureWorkspaceSettings);
                this.fChangeWorkspaceSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            } else {
                LayoutUtil.setHorizontalSpan((Control)this.fUseProjectSettings.getSelectionButton(null), (int)2);
            }
            Label horizontalLine = new Label(composite, 258);
            horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            horizontalLine.setFont(composite.getFont());
        } else if (this.supportsProjectSpecificOptions() && this.offerLink()) {
            this.fChangeWorkspaceSettings = this.createLink(parent, EastADLPreferenceMessages.EastADLPreferencePage_configureProjectSpecificSettings);
            this.fChangeWorkspaceSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        }
        return super.createDescriptionLabel(parent);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (this.isProjectPreferencePage()) {
            boolean useProjectSettings = this.hasProjectSpecificOptions(this.getProject());
            this.enableProjectSpecificSettings(useProjectSettings);
        }
        return contents;
    }

    protected boolean isProjectPreferencePage() {
        return this.fProject != null;
    }

    protected IProject getProject() {
        return this.fProject;
    }

    protected boolean supportsProjectSpecificOptions() {
        return this.getPropertyPageID() != null;
    }

    protected final void openWorkspacePreferences(Object data) {
        String id = this.getPreferencePageID();
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, (Object)data).open();
    }

    protected final void openProjectProperties(IProject project, Object data) {
        String id = this.getPropertyPageID();
        if (id != null) {
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)project, (String)id, (String[])new String[]{id}, (Object)data).open();
        }
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        this.fUseProjectSettings.setSelection(useProjectSpecificSettings);
        this.enablePreferenceContent(useProjectSpecificSettings);
        this.updateLinkVisibility();
    }

    protected void useProjectSettingsEnabled() {
    }

    public void applyData(Object data) {
        if (data instanceof Map) {
            this.fData = (Map)data;
        }
    }

    protected Map<String, Object> getData() {
        return this.fData;
    }

    protected boolean useProjectSettings() {
        return this.isProjectPreferencePage() && this.fUseProjectSettings != null && this.fUseProjectSettings.isSelected();
    }

    protected boolean offerLink() {
        return this.fData == null || !Boolean.TRUE.equals(this.fData.get(DATA_NO_LINK));
    }

    private final void doLinkActivated(Link link) {
        Map<String, Object> data = this.getData();
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        data.put(DATA_NO_LINK, Boolean.TRUE);
        if (this.isProjectPreferencePage()) {
            this.openWorkspacePreferences(data);
        } else {
            HashSet<IProject> projectsWithSpecifics = new HashSet<IProject>();
            Collection projects = ExtendedPlatform.getProjects((String)EastADLNature.ID);
            for (IProject project : projects) {
                if (!this.hasProjectSpecificOptions(project)) continue;
                projectsWithSpecifics.add(project);
            }
            ProjectSelectionDialog dialog = new ProjectSelectionDialog(this.getShell(), projectsWithSpecifics);
            if (dialog.open() == 0) {
                IProject res = (IProject)dialog.getFirstResult();
                this.openProjectProperties(res.getProject(), data);
            }
        }
    }

    private Link createLink(Composite composite, String text) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceAndPropertyPage.this.doLinkActivated((Link)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PreferenceAndPropertyPage.this.doLinkActivated((Link)e.widget);
            }
        });
        return link;
    }

    private void updateLinkVisibility() {
        if (this.fChangeWorkspaceSettings == null || this.fChangeWorkspaceSettings.isDisposed()) {
            return;
        }
        if (this.isProjectPreferencePage()) {
            this.fChangeWorkspaceSettings.setEnabled(!this.useProjectSettings());
        }
    }
}

