/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.workspace.ui.internal.preferences;

import org.eclipse.eatop.workspace.ui.internal.messages.Messages;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.sphinx.emf.resource.IModelConverterDescription;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ModelConverterDescriptionLabels
extends Composite {
    private static final String WARNING_TITLE_TEXT = Messages.Warning_TitleText;
    private static final String DESC_TITLE_TEXT = Messages.Description_TitleText;
    private static final IModelConverterDescription NULL_DESCRIPTION = new IModelConverterDescription(){

        public boolean isEmpty() {
            return false;
        }

        public boolean hasWarning() {
            return false;
        }

        public boolean hasBehaviorDetails() {
            return false;
        }

        public String getWarning() {
            return null;
        }

        public String getBehaviorDetails() {
            return null;
        }
    };
    private Section fWarning;
    private Section fDescription;

    public ModelConverterDescriptionLabels(Composite parent) {
        super(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        this.setLayout((Layout)gridLayout);
        this.fWarning = this.createNewSection("dialog_messasge_warning_image", WARNING_TITLE_TEXT);
        this.fDescription = this.createNewSection("dialog_messasge_info_image", DESC_TITLE_TEXT);
        this.setConverterDescription(null);
    }

    private Section createNewSection(String iconSymbolicName, String titleText) {
        Section section = new Section();
        section.icon = this.createIcon(iconSymbolicName);
        section.title = this.createTitle(titleText);
        section.content = this.createContent();
        return section;
    }

    private Label createIcon(String imageKey) {
        Label icon = new Label((Composite)this, 32);
        icon.setImage(JFaceResources.getImage((String)imageKey));
        return icon;
    }

    private Label createTitle(String titleText) {
        Label title = new Label((Composite)this, 32);
        title.setText(titleText);
        FontData[] fontData = title.getFont().getFontData();
        fontData[0].setStyle(1);
        title.setFont(new Font((Device)this.getDisplay(), fontData[0]));
        return title;
    }

    private Label createContent() {
        Label dummy = new Label((Composite)this, 0);
        this.setSizeHints(dummy, 0, 0);
        final Label content = new Label((Composite)this, 72);
        GridData gridData = new GridData(4, 128, true, false);
        content.setLayoutData((Object)gridData);
        this.getParent().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point size = content.computeSize(ModelConverterDescriptionLabels.this.getSize().x, -1, true);
                ModelConverterDescriptionLabels.this.setSizeHints(content, size.x, size.y);
                ModelConverterDescriptionLabels.this.resize();
            }
        });
        return content;
    }

    public void setConverterDescription(IModelConverterDescription converterDescription) {
        if (converterDescription == null) {
            converterDescription = NULL_DESCRIPTION;
        }
        this.update(this.fWarning, converterDescription.getWarning());
        this.update(this.fDescription, converterDescription.getBehaviorDetails());
        GridLayout gridLayout = (GridLayout)this.getLayout();
        gridLayout.verticalSpacing = !converterDescription.hasWarning() || !converterDescription.hasBehaviorDetails() ? 0 : 5;
        this.resize();
    }

    private void update(Section section, String content) {
        if (content != null) {
            section.content.setText(content);
            this.setSizeHints(section.icon, -1, -1);
            this.setSizeHints(section.title, -1, -1);
            Point size = section.content.computeSize(this.getSize().x, -1, true);
            this.setSizeHints(section.content, size.x, size.y);
        } else {
            section.content.setText("");
            this.setSizeHints(section.icon, 0, 0);
            this.setSizeHints(section.title, 0, 0);
            this.setSizeHints(section.content, 0, 0);
        }
    }

    private void setSizeHints(Label label, int width, int height) {
        GridData gridData = (GridData)label.getLayoutData();
        if (gridData == null) {
            gridData = new GridData();
        }
        gridData.widthHint = width;
        gridData.heightHint = height;
        label.setLayoutData((Object)gridData);
    }

    private void resize() {
        this.setSize(this.computeSize(this.getParent().getClientArea().width, -1));
    }

    private static class Section {
        Label icon;
        Label title;
        Label content;

        private Section() {
        }
    }
}

