/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.workspace.ui.preferences;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.eatop.common.resource.impl.EastADLXMLResourceImpl;
import org.eclipse.eatop.workspace.natures.EastADLNature;
import org.eclipse.eatop.workspace.ui.internal.Activator;
import org.eclipse.eatop.workspace.ui.preferences.EastADLPreferenceMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.sphinx.platform.ui.preferences.AbstractPreferenceAndPropertyPage;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class EastADLPreferencePage
extends AbstractPreferenceAndPropertyPage {
    private Group fLoadingGroup;
    private BooleanFieldEditorEx fSchemaValidationField;
    private RadioGroupFieldEditor fShemaValidationSeverityEditor;
    private Composite shemaValidationSeverityEditorParent;
    private BooleanFieldEditorEx fProblemIndicationField;
    private IntegerFieldEditor fMaxProblemEditor;
    private BooleanFieldEditorEx fCacheResources;
    private FieldEditor fClearCache;
    private Group fUuidHandlingGroup;
    private BooleanFieldEditorEx fSyncUuidField;

    public EastADLPreferencePage() {
        this(EastADLNature.ID, 1);
    }

    public EastADLPreferencePage(String requiredProjectNatureId, int style) {
        super(requiredProjectNatureId, style);
        this.setDescription(EastADLPreferenceMessages.EastADLPreferencePage_description);
    }

    protected String getPreferencePageID() {
        return "org.eclipse.eatop.workspace.ui.preferencePages.eastadl";
    }

    protected String getPropertyPageID() {
        return null;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getPlugin().getCommonPreferenceStore();
    }

    protected void enablePreferenceContent(boolean useProjectSpecificSettings) {
    }

    protected void addFields(Composite parent) {
        this.addLoadingGroup(parent);
        this.addUuidHandlingGroup(parent);
    }

    private void addLoadingGroup(Composite parent) {
        this.fLoadingGroup = new Group(parent, 0);
        this.fLoadingGroup.setText(EastADLPreferenceMessages.EastADLPreferencePage_loadingGroupText);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(6);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        this.fSchemaValidationField = new BooleanFieldEditorEx("xsd_validation_on_load", EastADLPreferenceMessages.EastADLPreferencePage_schemaValidationFieldLabel, 0, (Composite)this.fLoadingGroup);
        this.addField((FieldEditor)this.fSchemaValidationField);
        this.fCacheResources = new BooleanFieldEditorEx("use_binary_resource", EastADLPreferenceMessages.EastADLPreferencePage_useBinaryResources, 0, (Composite)this.fLoadingGroup);
        this.addField((FieldEditor)this.fCacheResources);
        this.fClearCache = new FieldEditor(){
            private Button button;
            {
                this.createControl((Composite)EastADLPreferencePage.this.fLoadingGroup);
            }

            protected void adjustForNumColumns(int numColumns) {
                if (this.button != null) {
                    ((GridData)this.button.getLayoutData()).horizontalSpan = numColumns;
                }
            }

            protected void doFillIntoGrid(Composite parent, int numColumns) {
                this.button = this.getChangeControl(parent);
                GridData gd = new GridData();
                gd.horizontalSpan = numColumns;
                this.button.setLayoutData((Object)gd);
            }

            protected void doLoad() {
            }

            protected void doLoadDefault() {
            }

            protected void doStore() {
            }

            public int getNumberOfControls() {
                return 2;
            }

            protected Button getChangeControl(Composite parent) {
                if (this.button == null) {
                    this.button = new Button(parent, 0x1000008);
                    this.button.setText("Clear cache");
                    this.button.setFont(parent.getFont());
                    this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            try {
                                IWorkbench wb = PlatformUI.getWorkbench();
                                IProgressService ps = wb.getProgressService();
                                ps.busyCursorWhile(new IRunnableWithProgress(){

                                    public void run(IProgressMonitor monitor) {
                                        EastADLXMLResourceImpl.clearCache((IProgressMonitor)monitor);
                                    }
                                });
                            }
                            catch (Exception ex) {
                                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
                            }
                        }
                    });
                    this.button.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent event) {
                            button = null;
                        }
                    });
                } else {
                    this.checkParent((Control)this.button, parent);
                }
                return this.button;
            }

            public void setEnabled(boolean enabled, Composite parent) {
                if (this.button != null) {
                    this.button.setEnabled(enabled);
                    this.button.redraw();
                }
            }
        };
        this.addField(this.fClearCache);
        this.shemaValidationSeverityEditorParent = new Composite((Composite)this.fLoadingGroup, 0);
        this.fShemaValidationSeverityEditor = new RadioGroupFieldEditor("xsd_validation_severity_level", EastADLPreferenceMessages.EastADLPreferencePage_schemaValidationSeverityLevel, 3, (String[][])new String[][]{{EastADLPreferenceMessages.EastADLPreferencePage_ErrorLabel, Integer.toString(2)}, {EastADLPreferenceMessages.EastADLPreferencePage_WarningLabel, Integer.toString(1)}, {EastADLPreferenceMessages.EastADLPreferencePage_InfoLabel, Integer.toString(0)}}, this.shemaValidationSeverityEditorParent);
        this.addField((FieldEditor)this.fShemaValidationSeverityEditor);
        this.fProblemIndicationField = new BooleanFieldEditorEx("limit_problem_indication_on_load", EastADLPreferenceMessages.EastADLPreferencePage_problemIndicationFieldLabel, 0, (Composite)this.fLoadingGroup);
        this.fProblemIndicationField.getChangeControl((Composite)this.fLoadingGroup).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EastADLPreferencePage.this.updateMaxProblemEditor();
            }
        });
        this.addField((FieldEditor)this.fProblemIndicationField);
        this.fMaxProblemEditor = new IntegerFieldEditor("max_problem_reported_on_load", EastADLPreferenceMessages.EastADLPreferencePage_maxProblemEditorlabel, (Composite)this.fLoadingGroup);
        this.fMaxProblemEditor.setValidRange(0, 1000);
        this.addField((FieldEditor)this.fMaxProblemEditor);
        this.fMaxProblemEditor.setEnabled(this.getPreferenceStore().getBoolean("limit_problem_indication_on_load"), (Composite)this.fLoadingGroup);
        this.fLoadingGroup.setLayoutData((Object)gridData);
        this.fLoadingGroup.setLayout((Layout)gridLayout);
        Dialog.applyDialogFont((Control)this.fLoadingGroup);
    }

    private void addUuidHandlingGroup(Composite parent) {
        this.fUuidHandlingGroup = new Group(parent, 0);
        this.fUuidHandlingGroup.setText(EastADLPreferenceMessages.EastADLPreferencePage_uuidHandlingGroupText);
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        this.fSyncUuidField = new BooleanFieldEditorEx("sync_uuids", EastADLPreferenceMessages.EastADLPreferencePage_syncUuidFieldLabel, 0, (Composite)this.fUuidHandlingGroup);
        this.addField((FieldEditor)this.fSyncUuidField);
        this.fUuidHandlingGroup.setLayoutData((Object)gridData);
        this.fUuidHandlingGroup.setLayout((Layout)gridLayout);
        Dialog.applyDialogFont((Control)this.fUuidHandlingGroup);
    }

    private void updateMaxProblemEditor() {
        Button b = this.fProblemIndicationField.getChangeControl((Composite)this.fLoadingGroup);
        this.fMaxProblemEditor.getTextControl((Composite)this.fLoadingGroup).setEnabled(b.getSelection());
        this.fMaxProblemEditor.getLabelControl((Composite)this.fLoadingGroup).setEnabled(b.getSelection());
    }

    public class BooleanFieldEditorEx
    extends BooleanFieldEditor {
        private Button fChangeControl;

        public BooleanFieldEditorEx(String name, String labelText, int style, Composite parent) {
            super(name, labelText, style, parent);
        }

        public Button getChangeControl(Composite parent) {
            if (this.fChangeControl == null) {
                this.fChangeControl = super.getChangeControl(parent);
            }
            return this.fChangeControl;
        }
    }
}

