/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.workspace.jobs;

import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.eatop.common.internal.Activator;
import org.eclipse.eatop.common.metamodel.EastADLReleaseDescriptor;
import org.eclipse.eatop.workspace.internal.messages.Messages;
import org.eclipse.eatop.workspace.natures.EastADLNature;
import org.eclipse.eatop.workspace.preferences.IEastADLWorkspacePreferences;
import org.eclipse.sphinx.platform.util.StatusUtil;

public class CreateEatopProjectJob
extends WorkspaceJob {
    private IProject project;
    private URI location;
    private IProject[] referencedProjects;
    private IAdaptable uiInfoAdaptable;
    private EastADLReleaseDescriptor eastadlRelease;

    public CreateEatopProjectJob(String name) {
        super(name);
        this.setPriority(40);
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public CreateEatopProjectJob(String name, IProject project, URI location, EastADLReleaseDescriptor eastadlRelease) {
        this(name);
        this.project = project;
        this.location = location;
        this.eastadlRelease = eastadlRelease;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public URI getLocation() {
        return this.location;
    }

    public void setLocation(URI location) {
        this.location = location;
    }

    public void setUiInfoAdaptable(IAdaptable uiInfoAdaptable) {
        this.uiInfoAdaptable = uiInfoAdaptable;
    }

    public IAdaptable getUiInfoAdaptable() {
        return this.uiInfoAdaptable;
    }

    public IProject[] getReferencedProjects() {
        return this.referencedProjects;
    }

    public void setReferencedProjects(IProject[] referencedProjects) {
        this.referencedProjects = referencedProjects;
    }

    public EastADLReleaseDescriptor getEastADLRelease() {
        return this.eastadlRelease;
    }

    public void setEastADLRelease(EastADLReleaseDescriptor eastadlRelease) {
        this.eastadlRelease = eastadlRelease;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(this.getName(), 4);
        monitor.setTaskName(this.getName());
        IStatus result = Status.OK_STATUS;
        try {
            result = this.createNewProject(monitor);
            if (result.getSeverity() != 0) {
                IStatus iStatus = result;
                return iStatus;
            }
            result = this.addNatures(monitor);
            if (result.getSeverity() != 0) {
                IStatus iStatus = result;
                return iStatus;
            }
            if (this.eastadlRelease != null) {
                IEastADLWorkspacePreferences.EAST_ADL_RELEASE.setInProject(this.project, (Object)this.eastadlRelease);
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    protected IStatus addNatures(IProgressMonitor monitor) {
        monitor.subTask(Messages.EastADLProjectJob_AddNatures);
        try {
            EastADLNature.addTo(this.project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (CoreException ex) {
            return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)((Object)ex));
        }
        return Status.OK_STATUS;
    }

    protected IStatus createNewProject(IProgressMonitor monitor) {
        IStatus result;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        monitor.subTask(Messages.EastADLProjectJob_createEASTADLProject);
        IProjectDescription description = workspace.newProjectDescription(this.project.getName());
        description.setLocationURI(this.location);
        if (this.referencedProjects != null && this.referencedProjects.length > 0) {
            description.setReferencedProjects(this.referencedProjects);
        }
        try {
            this.project.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.project.open(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            result = Status.OK_STATUS;
        }
        catch (CoreException ex) {
            result = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)((Object)ex));
        }
        return result;
    }
}

