/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.spi.swt.commands;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.ecp.edit.spi.swt.commands.IProgressMonitorConsumer;
import org.eclipse.emf.ecp.edit.spi.swt.commands.IProgressMonitorProvider;
import org.eclipse.emf.ecp.edit.spi.swt.commands.ProgressCompoundCommand;
import org.eclipse.emf.ecp.edit.spi.swt.commands.ProgressCopyCommandFactory;
import org.eclipse.emf.ecp.edit.spi.swt.commands.ProgressStrictCompoundCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class ProgressPasteFromClipboardCommand
extends PasteFromClipboardCommand
implements IProgressMonitorProvider {
    private IProgressMonitor monitor;

    public ProgressPasteFromClipboardCommand(EditingDomain domain, Object owner, Object feature, int index) {
        super(domain, owner, feature, index);
    }

    public ProgressPasteFromClipboardCommand(EditingDomain domain, Object owner, Object feature, int index, boolean optimize) {
        super(domain, owner, feature, index, optimize);
    }

    protected boolean prepare() {
        this.command = new ProgressStrictCompoundCommand(this);
        final Command copyCommand = ProgressCopyCommandFactory.create(this.domain, this.domain.getClipboard(), this);
        this.command.append(copyCommand);
        this.command.append((Command)new CommandWrapper(){
            protected Collection<Object> original;
            protected Collection<Object> copy;

            protected Command createCommand() {
                Command addCommand;
                this.original = ProgressPasteFromClipboardCommand.this.domain.getClipboard();
                this.copy = new ArrayList<Object>(copyCommand.getResult());
                if (this.original.size() == this.copy.size()) {
                    Iterator<Object> i = this.original.iterator();
                    Iterator<Object> j = this.copy.iterator();
                    while (i.hasNext()) {
                        Object originalObject = i.next();
                        Object copyObject = j.next();
                        if (originalObject.getClass() == copyObject.getClass()) continue;
                        this.original = null;
                        break;
                    }
                }
                if (IProgressMonitorConsumer.class.isInstance(addCommand = AddCommand.create((EditingDomain)ProgressPasteFromClipboardCommand.this.domain, (Object)ProgressPasteFromClipboardCommand.this.owner, (Object)ProgressPasteFromClipboardCommand.this.feature, this.original == null ? this.copy : this.original, (int)ProgressPasteFromClipboardCommand.this.index))) {
                    ((IProgressMonitorConsumer)IProgressMonitorConsumer.class.cast(addCommand)).setIProgressMonitorAccessor(ProgressPasteFromClipboardCommand.this);
                }
                return addCommand;
            }

            public void execute() {
                if (this.original != null) {
                    ProgressPasteFromClipboardCommand.this.domain.setClipboard(this.copy);
                }
                super.execute();
            }

            public void undo() {
                super.undo();
                if (this.original != null) {
                    ProgressPasteFromClipboardCommand.this.domain.setClipboard(this.original);
                }
            }

            public void redo() {
                if (this.original != null) {
                    ProgressPasteFromClipboardCommand.this.domain.setClipboard(this.copy);
                }
                super.redo();
            }
        });
        boolean result = this.optimize ? this.optimizedCanExecute() : this.command.canExecute();
        return result;
    }

    public void doExecute() {
        this.doExecuteWithProgress("Pasting elements...");
    }

    protected void doExecuteWithProgress(final String task) {
        try {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
            progressMonitorDialog.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ProgressPasteFromClipboardCommand.this.monitor = monitor;
                    monitor.beginTask(task, ProgressPasteFromClipboardCommand.this.getTotalWorkExecute());
                    ProgressPasteFromClipboardCommand.super.doExecute();
                    ProgressPasteFromClipboardCommand.this.monitor = null;
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected int getTotalWorkExecute() {
        int work = this.domain.getClipboard().size();
        List commandList = this.command.getCommandList();
        work += commandList.size();
        for (Command subCommand : commandList) {
            if (!ProgressCompoundCommand.class.isInstance(subCommand)) continue;
            work += ((ProgressCompoundCommand)((Object)ProgressCompoundCommand.class.cast(subCommand))).getCommandList().size();
        }
        return work;
    }

    public void doUndo() {
        this.doUndoWithProgress("Undoing paste operation");
    }

    protected void doUndoWithProgress(final String task) {
        try {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
            progressMonitorDialog.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ProgressPasteFromClipboardCommand.this.monitor = monitor;
                    monitor.beginTask(task, 1);
                    ProgressPasteFromClipboardCommand.super.doUndo();
                    ProgressPasteFromClipboardCommand.this.monitor = null;
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void doRedo() {
        this.doRedoWithProgress("Redoing paste operation.");
    }

    protected void doRedoWithProgress(final String task) {
        try {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
            progressMonitorDialog.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ProgressPasteFromClipboardCommand.this.monitor = monitor;
                    monitor.beginTask(task, 1);
                    ProgressPasteFromClipboardCommand.super.doRedo();
                    ProgressPasteFromClipboardCommand.this.monitor = null;
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }
}

