/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.presentation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edapt.common.ui.ModelSash;
import org.eclipse.emf.edapt.common.ui.SyncedMetamodelEditorViewBase;
import org.eclipse.emf.edapt.history.util.HistoryUtils;
import org.eclipse.emf.edapt.spi.history.Change;
import org.eclipse.emf.edapt.spi.history.Delete;
import org.eclipse.emf.edapt.spi.history.History;
import org.eclipse.emf.edapt.spi.history.NonDelete;
import org.eclipse.emf.edapt.spi.history.ValueChange;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;

public class ElementChangesView
extends SyncedMetamodelEditorViewBase {
    public static final String ID = ElementChangesView.class.getName();
    private ModelSash sash;

    protected void createContents(Composite parent) {
        this.sash = new ModelSash(parent, 0);
        this.sash.getStructureViewer().setSorter(null);
        this.sash.getStructureViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ElementChangesView.this.getEditor().getViewer().setSelection((ISelection)new StructuredSelection(selection.getFirstElement()), true);
            }
        });
    }

    public void setFocus() {
        this.sash.getStructureViewer().getTree().setFocus();
    }

    protected void selectionChanged(IStructuredSelection structuredSelection) {
        Object firstElement;
        if (structuredSelection.size() == 1 && (firstElement = structuredSelection.getFirstElement()) instanceof EObject) {
            this.update((EObject)firstElement);
        }
    }

    private void update(EObject element) {
        History history = this.getHistory();
        if (history != null) {
            this.sash.getStructureViewer().setInput((Object)history);
            List<Change> changes = this.getChanges(element);
            final Set<EObject> elements = this.enrich(changes);
            this.sash.getStructureViewer().setFilters(new ViewerFilter[]{new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return elements.contains(element);
                }
            }});
            this.sash.getStructureViewer().expandToLevel(2);
        }
    }

    private Set<EObject> enrich(List<Change> changes) {
        HashSet<EObject> elements = new HashSet<EObject>();
        Iterator<Change> iterator = changes.iterator();
        while (iterator.hasNext()) {
            Change change;
            Change element = change = iterator.next();
            while (element != null) {
                elements.add((EObject)element);
                element = element.eContainer();
            }
        }
        return elements;
    }

    private List<Change> getChanges(EObject element) {
        if (element instanceof Change && this.getElement((Change)element) != null) {
            element = this.getElement((Change)element);
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        History history = this.getHistory();
        if (history != null) {
            TreeIterator i = history.eAllContents();
            while (i.hasNext()) {
                Change change;
                EObject historyElement = (EObject)i.next();
                if (!(historyElement instanceof Change) || this.getElement(change = (Change)historyElement) != element) continue;
                changes.add(change);
            }
        }
        return changes;
    }

    private History getHistory() {
        Resource resource = HistoryUtils.getHistoryResource((ResourceSet)this.getEditor().getEditingDomain().getResourceSet());
        return resource != null ? (History)resource.getContents().get(0) : null;
    }

    private EObject getElement(Change change) {
        if (change instanceof NonDelete) {
            return ((NonDelete)change).getElement();
        }
        if (change instanceof Delete) {
            return ((Delete)change).getElement();
        }
        if (change instanceof ValueChange) {
            return ((ValueChange)change).getElement();
        }
        return null;
    }
}

