/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc.comm;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.log.Logger;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

class ConnectionInfo {
    Object conn;
    Throwable thr = null;
    ConnectionEventListener listener = null;
    boolean validating = false;
    long idleStartTime = System.currentTimeMillis();
    long creationTime = System.currentTimeMillis();

    ConnectionInfo(Object conn, ConnectionEventListener listener) {
        this.conn = conn;
        this.listener = listener;
        if (conn instanceof PooledConnection) {
            ((PooledConnection)conn).addConnectionEventListener(listener);
        }
    }

    public Object getKey() {
        return this.conn;
    }

    public void idleStart() {
        this.idleStartTime = System.currentTimeMillis();
    }

    public long getIdleStartTime() {
        return this.idleStartTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setValidating(boolean b) {
        this.validating = b;
    }

    public boolean inValidating() {
        return this.validating;
    }

    public void setException(Throwable t) {
        this.thr = t;
    }

    public Throwable getException() {
        return this.thr;
    }

    public Connection getConnection() throws SQLException {
        if (this.conn instanceof PooledConnection) {
            return ((PooledConnection)this.conn).getConnection();
        }
        return (Connection)this.conn;
    }

    public void destroy() {
        try {
            if (this.conn instanceof PooledConnection) {
                ((PooledConnection)this.conn).removeConnectionEventListener(this.listener);
                ((PooledConnection)this.conn).close();
            } else {
                ((Connection)this.conn).close();
            }
        }
        catch (Throwable t) {
            Logger logger = Globals.getLogger();
            Globals.getLogger();
            Globals.getBrokerResources();
            logger.log(16, "B2229", (Object)this.toString(), (Object)t.toString());
        }
    }

    public String toString() {
        return (this.conn instanceof Connection ? "[Connection" : "[PooledConnection") + ":0x" + this.conn.hashCode() + ", lastIdleTime=" + this.idleStartTime + (String)(this.thr == null ? "" : ", " + this.thr.toString()) + "]";
    }
}

