/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMember;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.security.AccessController;
import java.util.Collections;
import java.util.Set;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.producer.AbstractMemberProducer;
import org.jboss.weld.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.UtilLogger;
import org.jboss.weld.security.GetAccessibleCopyOfMember;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

public abstract class ProducerFieldProducer<X, T>
extends AbstractMemberProducer<X, T> {
    private final Field accessibleField;

    public ProducerFieldProducer(EnhancedAnnotatedField<T, ? super X> enhancedField, DisposalMethod<?, ?> disposalMethod) {
        super(enhancedField, disposalMethod);
        this.accessibleField = (Field)AccessController.doPrivileged(new GetAccessibleCopyOfMember<Member>(enhancedField.getJavaMember()));
        this.checkProducerField(enhancedField);
    }

    protected void checkProducerField(EnhancedAnnotatedField<T, ? super X> enhancedField) {
        if (this.getDeclaringBean() instanceof SessionBean && !enhancedField.isStatic()) {
            throw BeanLogger.LOG.producerFieldOnSessionBeanMustBeStatic(enhancedField, enhancedField.getDeclaringType());
        }
        if (enhancedField.isAnnotationPresent(Inject.class)) {
            if (this.getDeclaringBean() != null) {
                throw BeanLogger.LOG.injectedFieldCannotBeProducer(enhancedField, this.getDeclaringBean());
            }
            throw BeanLogger.LOG.injectedFieldCannotBeProducer(enhancedField, enhancedField.getDeclaringType());
        }
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    @Override
    public abstract AnnotatedField<? super X> getAnnotated();

    @Override
    public T produce(Object receiver, CreationalContext<T> creationalContext) {
        if (receiver instanceof TargetInstanceProxy) {
            receiver = ((TargetInstanceProxy)Reflections.cast(receiver)).weld_getTargetInstance();
        }
        try {
            return Reflections.cast(this.accessibleField.get(receiver));
        }
        catch (IllegalAccessException e) {
            throw UtilLogger.LOG.accessErrorOnField(this.accessibleField.getName(), this.accessibleField.getDeclaringClass(), e);
        }
    }

    @Override
    public String toString() {
        return this.getAnnotated().toString();
    }

    @Override
    protected DefinitionException producerWithInvalidTypeVariable(AnnotatedMember<?> member) {
        return BeanLogger.LOG.producerFieldTypeInvalidTypeVariable(member, Formats.formatAsStackTraceElement(member.getJavaMember()));
    }

    @Override
    protected DefinitionException producerWithInvalidWildcard(AnnotatedMember<?> member) {
        return BeanLogger.LOG.producerFieldCannotHaveAWildcardBeanType(member, Formats.formatAsStackTraceElement(member.getJavaMember()));
    }

    @Override
    protected DefinitionException producerWithParameterizedTypeWithTypeVariableBeanTypeMustBeDependent(AnnotatedMember<?> member) {
        return BeanLogger.LOG.producerFieldWithTypeVariableBeanTypeMustBeDependent(member, Formats.formatAsStackTraceElement(member.getJavaMember()));
    }
}

