/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.impl;

import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import com.sun.prism.Graphics;
import com.sun.prism.PixelFormat;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.paint.Paint;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javafx.scene.paint.Color;
import org.eclipse.fx.drift.DriftFXSurface;
import org.eclipse.fx.drift.internal.GraphicsPipelineUtil;
import org.eclipse.fx.drift.internal.JNINativeSurface;
import org.eclipse.fx.drift.internal.NativeAPI;

public class NGDriftFXSurface
extends NGNode {
    private long nativeSurfaceHandle;
    private float width;
    private float height;
    private ResourceFactory resourceFactory;
    private DriftFXSurface node;
    private JNINativeSurface.FrameData currentFrameData;
    private int currentFrameDataHash;
    private Texture currentTexture;
    static Executor fixer = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    });

    public void present(JNINativeSurface.FrameData frame) {
        this.currentFrameData = frame;
    }

    public NGDriftFXSurface(DriftFXSurface node, long nativeSurfaceId) {
        this.node = node;
        this.nativeSurfaceHandle = nativeSurfaceId;
        System.out.println("[J] NGNativeSurface got handle: " + this.nativeSurfaceHandle);
        this.resourceFactory = GraphicsPipelineUtil.getResourceFactory();
    }

    public void destroy() {
        NativeAPI.destroyNativeSurface(this.nativeSurfaceHandle);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    private void renderPlaceholder(Graphics g) {
        Paint white = (Paint)Toolkit.getPaintAccessor().getPlatformPaint((javafx.scene.paint.Paint)Color.WHITE);
        g.setPaint(white);
        g.fillQuad(0.0f, 0.0f, this.width, this.height);
        Paint red = (Paint)Toolkit.getPaintAccessor().getPlatformPaint((javafx.scene.paint.Paint)Color.RED);
        g.setPaint(red);
        g.drawRect(0.0f, 0.0f, this.width - 1.0f, this.height - 1.0f);
    }

    private int getWidth() {
        return Math.max(1, (int)Math.ceil(this.width));
    }

    private int getHeight() {
        return Math.max(1, (int)Math.ceil(this.height));
    }

    private Texture createTexture(Graphics g, JNINativeSurface.FrameData data) {
        int w = this.currentFrameData.width;
        int h = this.currentFrameData.height;
        Texture texture = this.resourceFactory.createTexture(PixelFormat.BYTE_BGRA_PRE, Texture.Usage.DYNAMIC, Texture.WrapMode.CLAMP_NOT_NEEDED, w, h);
        if (texture == null) {
            System.err.println("[J] Allocation of requested texture failed! This is FATAL! requested size was " + w + "x" + h);
            System.err.flush();
            System.exit(1);
        }
        texture.makePermanent();
        ReentrantLock lock = new ReentrantLock();
        Condition done = lock.newCondition();
        lock.lock();
        fixer.execute(() -> {
            lock.lock();
            GraphicsPipelineUtil.onTextureCreated(texture, this.currentFrameData);
            done.signal();
            lock.unlock();
        });
        try {
            done.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        int result = 0;
        if (result == 0) {
            return texture;
        }
        System.err.println("Result was " + result);
        texture.dispose();
        return null;
    }

    protected void renderContent(Graphics g) {
        int hash;
        int width = this.getWidth();
        int height = this.getHeight();
        g.scale(1.0f, -1.0f);
        g.translate(0.0f, (float)(-height));
        if (this.currentFrameData != null && this.currentFrameData.width != 0 && this.currentFrameData.height != 0 && (hash = this.currentFrameData.hashCode()) != this.currentFrameDataHash) {
            this.currentFrameDataHash = hash;
            Texture texture = this.createTexture(g, this.currentFrameData);
            if (texture != null) {
                if (this.currentTexture != null) {
                    this.currentTexture.dispose();
                }
                this.currentTexture = texture;
            } else {
                System.err.println("[J] [WARNING] Surface# \"+nativeSurfaceHandle+\": Could not recreate texture, keeping old one.");
            }
        }
        if (this.currentTexture != null) {
            int textureWidth = this.currentTexture.getContentWidth();
            int textureHeight = this.currentTexture.getContentHeight();
            int containerWidth = width;
            int containerHeight = height;
            float textureRatio = (float)textureWidth / (float)textureHeight;
            float containerRatio = (float)containerWidth / (float)containerHeight;
            int finalWidth = textureWidth;
            int finalHeight = textureHeight;
            if (textureRatio <= containerRatio) {
                finalWidth = Math.round((float)containerHeight * textureRatio);
                finalHeight = containerHeight;
            } else {
                finalWidth = containerWidth;
                finalHeight = Math.round((float)containerWidth / textureRatio);
            }
            int x = 0;
            int y = 0;
            x = Math.round((float)(width - finalWidth) / 2.0f);
            y = Math.round((float)(height - finalHeight) / 2.0f);
            System.out.println("[J] [Info ] Surface# " + this.nativeSurfaceHandle + ": Drawing texture " + GraphicsPipelineUtil.getTextureHandle(this.currentTexture));
            g.drawTexture(this.currentTexture, (float)x, (float)y, (float)(x + finalWidth), (float)(y + finalHeight), 0.0f, 0.0f, (float)textureWidth, (float)textureHeight);
        } else {
            System.err.println("[J][Info ] current Texture == null");
        }
    }

    public void updateSize(float width, float height) {
        if (width != -1.0f) {
            this.width = width;
        }
        if (height != -1.0f) {
            this.height = height;
        }
        CompletableFuture.runAsync(() -> NativeAPI.updateSize(this.nativeSurfaceHandle, this.getWidth(), this.getHeight()));
    }

    protected boolean hasOverlappingContents() {
        return false;
    }
}

