/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.model;

import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeItem;

class ReviewTableSorter
extends ViewerSorter {
    private int fColumnIndex = 0;
    private static final String VERIFIED = "Verified";
    private static final String CODE_REVIEW = "Code-Review";

    ReviewTableSorter(int columnIndex) {
        this.fColumnIndex = columnIndex;
    }

    public int compare(Viewer viewer, Object item1, Object item2) {
        int result;
        int sortDirection;
        block11: {
            block10: {
                sortDirection = this.getSortDirection(viewer);
                result = 0;
                if (!(viewer instanceof TableViewer) || !(item1 instanceof ChangeInfo) || !(item2 instanceof ChangeInfo)) break block10;
                ChangeInfo changeInfo1 = (ChangeInfo)item1;
                ChangeInfo changeInfo2 = (ChangeInfo)item2;
                String val1 = null;
                String val2 = null;
                switch (this.fColumnIndex) {
                    case 0: {
                        val1 = Boolean.toString(changeInfo1.isStarred());
                        val2 = Boolean.toString(changeInfo2.isStarred());
                        if (val1 != null && val2 != null) {
                            result = val1.compareTo(val2);
                            break;
                        }
                        break block11;
                    }
                    case 1: {
                        result = changeInfo2.get_number() - changeInfo1.get_number();
                        break;
                    }
                    case 7: {
                        val1 = changeInfo1.getUpdated();
                        val2 = changeInfo2.getUpdated();
                        if (val1 != null && val2 != null) {
                            result = val1.compareTo(val2);
                            break;
                        }
                        break block11;
                    }
                    case 8: {
                        result = changeInfo2.getMostRelevantVote(CODE_REVIEW).getValue() - changeInfo1.getMostRelevantVote(CODE_REVIEW).getValue();
                        break;
                    }
                    case 9: {
                        result = changeInfo2.getMostRelevantVote(VERIFIED).getValue() - changeInfo1.getMostRelevantVote(VERIFIED).getValue();
                        break;
                    }
                    default: {
                        result = this.defaultCompare(viewer, item1, item2);
                        break;
                    }
                }
                break block11;
            }
            result = this.defaultCompare(viewer, item1, item2);
        }
        if (sortDirection != 128) {
            result = -result;
        }
        return result;
    }

    private int getSortDirection(Viewer viewer) {
        int sortDirection = 0;
        if (viewer instanceof TableViewer) {
            sortDirection = ((TableViewer)viewer).getTable().getSortDirection();
        } else if (viewer instanceof TreeViewer) {
            sortDirection = ((TreeViewer)viewer).getTree().getSortDirection();
        }
        return sortDirection;
    }

    private int defaultCompare(Viewer aViewer, Object aE1, Object aE2) {
        if (aViewer instanceof TableViewer) {
            return this.defaultTableSorter(aViewer, aE1, aE2);
        }
        if (aViewer instanceof TreeViewer) {
            return this.defaultTreeSorter(aViewer, aE1, aE2);
        }
        return 0;
    }

    private int defaultTreeSorter(Viewer aViewer, Object aE1, Object aE2) {
        TreeViewer tv = (TreeViewer)aViewer;
        tv.getTree().setSortColumn(tv.getTree().getColumn(this.fColumnIndex));
        int idx1 = -1;
        int idx2 = -1;
        TreeItem[] listObj = tv.getTree().getItems();
        int i = 0;
        while (i < listObj.length) {
            Object obj = listObj[i].getData();
            listObj[i].setExpanded(true);
            if (obj != null) {
                if (obj.equals(aE1)) {
                    idx1 = i;
                } else if (obj.equals(aE2)) {
                    idx2 = i;
                }
                if (idx1 > 0 && idx2 > 0) break;
            }
            ++i;
        }
        int order = 0;
        if (idx1 > -1 && idx2 > -1) {
            String str1 = tv.getTree().getItems()[idx1].getText(this.fColumnIndex);
            String str2 = tv.getTree().getItems()[idx2].getText(this.fColumnIndex);
            order = str1.compareTo(str2);
        }
        return order;
    }

    private int defaultTableSorter(Viewer aViewer, Object aE1, Object aE2) {
        TableViewer tv = (TableViewer)aViewer;
        tv.getTable().setSortColumn(tv.getTable().getColumn(this.fColumnIndex));
        int idx1 = -1;
        int idx2 = -1;
        int i = 0;
        while (i < tv.getTable().getItemCount()) {
            Object obj = tv.getElementAt(i);
            if (obj.equals(aE1)) {
                idx1 = i;
            } else if (obj.equals(aE2)) {
                idx2 = i;
            }
            if (idx1 != -1 && idx2 != -1) break;
            ++i;
        }
        int order = 0;
        if (idx1 > -1 && idx2 > -1) {
            String str1 = tv.getTable().getItems()[idx1].getText(this.fColumnIndex);
            String str2 = tv.getTable().getItems()[idx2].getText(this.fColumnIndex);
            order = str1.compareTo(str2);
        }
        return order;
    }

    static void bind(final TableViewer aTableViewer) {
        int i = 0;
        while (i < aTableViewer.getTable().getColumnCount()) {
            final int columnNum = i;
            TableColumn column = aTableViewer.getTable().getColumn(i);
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReviewTableSorter sorter = new ReviewTableSorter(columnNum);
                    Table table = aTableViewer.getTable();
                    TableColumn currentColumn = (TableColumn)e.widget;
                    table.setSortColumn(currentColumn);
                    table.setSortDirection(table.getSortDirection() == 128 ? 1024 : 128);
                    aTableViewer.setComparator((ViewerComparator)sorter);
                    aTableViewer.setSelection(aTableViewer.getSelection(), true);
                }
            });
            ++i;
        }
    }
}

