/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.command.GetContentFromCommitCommand;
import org.eclipse.egerrit.internal.core.command.GetDiffCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.CommentInfo;
import org.eclipse.egerrit.internal.model.DiffContent;
import org.eclipse.egerrit.internal.model.DiffInfo;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.compare.CommentableCompareItem;
import org.eclipse.egerrit.internal.ui.compare.GerritCompareHelper;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommitCompareItem
extends CommentableCompareItem
implements IStreamContentAccessor,
ITypedElement {
    private static Logger logger = LoggerFactory.getLogger(CommitCompareItem.class);
    private static final String PARENT = "PARENT";
    private ChangeInfo changeInfo;
    private int baseRevision;
    private String filePath;
    private String revisionId;
    private int revisionNumber;

    public CommitCompareItem(GerritClient gerrit, RevisionInfo revision, FileInfo fileInfo, String fileName, int baseRevision) {
        super(PARENT);
        this.gerrit = gerrit;
        this.changeInfo = revision.getChangeInfo();
        this.revisionId = revision.getId();
        this.revisionNumber = revision.get_number();
        this.fileInfo = fileInfo;
        if (fileInfo == null) {
            throw new IllegalStateException();
        }
        this.filePath = fileName;
        if (this.filePath == null) {
            this.filePath = fileInfo.getPath();
            if (this.filePath == null) {
                throw new IllegalStateException();
            }
        }
        if (baseRevision > 0) {
            this.baseRevision = baseRevision;
        }
    }

    public String getName() {
        return GerritCompareHelper.extractFilename(this.getOldPathOrPath());
    }

    @Override
    public String getUserReadableName() {
        if (this.baseRevision > 0) {
            return NLS.bind((String)Messages.CompareElementPatchSetWithCommitId, (Object[])new Object[]{this.baseRevision, this.getName(), GerritCompareHelper.shortenCommitId(this.getBaseCommitId(this.fileInfo))});
        }
        return NLS.bind((String)Messages.CompareElementBase, (Object)this.getName(), (Object)GerritCompareHelper.shortenCommitId(this.getBaseCommitId(this.fileInfo)));
    }

    private String getOldPathOrPath() {
        if (this.filePath != null) {
            return this.filePath;
        }
        if (this.fileInfo.getOld_path() == null) {
            return this.fileInfo.getPath();
        }
        return this.fileInfo.getOld_path();
    }

    @Override
    protected byte[] loadFileContent() {
        GetDiffCommand getDiff = this.gerrit.getDiff(this.changeInfo.getChange_id(), this.revisionId, this.filePath, this.baseRevision);
        try {
            DiffInfo info = (DiffInfo)getDiff.call();
            if (this.contentSkipped(info) || info.isBinary()) {
                return this.getBinary();
            }
            return this.recreateFile(info);
        }
        catch (EGerritException e) {
            logger.debug("Exception retrieving content through diff", (Throwable)e);
            return new byte[0];
        }
    }

    private boolean contentSkipped(DiffInfo info) {
        for (DiffContent content : info.getContent()) {
            if (content.getSkip() == 0) continue;
            return true;
        }
        return false;
    }

    private byte[] getBinary() {
        GetContentFromCommitCommand getContent = this.gerrit.getContentFromCommit(this.changeInfo.getProject(), this.getBaseCommitId(this.fileInfo), this.getOldPathOrPath());
        try {
            String encodedFile = (String)getContent.call();
            this.setFileType(getContent.getFileMimeType());
            return Base64.decodeBase64((String)encodedFile);
        }
        catch (EGerritException e) {
            logger.debug("Exception retrieving commitId", (Throwable)e);
            return new byte[0];
        }
    }

    private byte[] recreateFile(DiffInfo info) {
        EList content = info.getContent();
        BasicEList allStrings = new BasicEList();
        for (DiffContent diffContent : content) {
            if (this.revisionNumber > this.baseRevision) {
                allStrings.addAll((Collection)diffContent.getA());
            }
            allStrings.addAll((Collection)diffContent.getAb());
            if (this.revisionNumber >= this.baseRevision) continue;
            allStrings.addAll((Collection)diffContent.getB());
        }
        int count = 0;
        for (String string : allStrings) {
            count += string.length() + 1;
        }
        StringBuilder sb = new StringBuilder(count);
        for (String string : allStrings) {
            sb.append(string);
            sb.append('\n');
        }
        return sb.toString().getBytes();
    }

    @Override
    protected EList<CommentInfo> filterComments(EList<CommentInfo> eList) {
        return (EList)eList.stream().filter(comment -> PARENT.equals(comment.getSide())).collect(Collectors.toCollection(BasicEList::new));
    }

    private String getBaseCommitId(FileInfo fileInfo) {
        return fileInfo.getRevision().getBaseCommit();
    }
}

