/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.Status;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.editors.ChangeDetailEditor;
import org.eclipse.egerrit.internal.ui.editors.model.ChangeDetailEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ShowNextPatchSetHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent aEvent) {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)aEvent);
        if (editor instanceof ChangeDetailEditor) {
            ChangeDetailEditorInput input = (ChangeDetailEditorInput)((ChangeDetailEditor)editor).getEditorInput();
            ArrayList revisions = new ArrayList(input.getChange().getRevisions().values());
            revisions.sort((o2, o1) -> o1.get_number() - o2.get_number());
            LinkedHashMap<String, RevisionInfo> patchNumber = new LinkedHashMap<String, RevisionInfo>();
            ListIterator iter = revisions.listIterator();
            while (iter.hasNext()) {
                RevisionInfo element = (RevisionInfo)iter.next();
                patchNumber.put(Integer.toString(element.get_number()), element);
            }
            Iterator itr = patchNumber.entrySet().iterator();
            Iterator first = patchNumber.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                if (((RevisionInfo)entry.getValue()).get_number() != input.getChange().getUserSelectedRevision().get_number()) continue;
                entry = itr.hasNext() ? itr.next() : first.next();
                input.getChange().setUserSelectedRevision((RevisionInfo)entry.getValue());
                break;
            }
        }
        return Status.OK_STATUS;
    }
}

