/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.io.FileInputStream;
import java.util.HashSet;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.util.NB;
import org.kohsuke.args4j.Argument;

@Command
class ReadChangedPathFilter
extends TextBuiltin {
    static final int CHUNK_ID_OID_FANOUT = 1330201670;
    static final int CHUNK_ID_BLOOM_FILTER_INDEX = 1112097880;
    static final int CHUNK_ID_BLOOM_FILTER_DATA = 1111769428;
    @Argument(index=0)
    private String input;

    ReadChangedPathFilter() {
    }

    static HashSet<String> changedPathStrings(byte[] data) {
        int oidf_offset = -1;
        int bidx_offset = -1;
        int bdat_offset = -1;
        int i = 8;
        while (i < data.length - 4) {
            switch (NB.decodeInt32((byte[])data, (int)i)) {
                case 1330201670: {
                    oidf_offset = (int)NB.decodeInt64((byte[])data, (int)(i + 4));
                    break;
                }
                case 1112097880: {
                    bidx_offset = (int)NB.decodeInt64((byte[])data, (int)(i + 4));
                    break;
                }
                case 1111769428: {
                    bdat_offset = (int)NB.decodeInt64((byte[])data, (int)(i + 4));
                }
            }
            i += 12;
        }
        bdat_offset += 12;
        int commit_count = NB.decodeInt32((byte[])data, (int)(oidf_offset + 1020));
        int[] changed_path_length_cumuls = new int[commit_count];
        int i2 = 0;
        while (i2 < commit_count) {
            changed_path_length_cumuls[i2] = NB.decodeInt32((byte[])data, (int)(bidx_offset + i2 * 4));
            ++i2;
        }
        HashSet<String> changed_paths = new HashSet<String>();
        int i3 = 0;
        while (i3 < commit_count) {
            int prior_cumul = i3 == 0 ? 0 : changed_path_length_cumuls[i3 - 1];
            Object changed_path = "";
            int j = prior_cumul;
            while (j < changed_path_length_cumuls[i3]) {
                changed_path = (String)changed_path + data[bdat_offset + j] + ",";
                ++j;
            }
            changed_paths.add((String)changed_path);
            ++i3;
        }
        return changed_paths;
    }

    @Override
    protected void run() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream in = new FileInputStream(this.input);){
            byte[] data = in.readAllBytes();
            this.outw.println(ReadChangedPathFilter.changedPathStrings(data).toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

