/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.p2order;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.mrtree.ILayoutPhase;
import org.eclipse.elk.alg.mrtree.IntermediateProcessingConfiguration;
import org.eclipse.elk.alg.mrtree.graph.TEdge;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.mrtree.properties.InternalProperties;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.properties.PropertyHolderComparator;

public class NodeOrderer
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration INTERMEDIATE_PROCESSING_CONFIGURATION = new IntermediateProcessingConfiguration(1, EnumSet.of(IntermediateProcessorStrategy.ROOT_PROC, IntermediateProcessorStrategy.FAN_PROC));

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(TGraph graph) {
        return INTERMEDIATE_PROCESSING_CONFIGURATION;
    }

    @Override
    public void process(TGraph tGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Processor arrange node", 1.0f);
        TNode root = null;
        LinkedList<TNode> roots = new LinkedList<TNode>();
        Iterator<TNode> it = tGraph.getNodes().iterator();
        while (root == null && it.hasNext()) {
            TNode tNode = it.next();
            if (!((Boolean)tNode.getProperty(InternalProperties.ROOT)).booleanValue()) continue;
            root = tNode;
        }
        roots.add(root);
        this.orderLevel(roots, progressMonitor.subTask(1.0f));
        progressMonitor.done();
    }

    private void orderLevel(LinkedList<TNode> currentLevel, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Processor arrange level", 1.0f);
        int pos = 0;
        Collections.sort(currentLevel, PropertyHolderComparator.with(InternalProperties.FAN));
        int firstOcc = currentLevel.size();
        ListIterator<TNode> it = currentLevel.listIterator(currentLevel.size());
        boolean notNull = true;
        while (notNull && it.hasPrevious()) {
            TNode tNode = it.previous();
            if ((Integer)tNode.getProperty(InternalProperties.FAN) == 0) {
                --firstOcc;
                continue;
            }
            notNull = false;
        }
        List tmp = currentLevel.subList(0, firstOcc);
        LinkedList inners = new LinkedList(tmp);
        tmp = currentLevel.subList(firstOcc, currentLevel.size());
        LinkedList leaves = new LinkedList(tmp);
        if (inners.isEmpty()) {
            for (TNode tENode : leaves) {
                tENode.setProperty(InternalProperties.POSITION, pos++);
            }
        } else {
            int size = inners.size();
            for (TNode tPNode : inners) {
                tPNode.setProperty(InternalProperties.POSITION, pos++);
                LinkedList<TNode> children = tPNode.getChildrenCopy();
                this.orderLevel(children, progressMonitor.subTask((float)(1 / size)));
                Collections.sort(children, Collections.reverseOrder(PropertyHolderComparator.with(InternalProperties.POSITION)));
                LinkedList<TEdge> sortedOutEdges = new LinkedList<TEdge>();
                for (TNode tNode : children) {
                    for (TEdge tEdge : tPNode.getOutgoingEdges()) {
                        if (tEdge.getTarget() != tNode) continue;
                        sortedOutEdges.add(tEdge);
                    }
                }
                tPNode.getOutgoingEdges().clear();
                tPNode.getOutgoingEdges().addAll(sortedOutEdges);
                it = leaves.listIterator(leaves.size());
                int fillGap = tPNode.getOutgoingEdges().size();
                notNull = true;
                while (fillGap > 0 && notNull && it.hasPrevious()) {
                    TNode tNode = it.previous();
                    if ((Integer)tNode.getProperty(InternalProperties.FAN) == 0) {
                        tNode.setProperty(InternalProperties.POSITION, pos++);
                        --fillGap;
                        it.remove();
                        continue;
                    }
                    notNull = false;
                }
            }
        }
        progressMonitor.done();
    }
}

