/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.text.conversion;

import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class NumberValueConverter
extends AbstractValueConverter<Double> {
    public String toString(Double value) throws ValueConverterException {
        if (value == null) {
            throw new ValueConverterException("Double value may not be null.", null, null);
        }
        return value.toString();
    }

    public Double toValue(String string, INode node) throws ValueConverterException {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)string);
        if (_isNullOrEmpty) {
            throw new ValueConverterException("Cannot convert empty string to a double value.", node, null);
        }
        try {
            return Double.valueOf(string);
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                NumberFormatException e = (NumberFormatException)_t;
                throw new ValueConverterException("Cannot convert '" + string + "' to a double value.", node, (Exception)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }
}

