/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.meta.validation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.elk.core.meta.metaData.MdAlgorithm;
import org.eclipse.elk.core.meta.metaData.MdBundle;
import org.eclipse.elk.core.meta.metaData.MdBundleMember;
import org.eclipse.elk.core.meta.metaData.MdCategory;
import org.eclipse.elk.core.meta.metaData.MdGroup;
import org.eclipse.elk.core.meta.metaData.MdOption;
import org.eclipse.elk.core.meta.metaData.MetaDataPackage;
import org.eclipse.elk.core.meta.validation.AbstractMetaDataValidator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;

public class MetaDataValidator
extends AbstractMetaDataValidator {
    @Check
    public void checkDuplicateMemberId(MdBundle bundle) {
        this.checkDuplicateIds((Iterable<? extends MdBundleMember>)bundle.getMembers());
    }

    private void checkDuplicateIds(Iterable<? extends MdBundleMember> elements) {
        HashMap algorithmIds = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        HashMap categoryIds = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        HashMap propertyIds = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        HashMap groupIds = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        for (MdBundleMember mdBundleMember : elements) {
            boolean _matched = false;
            if (mdBundleMember instanceof MdAlgorithm) {
                _matched = true;
                this.checkExistsAndRemember(algorithmIds, (MdAlgorithm)mdBundleMember);
            }
            if (!_matched && mdBundleMember instanceof MdCategory) {
                _matched = true;
                this.checkExistsAndRemember(categoryIds, (MdCategory)mdBundleMember);
            }
            if (!_matched && mdBundleMember instanceof MdGroup) {
                _matched = true;
                this.checkExistsAndRemember(groupIds, (MdGroup)mdBundleMember);
                this.checkDuplicateIds((Iterable<? extends MdBundleMember>)((MdGroup)mdBundleMember).getChildren());
            }
            if (_matched || !(mdBundleMember instanceof MdOption)) continue;
            _matched = true;
            this.checkExistsAndRemember(propertyIds, (MdOption)mdBundleMember);
        }
    }

    private <T extends MdBundleMember> void checkExistsAndRemember(Map<String, T> map, T element) {
        boolean _containsKey = map.containsKey(element.getName());
        if (_containsKey) {
            MdBundleMember otherMember = (MdBundleMember)map.get(element.getName());
            if (otherMember != null) {
                this.duplicateId(otherMember);
                map.put(element.getName(), null);
            }
            this.duplicateId(element);
        } else {
            map.put(element.getName(), element);
        }
    }

    private void duplicateId(MdBundleMember member) {
        String _name = member.getName();
        String _plus = "The id '" + _name;
        String _plus_1 = String.valueOf(_plus) + "' is already used.";
        this.error(_plus_1, member, (EStructuralFeature)MetaDataPackage.Literals.MD_BUNDLE_MEMBER__NAME);
    }
}

