/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.calculators;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopEdge;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopLabel;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopLabelPosition;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNodeSide;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopOpposingSegment;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.p5edges.splines.SplinesMath;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;

public final class SelfLoopOffsetCalculator {
    private SelfLoopOffsetCalculator() {
    }

    public static void calculatePortLabelOffsets(SelfLoopNode slNode) {
        double edgeEdgeSpacing = LGraphUtil.getIndividualOrInherited(slNode.getNode(), LayeredOptions.SPACING_EDGE_EDGE);
        double edgeLabelSpacing = LGraphUtil.getIndividualOrInherited(slNode.getNode(), LayeredOptions.SPACING_EDGE_LABEL);
        for (SelfLoopNodeSide side : slNode.getSides()) {
            ArrayList<SelfLoopComponent> sideComponentDependencies = new ArrayList<SelfLoopComponent>(side.getComponentDependencies());
            double maximumLabelOffsetOfNode = 0.0;
            if (!sideComponentDependencies.isEmpty()) {
                maximumLabelOffsetOfNode = SelfLoopOffsetCalculator.calculatePortLabelOffsets(side, sideComponentDependencies, side.getMaximumPortLevel() + 1, edgeEdgeSpacing, edgeLabelSpacing);
            }
            side.setMaximumLabelOffset(maximumLabelOffsetOfNode);
        }
    }

    private static double calculatePortLabelOffsets(SelfLoopNodeSide side, List<SelfLoopComponent> components, int previousLevel, double edgeEdgeSpacing, double edgeLabelSpacing) {
        double maximumOffsetForNextComponent = 0.0;
        double maximumOffsetOfComponent = 0.0;
        for (SelfLoopComponent component : components) {
            if (component.getPorts().size() <= 1) continue;
            SelfLoopLabel slLabel = component.getSelfLoopLabel();
            SelfLoopLabelPosition slLabelPos = slLabel == null ? null : slLabel.getLabelPosition();
            SelfLoopPort portOfSide = SelfLoopOffsetCalculator.findPortOfSide(component, side.getSide());
            int level = portOfSide.getMaximumLevel();
            List<SelfLoopComponent> sideDependencies = component.getDependencyComponents().get(side);
            if (sideDependencies == null || sideDependencies.isEmpty()) {
                if (level + 1 == previousLevel) {
                    SelfLoopEdge edge = (SelfLoopEdge)Iterables.get(component.getConnectedEdges(), (int)0);
                    SelfLoopOpposingSegment segment = side.getOpposingSegments().get(edge);
                    if (slLabelPos != null && slLabelPos.getSide() == side.getSide() && segment == null) {
                        double offset = SelfLoopOffsetCalculator.getSimpleLabelOffset(slLabel, side.getSide(), edgeEdgeSpacing, edgeLabelSpacing);
                        maximumOffsetForNextComponent = Math.max(maximumOffsetForNextComponent, offset);
                    }
                }
            } else {
                double componentHeight = SelfLoopOffsetCalculator.calculatePortLabelOffsets(side, sideDependencies, level, edgeEdgeSpacing, edgeLabelSpacing);
                maximumOffsetOfComponent = Math.max(maximumOffsetOfComponent, componentHeight);
                if (level + 1 == previousLevel) {
                    maximumOffsetForNextComponent = Math.max(maximumOffsetForNextComponent, SelfLoopOffsetCalculator.getSimpleLabelOffset(slLabel, side.getSide(), edgeEdgeSpacing, edgeLabelSpacing) + maximumOffsetOfComponent);
                }
            }
            double direction = SplinesMath.portSideToDirection(side.getSide());
            if (slLabelPos != null && side.getSide() == slLabelPos.getSide()) {
                slLabelPos.getPosition().add(new KVector(direction).scale(maximumOffsetOfComponent));
            }
            for (SelfLoopPort port : component.getPorts()) {
                if (port.getPortSide() != side.getSide()) continue;
                port.setOtherEdgeOffset(maximumOffsetOfComponent);
            }
        }
        return maximumOffsetForNextComponent;
    }

    private static double getSimpleLabelOffset(SelfLoopLabel slLabel, PortSide portSide, double edgeEdgeSpacing, double edgeLabelSpacing) {
        double labelHeight = 0.0;
        double labelWidth = 0.0;
        if (slLabel != null) {
            labelHeight = slLabel.getHeight();
            labelWidth = slLabel.getWidth();
        }
        double difference = portSide == PortSide.NORTH || portSide == PortSide.SOUTH ? labelHeight - edgeEdgeSpacing + edgeLabelSpacing : labelWidth - edgeEdgeSpacing + edgeLabelSpacing;
        return Math.max(0.0, difference);
    }

    private static SelfLoopPort findPortOfSide(SelfLoopComponent component, PortSide side) {
        for (SelfLoopPort port : component.getPorts()) {
            if (port.getPortSide() != side) continue;
            return port;
        }
        return null;
    }

    public static void calculateOpposingSegmentLabelOffsets(SelfLoopNode slNode) {
        double edgeEdgeSpacing = LGraphUtil.getIndividualOrInherited(slNode.getNode(), LayeredOptions.SPACING_EDGE_EDGE);
        double edgeLabelSpacing = LGraphUtil.getIndividualOrInherited(slNode.getNode(), LayeredOptions.SPACING_EDGE_LABEL);
        for (SelfLoopNodeSide side : slNode.getSides()) {
            ArrayList<SelfLoopOpposingSegment> segments = new ArrayList<SelfLoopOpposingSegment>(new HashSet<SelfLoopOpposingSegment>(side.getOpposingSegments().values()));
            segments.sort((seg1, seg2) -> Integer.compare(seg1.getLevel(), seg2.getLevel()));
            double previousOffset = side.getMaximumLabelOffset();
            double nextOffset = 0.0;
            for (SelfLoopOpposingSegment segment : segments) {
                SelfLoopComponent component = segment.getComponent();
                SelfLoopLabel slLabel = component.getSelfLoopLabel();
                segment.setLabelOffset(previousOffset);
                if (slLabel == null || slLabel.getLabelPosition().getSide() != side.getSide()) continue;
                double direction = SplinesMath.portSideToDirection(side.getSide());
                slLabel.getLabelPosition().getPosition().add(new KVector(direction).scale(previousOffset));
                nextOffset = SelfLoopOffsetCalculator.getSimpleLabelOffset(slLabel, side.getSide(), edgeEdgeSpacing, edgeLabelSpacing);
                previousOffset += nextOffset;
            }
            side.setMaximumLabelOffset(Math.max(side.getMaximumLabelOffset(), nextOffset));
        }
    }
}

