/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.splines;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.p5edges.splines.Rectangle;
import org.eclipse.elk.alg.layered.p5edges.splines.SplinesMath;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;

public class NubSpline {
    protected static final int DIM = 3;
    private static final double EPSILON = 1.0E-6;
    private List<Double> knotVector = Lists.newArrayList();
    private List<PolarCP> controlPoints = Lists.newArrayList();
    private int dimNUBS;
    private boolean isUniform;
    private boolean isClamped;
    private Rectangle outerBox;
    private boolean isBezier;
    private double minKnot;
    private double maxKnot;

    public NubSpline(NubSpline nubSpline) {
        this.dimNUBS = nubSpline.dimNUBS;
        this.isUniform = nubSpline.isUniform;
        this.isClamped = nubSpline.isClamped;
        this.outerBox = nubSpline.outerBox;
        this.isBezier = nubSpline.isBezier;
        this.knotVector = Lists.newLinkedList(nubSpline.knotVector);
        this.minKnot = nubSpline.minKnot;
        this.maxKnot = nubSpline.maxKnot;
        this.controlPoints = Lists.newLinkedList(nubSpline.controlPoints);
    }

    public NubSpline(boolean clamped, int dimension, List<KVector> kVectors) {
        if (dimension < 1) {
            throw new IllegalArgumentException("The dimension must be at least 1!");
        }
        int i = kVectors.size() - 1;
        while (i < dimension) {
            kVectors.add(0, kVectors.get(0));
            ++i;
        }
        if (kVectors.size() < dimension + 1) {
            throw new IllegalArgumentException("At (least dimension + 1) control points are necessary!");
        }
        this.dimNUBS = dimension;
        this.isClamped = clamped;
        this.isUniform = true;
        this.isBezier = false;
        this.createUniformKnotVector(clamped, kVectors.size() + this.dimNUBS - 1);
        ArrayList polarCoordinate = Lists.newArrayList();
        Iterator<Double> knotIter = this.knotVector.iterator();
        int i2 = 0;
        while (i2 < this.dimNUBS - 1) {
            polarCoordinate.add(knotIter.next());
            ++i2;
        }
        for (KVector kVector : kVectors) {
            polarCoordinate.add(knotIter.next());
            this.controlPoints.add(new PolarCP(kVector, polarCoordinate));
            polarCoordinate.remove(0);
        }
    }

    public NubSpline(boolean clamped, int dimension, KVector ... kVectors) {
        this(true, dimension, Lists.newArrayList((Object[])kVectors));
    }

    private NubSpline(boolean clamped, boolean uniform, boolean bezier, int dim, List<Double> knotVec, List<PolarCP> polarVectors) {
        this.isClamped = clamped;
        this.isUniform = uniform;
        this.isBezier = bezier;
        this.dimNUBS = dim;
        this.knotVector = knotVec;
        this.controlPoints = polarVectors;
        this.minKnot = knotVec.iterator().next();
        this.maxKnot = (Double)Iterables.getLast(knotVec);
    }

    public static NubSpline generateDerivedNUBS(NubSpline nubSpline) {
        boolean newClamped = nubSpline.isClamped;
        boolean newUniform = nubSpline.isUniform;
        boolean newBezier = nubSpline.isBezier;
        int oldDim = nubSpline.dimNUBS;
        int newDim = oldDim - 1;
        List<Double> oldKnotVector = nubSpline.knotVector;
        LinkedList newKnotVector = Lists.newLinkedList(nubSpline.knotVector.subList(1, nubSpline.knotVector.size() - 1));
        ArrayList newControlPoints = Lists.newArrayList();
        int i = 0;
        while (i < nubSpline.controlPoints.size() - 1) {
            KVector newCP = nubSpline.controlPoints.get(i + 1).getCp().clone().sub(nubSpline.controlPoints.get(i).getCp()).scale((double)oldDim / (oldKnotVector.get(i + oldDim) - oldKnotVector.get(i)));
            newControlPoints.add(newCP);
            ++i;
        }
        ArrayList polarCoordinate = Lists.newArrayList();
        Iterator knotIter = newKnotVector.iterator();
        ArrayList newPolarVectors = Lists.newArrayList();
        int i2 = 0;
        while (i2 < newDim - 1) {
            polarCoordinate.add((Double)knotIter.next());
            ++i2;
        }
        for (KVector kVector : newControlPoints) {
            polarCoordinate.add((Double)knotIter.next());
            newPolarVectors.add(new PolarCP(kVector, polarCoordinate));
            polarCoordinate.remove(0);
        }
        return new NubSpline(newClamped, newUniform, newBezier, newDim, newKnotVector, newPolarVectors);
    }

    public static NubSpline generateInvertedNUBS(NubSpline nubSpline) {
        ArrayList newKnotVector = Lists.newArrayList();
        double maxVector = nubSpline.knotVector.get(nubSpline.knotVector.size() - 1);
        for (Double vector : nubSpline.knotVector) {
            newKnotVector.add(0, maxVector - vector);
        }
        KVectorChain newControlPoints = KVectorChain.reverse((KVectorChain)nubSpline.getControlPoints());
        ArrayList polarCoordinate = Lists.newArrayList();
        Iterator knotIter = newKnotVector.iterator();
        ArrayList newPolarVectors = Lists.newArrayList();
        int i = 0;
        while (i < nubSpline.dimNUBS - 1) {
            polarCoordinate.add((Double)knotIter.next());
            ++i;
        }
        for (KVector kVector : newControlPoints) {
            polarCoordinate.add((Double)knotIter.next());
            newPolarVectors.add(new PolarCP(kVector, polarCoordinate));
            polarCoordinate.remove(0);
        }
        return new NubSpline(nubSpline.isClamped, nubSpline.isUniform, nubSpline.isBezier, nubSpline.dimNUBS, newKnotVector, newPolarVectors);
    }

    public int getDim() {
        return this.dimNUBS;
    }

    public Rectangle getOuterBox() {
        if (this.outerBox == null) {
            this.calculateOuterBox();
        }
        return this.outerBox;
    }

    protected void setOuterBox(Rectangle outerRectange) {
        this.outerBox = outerRectange;
    }

    public KVectorChain getControlPoints() {
        KVectorChain retVal = new KVectorChain();
        for (PolarCP polarCP : this.controlPoints) {
            retVal.add((Object)polarCP.getCp());
        }
        return retVal;
    }

    public KVector getControlPoint(int i) {
        return this.controlPoints.get(i).getCp();
    }

    public int getControlPointsSize() {
        return this.controlPoints.size();
    }

    public List<Double> getKnotVector() {
        return Lists.newLinkedList(this.knotVector);
    }

    private int getIndexInKnotVector(double knot) {
        ListIterator<Double> iter = this.knotVector.listIterator();
        double currentKnot = knot - 1.0;
        while (iter.hasNext()) {
            currentKnot = iter.next();
            double diff = Math.abs(currentKnot - knot);
            if (!(diff < 1.0E-6)) continue;
            return iter.nextIndex() - 1;
        }
        return this.knotVector.size();
    }

    private int getMultiplicity(double knotToCheck) {
        ListIterator<Double> iter = this.knotVector.listIterator();
        int count = 0;
        while (iter.hasNext()) {
            double currentKnot = (Double)iter.next();
            double diff = currentKnot - knotToCheck;
            if (diff > 1.0E-6) {
                return count;
            }
            if (!(diff > -1.0E-6)) continue;
            ++count;
        }
        return count;
    }

    private void createUniformKnotVector(boolean clamped, int size) {
        double mySize;
        if (size < 2 * this.dimNUBS) {
            throw new IllegalArgumentException("The knot vector must have at least two time the dimension elements.");
        }
        if (clamped) {
            this.minKnot = 0.0;
            this.maxKnot = 1.0;
            int i = 0;
            while (i < this.dimNUBS) {
                this.knotVector.add(0.0);
                ++i;
            }
            mySize = size + 1 - 2 * this.dimNUBS;
        } else {
            mySize = size + 1;
            double ddim = this.dimNUBS;
            this.minKnot = ddim / (mySize + 1.0);
            this.maxKnot = (mySize - ddim) / mySize;
        }
        double fraction = mySize;
        int i = 1;
        while ((double)i < mySize) {
            this.knotVector.add((double)i / fraction);
            ++i;
        }
        if (this.isClamped) {
            i = 0;
            while (i < this.dimNUBS) {
                this.knotVector.add(1.0);
                ++i;
            }
        }
    }

    private void calculateOuterBox() {
        this.outerBox = new Rectangle((Iterable<KVector>)this.getControlPoints());
    }

    private static double getTFromPolar(Collection<Double> polar) {
        double sum = 0.0;
        for (Double val : polar) {
            sum += val.doubleValue();
        }
        return sum / (double)polar.size();
    }

    private void insertKnot(double knotToInsert, int insertions) {
        int i;
        ListIterator<Double> iterKnot = this.knotVector.listIterator();
        if (this.isClamped) {
            i = 0;
            while (i < this.dimNUBS) {
                iterKnot.next();
                ++i;
            }
        } else {
            i = 0;
            while (i < this.dimNUBS - 1) {
                iterKnot.next();
                ++i;
            }
        }
        ListIterator<PolarCP> iterCP = this.controlPoints.listIterator();
        double currentKnot = iterKnot.next();
        while (currentKnot - knotToInsert < 1.0E-6) {
            currentKnot = iterKnot.next();
            iterCP.next();
        }
        iterKnot.previous();
        this.insertKnotAtCurrentPosition(insertions, knotToInsert, iterCP, iterKnot);
    }

    private void insertKnotAtCurrentPosition(int insertions, double knotToInsert, ListIterator<PolarCP> iterCP, ListIterator<Double> iterKnot) {
        int multiplicity = this.getMultiplicity(knotToInsert);
        int i = 0;
        while (i < insertions) {
            iterKnot.add(knotToInsert);
            ArrayList newCPs = Lists.newArrayList();
            PolarCP secondCP = iterCP.next();
            int j = multiplicity + i;
            while (j < this.dimNUBS) {
                PolarCP firstCP = secondCP;
                secondCP = iterCP.next();
                newCPs.add(new PolarCP(firstCP, secondCP, knotToInsert));
                ++j;
            }
            j = multiplicity + i;
            while (j < this.dimNUBS) {
                iterCP.previous();
                if (j > multiplicity + i) {
                    iterCP.remove();
                }
                ++j;
            }
            for (PolarCP cp : newCPs) {
                iterCP.add(cp);
            }
            if (i < insertions - 1) {
                j = multiplicity + i;
                while (j < this.dimNUBS) {
                    iterCP.previous();
                    ++j;
                }
            }
            ++i;
        }
    }

    protected static KVector getFirstVerticalPoint(NubSpline nubSpline, double accuracy, int maxRecursion) {
        NubSpline firstDerive = NubSpline.generateDerivedNUBS(nubSpline);
        double currentAccuracy = Double.POSITIVE_INFINITY;
        KVector currentVector = null;
        int loopCount = 0;
        double knot = 0.0;
        while (currentAccuracy > accuracy && loopCount < maxRecursion) {
            knot = NubSpline.getZeroXOfControlPoligon(firstDerive);
            currentVector = firstDerive.getPointOnCurve(knot, true);
            currentAccuracy = Math.abs(currentVector.x);
            ++loopCount;
        }
        return nubSpline.getPointOnCurve(knot, false);
    }

    protected static KVector getLastVerticalPoint(NubSpline nubSpline, double accuracy, int maxRecursion) {
        NubSpline firstDerive = NubSpline.generateInvertedNUBS(NubSpline.generateDerivedNUBS(nubSpline));
        double currentAccuracy = Double.POSITIVE_INFINITY;
        KVector currentVector = null;
        int loopCount = 0;
        double knot = 0.0;
        while (currentAccuracy > accuracy && loopCount < maxRecursion) {
            knot = NubSpline.getZeroXOfControlPoligon(firstDerive);
            currentVector = firstDerive.getPointOnCurve(knot, true);
            currentAccuracy = Math.abs(currentVector.x);
            ++loopCount;
        }
        Double maxVal = nubSpline.getKnotVector().get(nubSpline.getKnotVector().size() - 1);
        return nubSpline.getPointOnCurve(maxVal - knot, false);
    }

    protected static KVector getFirstHorizontalPoint(NubSpline nubSpline, double accuracy, int maxRecursion) {
        NubSpline firstDerive = NubSpline.generateDerivedNUBS(nubSpline);
        double currentAccuracy = Double.POSITIVE_INFINITY;
        KVector currentVector = null;
        int loopCount = 0;
        double knot = 0.0;
        while (currentAccuracy > accuracy && loopCount < maxRecursion) {
            knot = NubSpline.getZeroYOfControlPoligon(firstDerive);
            currentVector = firstDerive.getPointOnCurve(knot, true);
            currentAccuracy = Math.abs(currentVector.y);
            ++loopCount;
        }
        return nubSpline.getPointOnCurve(knot, false);
    }

    protected static KVector getLastHorizontalPoint(NubSpline nubSpline, double accuracy, int maxRecursion) {
        NubSpline firstDerive = NubSpline.generateInvertedNUBS(NubSpline.generateDerivedNUBS(nubSpline));
        double currentAccuracy = Double.POSITIVE_INFINITY;
        KVector currentVector = null;
        int loopCount = 0;
        double knot = 0.0;
        while (currentAccuracy > accuracy && loopCount < maxRecursion) {
            knot = NubSpline.getZeroYOfControlPoligon(firstDerive);
            currentVector = firstDerive.getPointOnCurve(knot, true);
            currentAccuracy = Math.abs(currentVector.y);
            ++loopCount;
        }
        Double maxVal = nubSpline.getKnotVector().get(nubSpline.getKnotVector().size() - 1);
        return nubSpline.getPointOnCurve(maxVal - knot, false);
    }

    protected KVector getPointOnCurve(double t) {
        return this.getPointOnCurve(t, false);
    }

    protected KVector getPointOnCurve(double t, boolean modify) {
        int multiplicity = this.getMultiplicity(t);
        if (multiplicity == this.dimNUBS) {
            return this.getControlPoint(this.getIndexInKnotVector(t));
        }
        if (modify) {
            this.insertKnot(t, this.dimNUBS - multiplicity);
            return this.getControlPoint(this.getIndexInKnotVector(t));
        }
        NubSpline copy = new NubSpline(this);
        copy.insertKnot(t, this.dimNUBS - multiplicity);
        return copy.getControlPoint(copy.getIndexInKnotVector(t));
    }

    private static double getZeroYOfControlPoligon(NubSpline nubSpline) {
        Iterator<PolarCP> iter = nubSpline.controlPoints.iterator();
        double firstY = 0.0;
        PolarCP secondCP = iter.next();
        double secondY = secondCP.getCp().y;
        boolean secondIsPositive = secondY > 1.0E-6;
        boolean secondIsNegative = secondY < -1.0E-6;
        while (iter.hasNext()) {
            PolarCP firstCP = secondCP;
            firstY = secondY;
            boolean firstIsPositive = secondIsPositive;
            boolean firstIsNegative = secondIsNegative;
            secondCP = iter.next();
            secondY = secondCP.getCp().y;
            secondIsPositive = secondY > 1.0E-6;
            boolean bl = secondIsNegative = secondY < -1.0E-6;
            if (!secondIsPositive && !secondIsNegative) {
                return NubSpline.getTFromPolar(secondCP.getPolarCoordinate());
            }
            if ((!firstIsPositive || !secondIsNegative) && (!firstIsNegative || !secondIsPositive)) continue;
            double factor = firstY / (firstY - secondY);
            double t1 = NubSpline.getTFromPolar(firstCP.getPolarCoordinate());
            double t2 = NubSpline.getTFromPolar(secondCP.getPolarCoordinate());
            return factor * t1 + (1.0 - factor) * t2;
        }
        return 0.0;
    }

    private static double getZeroXOfControlPoligon(NubSpline nubSpline) {
        Iterator<PolarCP> iter = nubSpline.controlPoints.iterator();
        double firstX = 0.0;
        PolarCP secondCP = iter.next();
        double secondX = secondCP.getCp().x;
        boolean secondIsPositive = secondX > 1.0E-6;
        boolean secondIsNegative = secondX < -1.0E-6;
        while (iter.hasNext()) {
            PolarCP firstCP = secondCP;
            firstX = secondX;
            boolean firstIsPositive = secondIsPositive;
            boolean firstIsNegative = secondIsNegative;
            secondCP = iter.next();
            secondX = secondCP.getCp().x;
            secondIsPositive = secondX > 1.0E-6;
            boolean bl = secondIsNegative = secondX < -1.0E-6;
            if (!secondIsPositive && !secondIsNegative) {
                return NubSpline.getTFromPolar(secondCP.getPolarCoordinate());
            }
            if ((!firstIsPositive || !secondIsNegative) && (!firstIsNegative || !secondIsPositive)) continue;
            double factor = firstX / (firstX - secondX);
            double t1 = NubSpline.getTFromPolar(firstCP.getPolarCoordinate());
            double t2 = NubSpline.getTFromPolar(secondCP.getPolarCoordinate());
            return factor * t1 + (1.0 - factor) * t2;
        }
        return 0.0;
    }

    public void toBezier() {
        int i;
        ListIterator<Double> iterKnot = this.knotVector.listIterator();
        ListIterator<PolarCP> iterCP = this.controlPoints.listIterator();
        if (this.isClamped) {
            i = 0;
            while (i < this.dimNUBS) {
                iterKnot.next();
                ++i;
            }
        } else {
            i = 0;
            while (i < this.dimNUBS - 1) {
                iterKnot.next();
                iterKnot.remove();
                ++i;
            }
        }
        double currentKnot = iterKnot.next();
        while (this.maxKnot - currentKnot > 1.0E-6) {
            double knotToCount = currentKnot;
            int occurrence = 0;
            while (Math.abs(currentKnot - knotToCount) < 1.0E-6) {
                ++occurrence;
                currentKnot = iterKnot.next();
                iterCP.next();
            }
            if (occurrence < this.dimNUBS) {
                iterKnot.previous();
                this.insertKnotAtCurrentPosition(this.dimNUBS - occurrence, knotToCount, iterCP, iterKnot);
                iterKnot.next();
            }
            iterCP.previous();
        }
        if (!this.isClamped) {
            int i2 = 0;
            while (i2 < this.dimNUBS - 1) {
                iterKnot.next();
                iterKnot.remove();
                ++i2;
            }
        }
        this.isClamped = true;
        this.isBezier = true;
    }

    public KVectorChain getBezierCP(boolean withSourceVector, boolean withTargetVector) {
        if (!this.isBezier) {
            this.toBezier();
        }
        KVectorChain retVal = new KVectorChain();
        Iterator<PolarCP> iter = this.controlPoints.iterator();
        if (!withSourceVector) {
            iter.next();
        }
        while (iter.hasNext()) {
            retVal.add((Object)iter.next().getCp());
        }
        if (!withTargetVector) {
            retVal.removeLast();
        }
        return retVal;
    }

    public KVectorChain getBezierCP() {
        return this.getBezierCP(false, false);
    }

    public static NubSpline generateNiceCurve() {
        KVectorChain niceChain = new KVectorChain();
        KVector vector1 = new KVector(5.5, 23.0);
        KVector vector2 = new KVector(2.5, 12.0);
        KVector vector3 = new KVector(5.0, 10.0);
        KVector vector4 = new KVector(5.0, 9.0);
        KVector vector5 = new KVector(3.8, 5.5);
        KVector vector6 = new KVector(7.0, 4.0);
        KVector vector7 = new KVector(7.0, 3.5);
        KVector vector8 = new KVector(6.0, 2.2);
        KVector vector9 = new KVector(8.0, 0.5);
        niceChain.add((Object)vector1);
        niceChain.add((Object)vector1);
        niceChain.add((Object)vector1);
        niceChain.add((Object)vector2);
        niceChain.add((Object)vector3);
        niceChain.add((Object)vector4);
        niceChain.add((Object)vector5);
        niceChain.add((Object)vector6);
        niceChain.add((Object)vector7);
        niceChain.add((Object)vector8);
        niceChain.add((Object)vector9);
        niceChain.add((Object)NubSpline.mirrorOnX(vector8, vector9.x));
        niceChain.add((Object)NubSpline.mirrorOnX(vector7, vector9.x));
        niceChain.add((Object)NubSpline.mirrorOnX(vector6, vector9.x));
        niceChain.add((Object)NubSpline.mirrorOnX(vector5, vector9.x));
        niceChain.add((Object)NubSpline.mirrorOnX(vector4, vector9.x));
        niceChain.add((Object)NubSpline.mirrorOnX(vector3, vector9.x));
        niceChain.add((Object)NubSpline.mirrorOnX(vector2, vector9.x));
        niceChain.add((Object)NubSpline.mirrorOnX(vector1, vector9.x));
        niceChain.add((Object)NubSpline.mirrorOnX(vector1, vector9.x));
        niceChain.add((Object)NubSpline.mirrorOnX(vector1, vector9.x));
        niceChain.scale(5.0);
        niceChain.offset(-50.0, -80.0);
        return new NubSpline(true, 3, (List<KVector>)niceChain);
    }

    private static KVector mirrorOnX(KVector original, double xVal) {
        return new KVector(xVal + xVal - original.x, original.y);
    }

    public String toString() {
        return this.controlPoints.toString();
    }

    protected static final class PolarCP {
        private KVector cp;
        private List<Double> polarCoordinate;

        PolarCP(KVector controlPoint, List<Double> polarCoordinate) {
            this.setCp(controlPoint.clone());
            this.setPolarCoordinate(Lists.newLinkedList(polarCoordinate));
        }

        PolarCP(PolarCP polarCP) {
            this.setCp(polarCP.getCp().clone());
            this.setPolarCoordinate(Lists.newLinkedList(polarCP.getPolarCoordinate()));
        }

        PolarCP(PolarCP firstCP, PolarCP secondCP, double newKnot) {
            double firstFactor = firstCP.polarCoordinate.iterator().next();
            double secondFactor = (Double)Iterables.getLast(secondCP.polarCoordinate);
            KVector aScaled = firstCP.cp.clone().scale(secondFactor - newKnot);
            KVector bScaled = secondCP.cp.clone().scale(newKnot - firstFactor);
            KVector total = aScaled.add(bScaled);
            total.scale(1.0 / (secondFactor - firstFactor));
            this.cp = total;
            this.polarCoordinate = Lists.newArrayList();
            boolean needsToBeAdded = true;
            Iterator<Double> iter = firstCP.polarCoordinate.iterator();
            iter.next();
            while (iter.hasNext()) {
                double nextKnot = iter.next();
                if (needsToBeAdded && nextKnot - newKnot > 1.0E-6) {
                    this.polarCoordinate.add(newKnot);
                    needsToBeAdded = false;
                }
                this.polarCoordinate.add(nextKnot);
            }
            if (needsToBeAdded) {
                this.polarCoordinate.add(newKnot);
            }
        }

        public KVector getCp() {
            return this.cp;
        }

        public void setCp(KVector cp) {
            this.cp = cp;
        }

        public List<Double> getPolarCoordinate() {
            return this.polarCoordinate;
        }

        public void setPolarCoordinate(List<Double> polarCoordinate) {
            this.polarCoordinate = polarCoordinate;
        }

        public String toString() {
            return this.polarCoordinate + " " + SplinesMath.convertKVectorToString(this.cp);
        }
    }
}

