/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.debug.views.graph;

import org.eclipse.elk.core.debug.views.graph.ImageExportAction;
import org.eclipse.elk.core.debug.views.graph.LoadGraphAction;
import org.eclipse.elk.core.ui.rendering.GraphRenderingCanvas;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class LayoutGraphView
extends ViewPart {
    public static final String VIEW_ID = "org.eclipse.elk.debug.graphView";
    private ScrolledComposite scrolledComposite;
    private GraphRenderingCanvas graphCanvas;

    public static void updateWithGraph(final ElkNode graph) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                LayoutGraphView activeView = LayoutGraphView.findView();
                if (graph != null && activeView != null) {
                    ElkNode nodeCopy = (ElkNode)EcoreUtil.copy((EObject)graph);
                    activeView.getCanvas().setLayoutGraph(nodeCopy);
                }
            }
        });
    }

    private static LayoutGraphView findView() {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        IViewPart viewPart = activePage.findView(VIEW_ID);
        if (viewPart instanceof LayoutGraphView) {
            return (LayoutGraphView)viewPart;
        }
        return null;
    }

    public void createPartControl(Composite parent) {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)new LoadGraphAction());
        toolBarManager.add((IAction)new ImageExportAction(this));
        this.scrolledComposite = new ScrolledComposite(parent, 768);
        this.graphCanvas = new GraphRenderingCanvas((Composite)this.scrolledComposite);
        this.scrolledComposite.setContent((Control)this.graphCanvas);
    }

    public void setFocus() {
        this.scrolledComposite.setFocus();
    }

    public GraphRenderingCanvas getCanvas() {
        return this.graphCanvas;
    }
}

