/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.labeling;

import com.google.common.collect.Multimap;
import java.util.Collection;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopType;
import org.eclipse.elk.alg.layered.p5edges.loops.labeling.CornerLoopLabelPositionGenerator;
import org.eclipse.elk.alg.layered.p5edges.loops.labeling.FourCornerLoopLabelPositionGenerator;
import org.eclipse.elk.alg.layered.p5edges.loops.labeling.ISelfLoopLabelPositionGenerator;
import org.eclipse.elk.alg.layered.p5edges.loops.labeling.OpposingLoopLabelPositionGenerator;
import org.eclipse.elk.alg.layered.p5edges.loops.labeling.SideLoopLabelPositionGenerator;
import org.eclipse.elk.alg.layered.p5edges.loops.labeling.ThreeCornerLoopLabelPositionGenerator;
import org.eclipse.elk.alg.layered.p5edges.loops.util.SelfLoopUtil;

public final class SelfLoopLabelPositionGeneration {
    private SelfLoopLabelPositionGeneration() {
    }

    public static void generatePositions(SelfLoopNode slNode) {
        Multimap<SelfLoopType, SelfLoopComponent> componentTypes = SelfLoopUtil.getTypeMap(slNode.getNode());
        SideLoopLabelPositionGenerator sidePlacer = new SideLoopLabelPositionGenerator(slNode);
        SelfLoopLabelPositionGeneration.generatePositions(componentTypes.get((Object)SelfLoopType.SIDE), sidePlacer);
        CornerLoopLabelPositionGenerator cornerPlacer = new CornerLoopLabelPositionGenerator(slNode);
        SelfLoopLabelPositionGeneration.generatePositions(componentTypes.get((Object)SelfLoopType.CORNER), cornerPlacer);
        OpposingLoopLabelPositionGenerator oppossingPlacer = new OpposingLoopLabelPositionGenerator(slNode);
        SelfLoopLabelPositionGeneration.generatePositions(componentTypes.get((Object)SelfLoopType.OPPOSING), oppossingPlacer);
        ThreeCornerLoopLabelPositionGenerator threeSidePlacer = new ThreeCornerLoopLabelPositionGenerator(slNode);
        SelfLoopLabelPositionGeneration.generatePositions(componentTypes.get((Object)SelfLoopType.THREE_CORNER), threeSidePlacer);
        FourCornerLoopLabelPositionGenerator fourSidePlacer = new FourCornerLoopLabelPositionGenerator(slNode);
        SelfLoopLabelPositionGeneration.generatePositions(componentTypes.get((Object)SelfLoopType.FOUR_CORNER), fourSidePlacer);
    }

    private static void generatePositions(Collection<SelfLoopComponent> components, ISelfLoopLabelPositionGenerator selfLoopPlacer) {
        for (SelfLoopComponent component : components) {
            if (component.getSelfLoopLabel() == null) continue;
            selfLoopPlacer.generatePositions(component);
        }
    }
}

