/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.position;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.SelfLoopOrderingStrategy;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.p5edges.loops.position.AbstractSelfLoopPortPositioner;
import org.eclipse.elk.core.options.PortSide;

public class NorthSouthSelfLoopPortPositioner
extends AbstractSelfLoopPortPositioner {
    private final SelfLoopOrderingStrategy ordering;

    public NorthSouthSelfLoopPortPositioner(SelfLoopOrderingStrategy ordering) {
        this.ordering = ordering;
    }

    @Override
    public void position(LNode node) {
        SelfLoopNode slNode = (SelfLoopNode)node.getProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION);
        List<SelfLoopComponent> components = slNode.getSelfLoopComponents();
        components.sort((comp1, comp2) -> Integer.compare(comp1.getPorts().size(), comp2.getPorts().size()));
        List nonLoopComponents = components.stream().filter(comp -> comp.getPorts().size() == 1).collect(Collectors.toList());
        components.removeAll(nonLoopComponents);
        ArrayList<SelfLoopComponent> componentSide1 = new ArrayList<SelfLoopComponent>();
        ArrayList<SelfLoopComponent> componentSide2 = new ArrayList<SelfLoopComponent>();
        int portsSide1 = 0;
        int portsSide2 = 0;
        for (SelfLoopComponent component : components) {
            if (portsSide1 <= portsSide2) {
                componentSide1.add(component);
                for (SelfLoopPort port : component.getPorts()) {
                    port.setPortSide(PortSide.NORTH);
                    ++portsSide1;
                }
                continue;
            }
            componentSide2.add(component);
            for (SelfLoopPort port : component.getPorts()) {
                port.setPortSide(PortSide.SOUTH);
                ++portsSide2;
            }
        }
        if (this.ordering == SelfLoopOrderingStrategy.STACKED) {
            this.stackComponents(slNode, componentSide1, PortSide.NORTH);
            this.stackComponents(slNode, componentSide2, PortSide.SOUTH);
        } else {
            this.sequenceComponents(slNode, componentSide1, PortSide.NORTH);
            this.sequenceComponents(slNode, componentSide2, PortSide.SOUTH);
        }
    }
}

