/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.debug.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.elk.core.debug.ElkDebugPlugin;
import org.eclipse.elk.core.debug.actions.ClearExecutionAction;
import org.eclipse.elk.core.debug.actions.ClearExecutionsAction;
import org.eclipse.elk.core.debug.actions.CollapseExecutionTreeAction;
import org.eclipse.elk.core.debug.actions.CompressLogFolderAction;
import org.eclipse.elk.core.debug.actions.ExpandExecutionTreeAction;
import org.eclipse.elk.core.debug.actions.FilterExecutionTreeAction;
import org.eclipse.elk.core.debug.actions.PreferenceAction;
import org.eclipse.elk.core.debug.actions.RevealLogFolderAction;
import org.eclipse.elk.core.debug.model.ExecutionInfo;
import org.eclipse.elk.core.debug.model.ExecutionInfoContentProvider;
import org.eclipse.elk.core.debug.model.IExecutionInfoModelListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractLayoutDebugView
extends ViewPart
implements IExecutionInfoModelListener {
    private final String viewId;
    private final ExecutionInfoContentProvider treeContentProvider = new ExecutionInfoContentProvider();
    private final PreferenceAction preferenceAction;
    private final FilterExecutionTreeAction filterTreeAction = new FilterExecutionTreeAction(this);
    private final ClearExecutionAction clearExecutionAction = new ClearExecutionAction(this);
    private final ClearExecutionsAction clearExecutionsAction = new ClearExecutionsAction();
    private final RevealLogFolderAction revealLogFolderAction = new RevealLogFolderAction(this);
    private final CompressLogFolderAction compressLogFolderAction = new CompressLogFolderAction(this);
    private final CollapseExecutionTreeAction collapseTreeAction = new CollapseExecutionTreeAction(this);
    private final ExpandExecutionTreeAction expandTreeAction = new ExpandExecutionTreeAction(this);
    private final ViewCloseListener viewCloseListener = new ViewCloseListener();
    private SashForm sashForm;
    private TreeViewer treeViewer;
    private static final String SASH_KEY = ".sashWeights";
    private static final String FILTER_KEY = ".filterState";

    public AbstractLayoutDebugView(String viewId, String preferenceId) {
        this.viewId = viewId;
        this.preferenceAction = new PreferenceAction(preferenceId);
    }

    protected void treeSelectionChanged() {
        this.updateActionEnablement();
    }

    public List<ExecutionInfo> getSelectedExecutionInfos() {
        ArrayList<ExecutionInfo> result = new ArrayList<ExecutionInfo>();
        Iterator selectionIterator = this.treeViewer.getStructuredSelection().iterator();
        while (selectionIterator.hasNext()) {
            result.add((ExecutionInfo)selectionIterator.next());
        }
        return result;
    }

    public void setSelectedExecutionInfos(List<ExecutionInfo> infos) {
        this.treeViewer.setSelection((ISelection)new StructuredSelection(infos), true);
        this.treeSelectionChanged();
    }

    public void setFilterTree(boolean filter) {
        if (filter) {
            this.treeContentProvider.setFilter(this.getTreeFilter());
        } else {
            this.treeContentProvider.setFilter(null);
        }
        this.treeViewer.refresh();
        this.treeSelectionChanged();
    }

    protected abstract Predicate<ExecutionInfo> getTreeFilter();

    public void collapseAllTreeViewerElements() {
        this.treeViewer.collapseAll();
        this.treeSelectionChanged();
    }

    public void expandAllTreeViewerElements() {
        this.treeViewer.expandAll();
    }

    public void createPartControl(Composite parent) {
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        parent.setLayout((Layout)gl);
        this.setupActionBars();
        this.sashForm = new SashForm(parent, 256);
        this.sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setupTreeViewer((Composite)this.sashForm);
        this.setupRemainingControls((Composite)this.sashForm);
        this.loadState(this.retrieveDialogSettings());
        this.getSite().getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this.viewCloseListener);
        ElkDebugPlugin.getDefault().getModel().addExecutionInfoModelListener(this);
        this.updateActionEnablement();
    }

    private void setupActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.customizeMenu(actionBars.getMenuManager());
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        this.customizeToolBar(toolBarManager);
        toolBarManager.add((IAction)this.preferenceAction);
        toolBarManager.add((IAction)this.filterTreeAction);
    }

    protected void customizeMenu(IMenuManager menuManager) {
    }

    protected void customizeToolBar(IToolBarManager toolBarManager) {
    }

    private void setupTreeViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent);
        this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        MenuManager contextMenu = new MenuManager();
        contextMenu.add((IAction)this.clearExecutionAction);
        contextMenu.add((IAction)this.clearExecutionsAction);
        contextMenu.add((IContributionItem)new Separator());
        contextMenu.add((IAction)this.revealLogFolderAction);
        contextMenu.add((IAction)this.compressLogFolderAction);
        contextMenu.add((IContributionItem)new Separator());
        contextMenu.add((IAction)this.expandTreeAction);
        contextMenu.add((IAction)this.collapseTreeAction);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractLayoutDebugView.this.clearExecutionAction.updateEnablement();
                AbstractLayoutDebugView.this.revealLogFolderAction.updateEnablement();
                AbstractLayoutDebugView.this.compressLogFolderAction.updateEnablement();
            }
        });
        this.treeViewer.getTree().setMenu(contextMenu.createContextMenu(this.treeViewer.getControl()));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractLayoutDebugView.this.treeSelectionChanged();
            }
        });
        this.treeViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 8 || e.keyCode == 127) {
                    AbstractLayoutDebugView.this.clearExecutionAction.run();
                }
            }
        });
        this.customizeTreeViewer(this.treeViewer);
        this.treeViewer.setInput(ElkDebugPlugin.getDefault().getModel().getExecutionInfos());
    }

    protected abstract void customizeTreeViewer(TreeViewer var1);

    protected void setupRemainingControls(Composite parent) {
    }

    public void dispose() {
        super.dispose();
        this.getSite().getWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this.viewCloseListener);
        IBaseLabelProvider treeLabelProvider = this.treeViewer.getLabelProvider();
        if (treeLabelProvider != null) {
            treeLabelProvider.dispose();
        }
        this.preferenceAction.dispose();
    }

    protected void loadState(IDialogSettings viewSettings) {
        if (viewSettings.get(SASH_KEY) != null) {
            int[] weights = new int[viewSettings.getInt(SASH_KEY)];
            boolean weightsLoadedSuccessfully = true;
            int i = 0;
            while (i < weights.length) {
                String key = ".sashWeights." + i;
                if (viewSettings.get(key) == null) {
                    weightsLoadedSuccessfully = false;
                    break;
                }
                weights[i] = viewSettings.getInt(key);
                ++i;
            }
            if (weightsLoadedSuccessfully) {
                this.sashForm.setWeights(weights);
            }
        }
        if (viewSettings.get(FILTER_KEY) != null && viewSettings.getBoolean(FILTER_KEY)) {
            this.filterTreeAction.setChecked(true);
            this.filterTreeAction.run();
        }
    }

    protected void persistState(IDialogSettings viewSettings) {
        int[] weights = this.sashForm.getWeights();
        viewSettings.put(SASH_KEY, weights.length);
        int i = 0;
        while (i < weights.length) {
            viewSettings.put(".sashWeights." + i, weights[i]);
            ++i;
        }
        viewSettings.put(FILTER_KEY, this.filterTreeAction.isChecked());
    }

    private void updateActionEnablement() {
        this.clearExecutionAction.updateEnablement();
        this.clearExecutionsAction.updateEnablement();
        this.revealLogFolderAction.updateEnablement();
        this.compressLogFolderAction.updateEnablement();
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    @Override
    public void executionInfoChanged() {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractLayoutDebugView.this.treeViewer.refresh();
                AbstractLayoutDebugView.this.updateActionEnablement();
                AbstractLayoutDebugView.this.treeSelectionChanged();
            }
        });
    }

    private IDialogSettings retrieveDialogSettings() {
        return DialogSettings.getOrCreateSection((IDialogSettings)ElkDebugPlugin.getDefault().getDialogSettings(), (String)this.viewId);
    }

    private class ViewCloseListener
    extends PerspectiveAdapter {
        private ViewCloseListener() {
        }

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            if (changeId.equals("viewHide")) {
                AbstractLayoutDebugView.this.persistState(AbstractLayoutDebugView.this.retrieveDialogSettings());
            }
        }
    }
}

