/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.graphviz.layouter;

import java.util.EnumSet;
import org.eclipse.elk.alg.graphviz.dot.transform.OverlapMode;
import org.eclipse.elk.alg.graphviz.layouter.GraphvizLayoutProvider;
import org.eclipse.elk.alg.graphviz.layouter.GraphvizMetaDataProvider;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.IFactory;
import org.eclipse.elk.graph.properties.GraphFeature;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class TwopiOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "org.eclipse.elk.graphviz.twopi";
    private static final ElkPadding PADDING_DEFAULT = new ElkPadding(10.0);
    public static final IProperty<ElkPadding> PADDING = new Property(CoreOptions.PADDING, (Object)PADDING_DEFAULT);
    private static final double SPACING_NODE_NODE_DEFAULT = 60.0;
    public static final IProperty<Double> SPACING_NODE_NODE = new Property(CoreOptions.SPACING_NODE_NODE, (Object)60.0);
    public static final IProperty<Double> SPACING_EDGE_LABEL = CoreOptions.SPACING_EDGE_LABEL;
    public static final IProperty<EnumSet<SizeConstraint>> NODE_SIZE_CONSTRAINTS = CoreOptions.NODE_SIZE_CONSTRAINTS;
    public static final IProperty<EnumSet<SizeOptions>> NODE_SIZE_OPTIONS = CoreOptions.NODE_SIZE_OPTIONS;
    private static final EdgeRouting EDGE_ROUTING_DEFAULT = EdgeRouting.SPLINES;
    public static final IProperty<EdgeRouting> EDGE_ROUTING = new Property(CoreOptions.EDGE_ROUTING, (Object)EDGE_ROUTING_DEFAULT);
    public static final IProperty<Boolean> DEBUG_MODE = CoreOptions.DEBUG_MODE;
    public static final IProperty<Boolean> CONCENTRATE = GraphvizMetaDataProvider.CONCENTRATE;
    public static final IProperty<Double> LABEL_DISTANCE = GraphvizMetaDataProvider.LABEL_DISTANCE;
    public static final IProperty<Double> LABEL_ANGLE = GraphvizMetaDataProvider.LABEL_ANGLE;
    public static final IProperty<OverlapMode> OVERLAP_MODE = GraphvizMetaDataProvider.OVERLAP_MODE;
    public static final IProperty<Boolean> ADAPT_PORT_POSITIONS = GraphvizMetaDataProvider.ADAPT_PORT_POSITIONS;

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData.Builder().id(ALGORITHM_ID).name("Twopi").description("Radial layouts, after Wills '97. The nodes are placed on concentric circles depending on their distance from a given root node. The algorithm is designed to handle not only small graphs, but also very large ones.").providerFactory((IFactory)new TwopiFactory()).category("org.eclipse.elk.radial").melkBundleName("Graphviz").definingBundleId("org.eclipse.elk.alg.graphviz.layouter").imagePath("images/twopi_layout.png").supportedFeatures(EnumSet.of(GraphFeature.SELF_LOOPS, GraphFeature.MULTI_EDGES, GraphFeature.EDGE_LABELS)).create());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.padding", (Object)PADDING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.spacing.nodeNode", (Object)60.0);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.spacing.edgeLabel", SPACING_EDGE_LABEL.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.constraints", NODE_SIZE_CONSTRAINTS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.options", NODE_SIZE_OPTIONS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.edgeRouting", (Object)EDGE_ROUTING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.debugMode", DEBUG_MODE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.graphviz.concentrate", CONCENTRATE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.graphviz.labelDistance", LABEL_DISTANCE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.graphviz.labelAngle", LABEL_ANGLE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.graphviz.overlapMode", OVERLAP_MODE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.graphviz.adaptPortPositions", ADAPT_PORT_POSITIONS.getDefault());
    }

    public static class TwopiFactory
    implements IFactory<AbstractLayoutProvider> {
        public AbstractLayoutProvider create() {
            GraphvizLayoutProvider provider = new GraphvizLayoutProvider();
            provider.initialize("TWOPI");
            return provider;
        }

        public void destroy(AbstractLayoutProvider obj) {
            obj.dispose();
        }
    }
}

