/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.orthogonal;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.AbstractRoutingDirectionStrategy;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.SegmentDependency;

public class HyperEdgeSegment
implements Comparable<HyperEdgeSegment> {
    private final AbstractRoutingDirectionStrategy routingStrategy;
    private final List<LPort> ports = Lists.newArrayList();
    private int mark;
    private int routingSlot;
    private double start = Double.NaN;
    private double end = Double.NaN;
    private final LinkedList<Double> sourcePosis = Lists.newLinkedList();
    private final LinkedList<Double> targetPosis = Lists.newLinkedList();
    private final List<SegmentDependency> outgoingDependencies = Lists.newArrayList();
    private int outWeight;
    private final List<SegmentDependency> incomingDependencies = Lists.newArrayList();
    private int inWeight;

    public HyperEdgeSegment(AbstractRoutingDirectionStrategy routingStrategy) {
        this.routingStrategy = routingStrategy;
    }

    public void addPortPositions(LPort port, Map<LPort, HyperEdgeSegment> hyperNodeMap) {
        hyperNodeMap.put(port, this);
        this.ports.add(port);
        double pos = this.routingStrategy.getPortPositionOnHyperNode(port);
        this.start = Double.isNaN(this.start) ? pos : Math.min(this.start, pos);
        this.end = Double.isNaN(this.end) ? pos : Math.max(this.end, pos);
        if (port.getSide() == this.routingStrategy.getSourcePortSide()) {
            HyperEdgeSegment.insertSorted(this.sourcePosis, pos);
        } else {
            HyperEdgeSegment.insertSorted(this.targetPosis, pos);
        }
        for (LPort otherPort : port.getConnectedPorts()) {
            if (hyperNodeMap.containsKey((Object)otherPort)) continue;
            this.addPortPositions(otherPort, hyperNodeMap);
        }
    }

    private static void insertSorted(List<Double> list, double value) {
        ListIterator<Double> listIter = list.listIterator();
        while (listIter.hasNext()) {
            double next = listIter.next().floatValue();
            if (next == value) {
                return;
            }
            if (!(next > value)) continue;
            listIter.previous();
            break;
        }
        listIter.add(value);
    }

    public List<LPort> getPorts() {
        return this.ports;
    }

    int getMark() {
        return this.mark;
    }

    void setMark(int mark) {
        this.mark = mark;
    }

    public int getRoutingSlot() {
        return this.routingSlot;
    }

    public void setRoutingSlot(int slot) {
        this.routingSlot = slot;
    }

    public double getStartPos() {
        return this.start;
    }

    public double getEndPos() {
        return this.end;
    }

    public LinkedList<Double> getSourcePosis() {
        return this.sourcePosis;
    }

    public LinkedList<Double> getTargetPosis() {
        return this.targetPosis;
    }

    public List<SegmentDependency> getOutgoingDependencies() {
        return this.outgoingDependencies;
    }

    public int getOutWeight() {
        return this.outWeight;
    }

    public void setOutWeight(int outWeight) {
        this.outWeight = outWeight;
    }

    public List<SegmentDependency> getIncomingDependencies() {
        return this.incomingDependencies;
    }

    public int getInWeight() {
        return this.inWeight;
    }

    public void setInWeight(int inWeight) {
        this.inWeight = inWeight;
    }

    @Override
    public int compareTo(HyperEdgeSegment other) {
        return this.mark - other.mark;
    }

    public boolean equals(Object object) {
        if (object instanceof HyperEdgeSegment) {
            HyperEdgeSegment other = (HyperEdgeSegment)object;
            return this.mark == other.mark;
        }
        return false;
    }

    public int hashCode() {
        return this.mark;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        Iterator<LPort> portIter = this.ports.iterator();
        while (portIter.hasNext()) {
            LPort port = portIter.next();
            String name = port.getNode().getDesignation();
            if (name == null) {
                name = "n" + port.getNode().getIndex();
            }
            builder.append(name);
            if (!portIter.hasNext()) continue;
            builder.append(',');
        }
        builder.append('}');
        return builder.toString();
    }
}

