/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.text.formatting2;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.elk.graph.EMapPropertyHolder;
import org.eclipse.elk.graph.ElkBendPoint;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphPackage;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.ElkShape;
import org.eclipse.elk.graph.impl.ElkPropertyToValueMapEntryImpl;
import org.eclipse.elk.graph.text.services.ElkGraphGrammarAccess;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ElkGraphFormatter
extends AbstractFormatter2 {
    private static final Procedures.Procedure1<? super IHiddenRegionFormatter> no_space = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter it) {
            it.noSpace();
        }
    };
    private static final Procedures.Procedure1<? super IHiddenRegionFormatter> one_space = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter it) {
            it.oneSpace();
        }
    };
    private static final Procedures.Procedure1<? super IHiddenRegionFormatter> new_line = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter it) {
            it.newLine();
        }
    };
    private static final Procedures.Procedure1<? super IHiddenRegionFormatter> new_lines = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter it) {
            it.setNewLines(1, 1, 2);
        }
    };
    @Inject
    @Extension
    private ElkGraphGrammarAccess _elkGraphGrammarAccess;

    protected void _format(ElkNode node, final @Extension IFormattableDocument document) {
        boolean _tripleEquals;
        ElkNode _parent = node.getParent();
        boolean bl = _tripleEquals = _parent == null;
        if (_tripleEquals) {
            document.append(this.textRegionExtensions.regionFor((EObject)node).keyword(this._elkGraphGrammarAccess.getRootNodeAccess().getGraphKeyword_1_0()), one_space);
            document.append(this.textRegionExtensions.regionFor((EObject)node).assignment(this._elkGraphGrammarAccess.getRootNodeAccess().getIdentifierAssignment_1_1()), new_lines);
        } else {
            document.append(this.textRegionExtensions.regionFor((EObject)node).keyword(this._elkGraphGrammarAccess.getElkNodeAccess().getNodeKeyword_0()), one_space);
            Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.indent();
                }
            };
            document.interior(document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)node).keyword(this._elkGraphGrammarAccess.getElkNodeAccess().getLeftCurlyBracketKeyword_2_0()), one_space), new_line), this.textRegionExtensions.regionFor((EObject)node).keyword(this._elkGraphGrammarAccess.getElkNodeAccess().getRightCurlyBracketKeyword_2_4()), (Procedures.Procedure1)_function);
        }
        Consumer<ISemanticRegion> _function_1 = new Consumer<ISemanticRegion>(){

            @Override
            public void accept(ISemanticRegion it) {
                document.append(document.prepend(it, no_space), one_space);
            }
        };
        this.textRegionExtensions.regionFor((EObject)node).keywords(new String[]{":", ","}).forEach(_function_1);
        this.formatShapeLayout((ElkShape)node, document);
        EMap _properties = node.getProperties();
        for (Map.Entry property : _properties) {
            document.format((Object)property);
        }
        EList _children = node.getChildren();
        for (ElkNode child : _children) {
            document.format((Object)((ElkNode)document.append((EObject)child, new_lines)));
        }
        EList _containedEdges = node.getContainedEdges();
        for (ElkEdge edge : _containedEdges) {
            document.format((Object)((ElkEdge)document.append((EObject)edge, new_lines)));
        }
        EList _ports = node.getPorts();
        for (ElkPort port : _ports) {
            document.format((Object)((ElkPort)document.append((EObject)port, new_lines)));
        }
        EList _labels = node.getLabels();
        for (ElkLabel label : _labels) {
            document.format((Object)((ElkLabel)document.append((EObject)label, new_lines)));
        }
    }

    protected void _format(ElkEdge edge, final @Extension IFormattableDocument document) {
        document.append(this.textRegionExtensions.regionFor((EObject)edge).keyword(this._elkGraphGrammarAccess.getElkEdgeAccess().getEdgeKeyword_0()), one_space);
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)edge).keyword(this._elkGraphGrammarAccess.getElkEdgeAccess().getHyphenMinusGreaterThanSignKeyword_4()), one_space), one_space);
        Consumer<ISemanticRegion> _function = new Consumer<ISemanticRegion>(){

            @Override
            public void accept(ISemanticRegion it) {
                document.append(document.prepend(it, no_space), one_space);
            }
        };
        this.textRegionExtensions.regionFor((EObject)edge).keywords(new String[]{":", ","}).forEach(_function);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.indent();
            }
        };
        document.interior(document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)edge).keyword(this._elkGraphGrammarAccess.getElkEdgeAccess().getLeftCurlyBracketKeyword_7_0()), one_space), new_line), this.textRegionExtensions.regionFor((EObject)edge).keyword(this._elkGraphGrammarAccess.getElkEdgeAccess().getRightCurlyBracketKeyword_7_4()), (Procedures.Procedure1)_function_1);
        this.formatEdgeLayout(edge, document);
        EList _sections = edge.getSections();
        for (ElkEdgeSection section : _sections) {
            boolean _tripleNotEquals;
            document.format((Object)section);
            String _identifier = section.getIdentifier();
            boolean bl = _tripleNotEquals = _identifier != null;
            if (!_tripleNotEquals) continue;
            document.append((EObject)section, new_lines);
        }
        EMap _properties = edge.getProperties();
        for (Map.Entry property : _properties) {
            document.format((Object)property);
        }
        EList _labels = edge.getLabels();
        for (ElkLabel label : _labels) {
            document.format((Object)((ElkLabel)document.append((EObject)label, new_lines)));
        }
    }

    protected void _format(ElkPort port, final @Extension IFormattableDocument document) {
        document.append(this.textRegionExtensions.regionFor((EObject)port).keyword(this._elkGraphGrammarAccess.getElkPortAccess().getPortKeyword_0()), one_space);
        Consumer<ISemanticRegion> _function = new Consumer<ISemanticRegion>(){

            @Override
            public void accept(ISemanticRegion it) {
                document.append(document.prepend(it, no_space), one_space);
            }
        };
        this.textRegionExtensions.regionFor((EObject)port).keywords(new String[]{":", ","}).forEach(_function);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.indent();
            }
        };
        document.interior(document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)port).keyword(this._elkGraphGrammarAccess.getElkPortAccess().getLeftCurlyBracketKeyword_2_0()), one_space), new_line), this.textRegionExtensions.regionFor((EObject)port).keyword(this._elkGraphGrammarAccess.getElkPortAccess().getRightCurlyBracketKeyword_2_4()), (Procedures.Procedure1)_function_1);
        this.formatShapeLayout((ElkShape)port, document);
        EMap _properties = port.getProperties();
        for (Map.Entry property : _properties) {
            document.format((Object)property);
        }
        EList _labels = port.getLabels();
        for (ElkLabel label : _labels) {
            document.format((Object)((ElkLabel)document.append((EObject)label, new_lines)));
        }
    }

    protected void _format(ElkLabel label, final @Extension IFormattableDocument document) {
        document.append(this.textRegionExtensions.regionFor((EObject)label).keyword(this._elkGraphGrammarAccess.getElkLabelAccess().getLabelKeyword_0()), one_space);
        Consumer<ISemanticRegion> _function = new Consumer<ISemanticRegion>(){

            @Override
            public void accept(ISemanticRegion it) {
                document.append(document.prepend(it, no_space), one_space);
            }
        };
        this.textRegionExtensions.regionFor((EObject)label).keywords(new String[]{":", ","}).forEach(_function);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.indent();
            }
        };
        document.interior(document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)label).keyword(this._elkGraphGrammarAccess.getElkLabelAccess().getLeftCurlyBracketKeyword_3_0()), one_space), new_line), this.textRegionExtensions.regionFor((EObject)label).keyword(this._elkGraphGrammarAccess.getElkLabelAccess().getRightCurlyBracketKeyword_3_4()), (Procedures.Procedure1)_function_1);
        this.formatShapeLayout((ElkShape)label, document);
        EMap _properties = label.getProperties();
        for (Map.Entry property : _properties) {
            document.format((Object)property);
        }
        EList _labels = label.getLabels();
        for (ElkLabel nestedLabel : _labels) {
            document.format((Object)((ElkLabel)document.append((EObject)nestedLabel, new_lines)));
        }
    }

    protected void _format(ElkEdgeSection section, final @Extension IFormattableDocument document) {
        boolean _tripleEquals;
        Consumer<ISemanticRegion> _function = new Consumer<ISemanticRegion>(){

            @Override
            public void accept(ISemanticRegion it) {
                document.append(document.prepend(it, no_space), one_space);
            }
        };
        this.textRegionExtensions.regionFor((EObject)section).keywords(new String[]{":", ","}).forEach(_function);
        String _identifier = section.getIdentifier();
        boolean bl = _tripleEquals = _identifier == null;
        if (_tripleEquals) {
            document.append(this.textRegionExtensions.regionFor((EObject)section).assignment(this._elkGraphGrammarAccess.getElkSingleEdgeSectionAccess().getIncomingShapeAssignment_1_0_0_2()), new_line);
            document.append(this.textRegionExtensions.regionFor((EObject)section).assignment(this._elkGraphGrammarAccess.getElkSingleEdgeSectionAccess().getOutgoingShapeAssignment_1_0_1_2()), new_line);
            document.append(this.textRegionExtensions.regionFor((EObject)section).assignment(this._elkGraphGrammarAccess.getElkSingleEdgeSectionAccess().getStartYAssignment_1_0_2_4()), new_line);
            document.append(this.textRegionExtensions.regionFor((EObject)section).assignment(this._elkGraphGrammarAccess.getElkSingleEdgeSectionAccess().getEndYAssignment_1_0_3_4()), new_line);
            Consumer<ISemanticRegion> _function_1 = new Consumer<ISemanticRegion>(){

                @Override
                public void accept(ISemanticRegion it) {
                    document.append(document.prepend(it, one_space), one_space);
                }
            };
            this.textRegionExtensions.regionFor((EObject)section).keywords(new Keyword[]{this._elkGraphGrammarAccess.getElkSingleEdgeSectionAccess().getVerticalLineKeyword_1_1_3_0()}).forEach(_function_1);
        } else {
            document.append(this.textRegionExtensions.regionFor((EObject)section).keyword(this._elkGraphGrammarAccess.getElkEdgeSectionAccess().getSectionKeyword_0()), one_space);
            document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)section).keyword(this._elkGraphGrammarAccess.getElkEdgeSectionAccess().getHyphenMinusGreaterThanSignKeyword_2_0()), one_space), one_space);
            boolean _hasAtLeastOneProperty = this.hasAtLeastOneProperty(section);
            if (_hasAtLeastOneProperty) {
                Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.indent();
                    }
                };
                document.interior(document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)section).keyword(this._elkGraphGrammarAccess.getElkEdgeSectionAccess().getLeftSquareBracketKeyword_3()), one_space), new_line), this.textRegionExtensions.regionFor((EObject)section).keyword(this._elkGraphGrammarAccess.getElkEdgeSectionAccess().getRightSquareBracketKeyword_5()), (Procedures.Procedure1)_function_2);
                document.append(this.textRegionExtensions.regionFor((EObject)section).assignment(this._elkGraphGrammarAccess.getElkEdgeSectionAccess().getIncomingShapeAssignment_4_0_0_2()), new_line);
                document.append(this.textRegionExtensions.regionFor((EObject)section).assignment(this._elkGraphGrammarAccess.getElkEdgeSectionAccess().getOutgoingShapeAssignment_4_0_1_2()), new_line);
                document.append(this.textRegionExtensions.regionFor((EObject)section).assignment(this._elkGraphGrammarAccess.getElkEdgeSectionAccess().getStartYAssignment_4_0_2_4()), new_line);
                document.append(this.textRegionExtensions.regionFor((EObject)section).assignment(this._elkGraphGrammarAccess.getElkEdgeSectionAccess().getEndYAssignment_4_0_3_4()), new_line);
                Consumer<ISemanticRegion> _function_3 = new Consumer<ISemanticRegion>(){

                    @Override
                    public void accept(ISemanticRegion it) {
                        document.append(document.prepend(it, one_space), one_space);
                    }
                };
                this.textRegionExtensions.regionFor((EObject)section).keywords(new Keyword[]{this._elkGraphGrammarAccess.getElkEdgeSectionAccess().getVerticalLineKeyword_4_1_3_0()}).forEach(_function_3);
            } else {
                document.prepend(this.textRegionExtensions.regionFor((EObject)section).keyword(this._elkGraphGrammarAccess.getElkEdgeSectionAccess().getLeftSquareBracketKeyword_3()), one_space);
                document.prepend(this.textRegionExtensions.regionFor((EObject)section).keyword(this._elkGraphGrammarAccess.getElkEdgeSectionAccess().getRightSquareBracketKeyword_5()), no_space);
            }
        }
        document.append((EObject)((ElkBendPoint)IterableExtensions.last((Iterable)section.getBendPoints())), new_line);
        EList _bendPoints = section.getBendPoints();
        for (ElkBendPoint point : _bendPoints) {
            document.format((Object)point);
        }
        EMap _properties = section.getProperties();
        for (Map.Entry property : _properties) {
            document.format((Object)property);
        }
    }

    private boolean hasAtLeastOneProperty(ElkEdgeSection section) {
        return section.eIsSet((EStructuralFeature)ElkGraphPackage.Literals.ELK_EDGE_SECTION__INCOMING_SHAPE) || section.eIsSet((EStructuralFeature)ElkGraphPackage.Literals.ELK_EDGE_SECTION__OUTGOING_SHAPE) || section.eIsSet((EStructuralFeature)ElkGraphPackage.Literals.ELK_EDGE_SECTION__START_X) || section.eIsSet((EStructuralFeature)ElkGraphPackage.Literals.ELK_EDGE_SECTION__START_Y) || section.eIsSet((EStructuralFeature)ElkGraphPackage.Literals.ELK_EDGE_SECTION__END_X) || section.eIsSet((EStructuralFeature)ElkGraphPackage.Literals.ELK_EDGE_SECTION__END_Y) || !section.getBendPoints().isEmpty() || !section.getProperties().isEmpty();
    }

    protected void _format(ElkBendPoint bendPoint, @Extension IFormattableDocument document) {
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)bendPoint).keyword(this._elkGraphGrammarAccess.getElkBendPointAccess().getCommaKeyword_1()), no_space), one_space);
    }

    protected void _format(ElkPropertyToValueMapEntryImpl entry, @Extension IFormattableDocument document) {
        boolean _equals;
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)entry).keyword(this._elkGraphGrammarAccess.getPropertyAccess().getColonKeyword_1()), no_space), one_space);
        EObject _eContainer = entry.eContainer();
        EMapPropertyHolder container = (EMapPropertyHolder)_eContainer;
        int _indexOf = container.getProperties().indexOf((Object)entry);
        int _size = container.getProperties().size();
        int _minus = _size - 1;
        boolean bl = _equals = _indexOf == _minus;
        if (_equals) {
            document.append((EObject)entry, new_lines);
        } else {
            document.append((EObject)entry, new_line);
        }
    }

    private void formatShapeLayout(ElkShape shape, @Extension IFormattableDocument document) {
        int propCount = 0;
        if (shape.eIsSet((EStructuralFeature)ElkGraphPackage.Literals.ELK_SHAPE__X) || shape.eIsSet((EStructuralFeature)ElkGraphPackage.Literals.ELK_SHAPE__Y)) {
            ++propCount;
        }
        if (shape.eIsSet((EStructuralFeature)ElkGraphPackage.Literals.ELK_SHAPE__WIDTH) || shape.eIsSet((EStructuralFeature)ElkGraphPackage.Literals.ELK_SHAPE__HEIGHT)) {
            ++propCount;
        }
        if (propCount == 0) {
            document.prepend(this.textRegionExtensions.regionFor((EObject)shape).keyword(this._elkGraphGrammarAccess.getShapeLayoutAccess().getLeftSquareBracketKeyword_1()), one_space);
            document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)shape).keyword(this._elkGraphGrammarAccess.getShapeLayoutAccess().getRightSquareBracketKeyword_3()), no_space), new_lines);
        } else if (propCount == 1) {
            document.prepend(this.textRegionExtensions.regionFor((EObject)shape).keyword(this._elkGraphGrammarAccess.getShapeLayoutAccess().getLeftSquareBracketKeyword_1()), one_space);
            document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)shape).keyword(this._elkGraphGrammarAccess.getShapeLayoutAccess().getRightSquareBracketKeyword_3()), one_space), new_lines);
            document.prepend(this.textRegionExtensions.regionFor((EObject)shape).keyword(this._elkGraphGrammarAccess.getShapeLayoutAccess().getPositionKeyword_2_0_0()), one_space);
            document.prepend(this.textRegionExtensions.regionFor((EObject)shape).keyword(this._elkGraphGrammarAccess.getShapeLayoutAccess().getSizeKeyword_2_1_0()), one_space);
        } else {
            Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.indent();
                }
            };
            document.interior(document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)shape).keyword(this._elkGraphGrammarAccess.getShapeLayoutAccess().getLeftSquareBracketKeyword_1()), one_space), new_line), document.append(this.textRegionExtensions.regionFor((EObject)shape).keyword(this._elkGraphGrammarAccess.getShapeLayoutAccess().getRightSquareBracketKeyword_3()), new_lines), (Procedures.Procedure1)_function);
            document.append(this.textRegionExtensions.regionFor((EObject)shape).assignment(this._elkGraphGrammarAccess.getShapeLayoutAccess().getYAssignment_2_0_4()), new_line);
            document.append(this.textRegionExtensions.regionFor((EObject)shape).assignment(this._elkGraphGrammarAccess.getShapeLayoutAccess().getHeightAssignment_2_1_4()), new_line);
        }
    }

    private void formatEdgeLayout(ElkEdge edge, @Extension IFormattableDocument document) {
        int sectionCount = edge.getSections().size();
        if (sectionCount == 0) {
            document.prepend(this.textRegionExtensions.regionFor((EObject)edge).keyword(this._elkGraphGrammarAccess.getEdgeLayoutAccess().getLeftSquareBracketKeyword_1()), one_space);
            document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)edge).keyword(this._elkGraphGrammarAccess.getEdgeLayoutAccess().getRightSquareBracketKeyword_3()), no_space), new_lines);
        } else {
            Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.indent();
                }
            };
            document.interior(document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)edge).keyword(this._elkGraphGrammarAccess.getEdgeLayoutAccess().getLeftSquareBracketKeyword_1()), one_space), new_line), document.append(this.textRegionExtensions.regionFor((EObject)edge).keyword(this._elkGraphGrammarAccess.getEdgeLayoutAccess().getRightSquareBracketKeyword_3()), new_lines), (Procedures.Procedure1)_function);
        }
    }

    public void format(Object node, IFormattableDocument document) {
        if (node instanceof ElkNode) {
            this._format((ElkNode)node, document);
            return;
        }
        if (node instanceof ElkPort) {
            this._format((ElkPort)node, document);
            return;
        }
        if (node instanceof ElkPropertyToValueMapEntryImpl) {
            this._format((ElkPropertyToValueMapEntryImpl)node, document);
            return;
        }
        if (node instanceof ElkLabel) {
            this._format((ElkLabel)node, document);
            return;
        }
        if (node instanceof ElkEdge) {
            this._format((ElkEdge)node, document);
            return;
        }
        if (node instanceof XtextResource) {
            this._format((XtextResource)node, document);
            return;
        }
        if (node instanceof ElkEdgeSection) {
            this._format((ElkEdgeSection)node, document);
            return;
        }
        if (node instanceof ElkBendPoint) {
            this._format((ElkBendPoint)node, document);
            return;
        }
        if (node instanceof EObject) {
            this._format((EObject)node, document);
            return;
        }
        if (node == null) {
            this._format(null, document);
            return;
        }
        if (node != null) {
            this._format(node, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node, document).toString());
    }
}

