/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.replacement;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.common.MetamodelFactory;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="introduceReferenceClass", label="Association to Class", description="In the metamodel, a reference is replaced by a reference class. More specifically, the reference class is now contained by the source class. In the model, links conforming to the reference are replaced by instances of the reference class.")
public class IntroduceReferenceClass
extends OperationImplementation {
    @EdaptParameter(main=true, description="The reference to be replaced by a reference class")
    public EReference reference;
    @EdaptParameter(description="The name of the reference class")
    public String className;
    @EdaptParameter(description="The name of the opposite reference to the source class", optional=true)
    public String sourceReferenceName;
    @EdaptParameter(description="The name of the opposite reference to the target class", optional=true)
    public String targetReferenceName;

    @EdaptConstraint(description="Reference has to have an opposite")
    public boolean checkReferenceOpposite() {
        return this.reference.getEOpposite() != null;
    }

    @EdaptConstraint(description="Opposite reference is not allowed to be containment")
    public boolean checkOppositeNotContainment() {
        return this.reference.getEOpposite() == null || !this.reference.getEOpposite().isContainment();
    }

    @EdaptConstraint(description="Reference is not allowed to be containment")
    public boolean checkReferenceNotContainment() {
        return !this.reference.isContainment();
    }

    public void execute(Metamodel metamodel, Model model) {
        EReference opposite = this.reference.getEOpposite();
        EClass sourceClass = this.reference.getEContainingClass();
        EClass targetClass = this.reference.getEReferenceType();
        EPackage contextPackage = sourceClass.getEPackage();
        EClass referenceClass = MetamodelFactory.newEClass((EPackage)contextPackage, (String)this.className);
        metamodel.setEOpposite(this.reference, null);
        this.reference.setEType((EClassifier)referenceClass);
        opposite.setEType((EClassifier)referenceClass);
        this.reference.setContainment(true);
        for (Instance target : model.getAllInstances(targetClass)) {
            target.unset((EStructuralFeature)opposite);
        }
        for (Instance source : model.getAllInstances(sourceClass)) {
            Instance target2;
            if (this.reference.isMany()) {
                for (Instance target2 : (List)source.unset((EStructuralFeature)this.reference)) {
                    Instance referenceInstance = model.newInstance(referenceClass);
                    source.add((EStructuralFeature)this.reference, (Object)referenceInstance);
                    this.put(target2, opposite, referenceInstance);
                }
                continue;
            }
            target2 = (Instance)source.unset((EStructuralFeature)this.reference);
            if (target2 == null) continue;
            Instance referenceInstance = model.newInstance(referenceClass);
            source.set((EStructuralFeature)this.reference, (Object)referenceInstance);
            this.put(target2, opposite, referenceInstance);
        }
        if (this.sourceReferenceName != null) {
            EReference sourceReference = MetamodelFactory.newEReference((EClass)referenceClass, (String)this.sourceReferenceName, (EClass)sourceClass, (int)1, (int)1, (boolean)false);
            metamodel.setEOpposite(this.reference, sourceReference);
        }
        if (this.targetReferenceName != null) {
            EReference targetReference = MetamodelFactory.newEReference((EClass)referenceClass, (String)this.targetReferenceName, (EClass)targetClass, (int)1, (int)1, (boolean)false);
            metamodel.setEOpposite(opposite, targetReference);
        }
    }

    private void put(Instance target, EReference opposite, Instance referenceInstance) {
        if (opposite.isMany()) {
            target.add((EStructuralFeature)opposite, (Object)referenceInstance);
        } else {
            target.set((EStructuralFeature)opposite, (Object)referenceInstance);
        }
    }
}

