/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core.subinterfaces;

import java.io.IOException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.emfstore.internal.server.core.AbstractEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.AbstractSubEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.helper.EmfStoreMethod;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.OrgUnitProperty;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

public class ProjectPropertiesSubInterfaceImpl
extends AbstractSubEmfstoreInterface {
    public ProjectPropertiesSubInterfaceImpl(AbstractEmfstoreInterface parentInterface) throws FatalESException {
        super(parentInterface);
    }

    @EmfStoreMethod(value=EmfStoreMethod.MethodId.TRANSMITPROPERTY)
    public void transmitProperty(OrgUnitProperty changedProperty, ACUser recUser, ProjectId projectId) throws ESException {
        this.sanityCheckObjects(changedProperty, recUser, projectId);
        EList users = this.getServerSpace().getUsers();
        ACUser user = null;
        for (ACUser serverUser : users) {
            if (!serverUser.getIdentifier().equals(recUser.getIdentifier())) continue;
            user = serverUser;
            break;
        }
        if (user == null) {
            throw new ESException("The user does not exist on the server. Cannot set the property.");
        }
        for (OrgUnitProperty property : user.getProperties()) {
            if (!property.getName().equals(changedProperty.getName()) || !this.isProjectEqual(property, changedProperty)) continue;
            property.setValue(changedProperty.getValue());
            this.save();
            return;
        }
        user.getProperties().add((Object)changedProperty);
        this.save();
    }

    private boolean isProjectEqual(OrgUnitProperty property, OrgUnitProperty changedProperty) {
        if (property.getProject() == null && changedProperty.getProject() == null) {
            return true;
        }
        if (property.getProject() == null) {
            return false;
        }
        if (changedProperty.getProject() == null) {
            return false;
        }
        return property.getProject().equals(changedProperty.getProject());
    }

    private void save() throws ESException {
        try {
            this.getServerSpace().save();
        }
        catch (IOException iOException) {
            throw new ESException("Cannot set the property on the server.");
        }
    }
}

