/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.model.versioning.impl;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.emfstore.internal.common.ResourceFactoryRegistry;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESFileBasedChangePackageImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.OperationProxy;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningPackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.ChangePackageContainer;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.Direction;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.FileBasedOperationIterable;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.OperationEmitter;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.ReadLineCapable;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util.ChangePackageUtil;
import org.eclipse.emf.emfstore.server.ESCloseableIterable;
import org.eclipse.emf.emfstore.server.model.ESChangePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedChangePackageImpl
extends EObjectImpl
implements FileBasedChangePackage {
    private static final String EMPTY_CHANGE_PACKAGE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xmi:XMI xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\"/>\n<org.eclipse.emf.emfstore.internal.server.model.versioning:ChangePackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:org.eclipse.emf.emfstore.internal.server.model.versioning=\"http://eclipse.org/emf/emfstore/server/model/versioning\" xmlns:org.eclipse.emf.emfstore.internal.server.model.versioning.operations=\"http://eclipse.org/emf/emfstore/server/model/versioning/operations\">\n</org.eclipse.emf.emfstore.internal.server.model.versioning:ChangePackage>";
    private static final String TEMP_FILE_PREFIX = "temp-";
    private static final String TEMP_SUFFIX = ".temp";
    private static final String OPERATION_FILE_SUFFIX = ".eoc";
    protected LogMessage logMessage;
    private static Map<Object, Object> loadingOptions;
    private ESChangePackage apiImpl;
    private boolean needsInit;
    protected static final String FILE_PATH_EDEFAULT;
    protected String filePath = FILE_PATH_EDEFAULT;
    protected EList<OperationProxy> operationProxies;

    static {
        FILE_PATH_EDEFAULT = null;
    }

    protected FileBasedChangePackageImpl() {
    }

    protected EClass eStaticClass() {
        return VersioningPackage.Literals.FILE_BASED_CHANGE_PACKAGE;
    }

    @Override
    public LogMessage getLogMessage() {
        if (this.logMessage != null && this.logMessage.eIsProxy()) {
            InternalEObject oldLogMessage = (InternalEObject)this.logMessage;
            this.logMessage = (LogMessage)this.eResolveProxy(oldLogMessage);
            if (this.logMessage != oldLogMessage) {
                InternalEObject newLogMessage = (InternalEObject)this.logMessage;
                NotificationChain msgs = oldLogMessage.eInverseRemove((InternalEObject)this, -1, null, null);
                if (newLogMessage.eInternalContainer() == null) {
                    msgs = newLogMessage.eInverseAdd((InternalEObject)this, -1, null, msgs);
                }
                if (msgs != null) {
                    msgs.dispatch();
                }
                if (this.eNotificationRequired()) {
                    this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 0, (Object)oldLogMessage, (Object)this.logMessage));
                }
            }
        }
        return this.logMessage;
    }

    public LogMessage basicGetLogMessage() {
        return this.logMessage;
    }

    public NotificationChain basicSetLogMessage(LogMessage newLogMessage, NotificationChain msgs) {
        LogMessage oldLogMessage = this.logMessage;
        this.logMessage = newLogMessage;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldLogMessage, (Object)newLogMessage);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setLogMessage(LogMessage newLogMessage) {
        if (newLogMessage != this.logMessage) {
            NotificationChain msgs = null;
            if (this.logMessage != null) {
                msgs = ((InternalEObject)this.logMessage).eInverseRemove((InternalEObject)this, -1, null, msgs);
            }
            if (newLogMessage != null) {
                msgs = ((InternalEObject)newLogMessage).eInverseAdd((InternalEObject)this, -1, null, msgs);
            }
            if ((msgs = this.basicSetLogMessage(newLogMessage, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)newLogMessage, (Object)newLogMessage));
        }
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public String getTempFilePath() {
        return String.valueOf(this.filePath) + TEMP_SUFFIX;
    }

    @Override
    public void setFilePath(String newFilePath) {
        String oldFilePath = this.filePath;
        this.filePath = newFilePath;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldFilePath, (Object)this.filePath));
        }
    }

    @Override
    public EList<OperationProxy> getOperationProxies() {
        if (this.operationProxies == null) {
            this.operationProxies = new EObjectContainmentEList.Resolving(OperationProxy.class, (InternalEObject)this, 2);
        }
        return this.operationProxies;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return this.basicSetLogMessage(null, msgs);
            }
            case 2: {
                return ((InternalEList)this.getOperationProxies()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                if (resolve) {
                    return this.getLogMessage();
                }
                return this.basicGetLogMessage();
            }
            case 1: {
                return this.getFilePath();
            }
            case 2: {
                return this.getOperationProxies();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setLogMessage((LogMessage)newValue);
                return;
            }
            case 1: {
                this.setFilePath((String)newValue);
                return;
            }
            case 2: {
                this.getOperationProxies().clear();
                this.getOperationProxies().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setLogMessage(null);
                return;
            }
            case 1: {
                this.setFilePath(FILE_PATH_EDEFAULT);
                return;
            }
            case 2: {
                this.getOperationProxies().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.logMessage != null;
            }
            case 1: {
                return FILE_PATH_EDEFAULT == null ? this.filePath != null : !FILE_PATH_EDEFAULT.equals(this.filePath);
            }
            case 2: {
                return this.operationProxies != null && !this.operationProxies.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (filePath: ");
        result.append(this.filePath);
        result.append(')');
        return result.toString();
    }

    @Override
    public ESChangePackage toAPI() {
        if (this.apiImpl == null) {
            this.apiImpl = this.createAPI();
        }
        return this.apiImpl;
    }

    public ESChangePackage createAPI() {
        return new ESFileBasedChangePackageImpl(this);
    }

    @Override
    public void addAll(List<AbstractOperation> ops) {
        for (AbstractOperation op : ops) {
            this.add(op);
        }
    }

    @Override
    public void add(AbstractOperation op) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Resource resource = FileBasedChangePackageImpl.createVirtualResource();
        resource.getContents().add((Object)op);
        Optional maybeRandomAccessFile = Optional.absent();
        try {
            try {
                outputStream.write(FileBasedChangePackageImpl.asBytes("<operations>\n"));
                resource.save((OutputStream)outputStream, FileBasedChangePackageImpl.loadingOptions());
                outputStream.write(FileBasedChangePackageImpl.asBytes("</operations>\n"));
                if (this.needsInit) {
                    this.initializeEmptyChangePackage();
                }
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.getTempFilePath(), "rw");
                maybeRandomAccessFile = Optional.of((Object)randomAccessFile);
                randomAccessFile.skipBytes((int)(randomAccessFile.length() - (long)FileBasedChangePackageImpl.asBytes("</org.eclipse.emf.emfstore.internal.server.model.versioning:ChangePackage>").length));
                randomAccessFile.write(outputStream.toByteArray());
                randomAccessFile.write(FileBasedChangePackageImpl.asBytes("</org.eclipse.emf.emfstore.internal.server.model.versioning:ChangePackage>"));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        finally {
            try {
                outputStream.close();
                if (maybeRandomAccessFile.isPresent()) {
                    ((RandomAccessFile)maybeRandomAccessFile.get()).close();
                }
            }
            catch (IOException ex) {
                ModelUtil.logException((Throwable)ex);
            }
        }
    }

    @Override
    public FileBasedChangePackage reverse() {
        FileBasedChangePackage reversedChangePackage = VersioningFactory.eINSTANCE.createFileBasedChangePackage();
        try {
            File tempFile = File.createTempFile(TEMP_FILE_PREFIX, OPERATION_FILE_SUFFIX);
            tempFile.deleteOnExit();
            reversedChangePackage.initialize(tempFile.getAbsolutePath());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        ESCloseableIterable<AbstractOperation> operationsHandle = this.reversedOperations();
        try {
            Iterable<AbstractOperation> operations = operationsHandle.iterable();
            for (AbstractOperation operation : operations) {
                AbstractOperation reversedOperation = operation.reverse();
                reversedChangePackage.add(reversedOperation);
            }
        }
        finally {
            operationsHandle.close();
        }
        return reversedChangePackage;
    }

    public FileBasedChangePackage copy() {
        FileBasedChangePackage changePackage = VersioningFactory.eINSTANCE.createFileBasedChangePackage();
        try {
            File tempFile = File.createTempFile(TEMP_FILE_PREFIX, OPERATION_FILE_SUFFIX);
            tempFile.deleteOnExit();
            changePackage.initialize(tempFile.getAbsolutePath());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        ESCloseableIterable<AbstractOperation> operationsHandle = this.operations();
        try {
            Iterable<AbstractOperation> operations = operationsHandle.iterable();
            for (AbstractOperation operation : operations) {
                changePackage.add(operation);
            }
        }
        finally {
            operationsHandle.close();
        }
        return changePackage;
    }

    @Override
    public ESCloseableIterable<AbstractOperation> reversedOperations() {
        return new FileBasedOperationIterable(this.getTempFilePath(), Direction.Backward);
    }

    private static Map<Object, Object> loadingOptions() {
        if (loadingOptions == null) {
            loadingOptions = new LinkedHashMap<Object, Object>();
            loadingOptions.put("DECLARE_XML", Boolean.FALSE);
            loadingOptions.put("RECORD_ANY_TYPE_NAMESPACE_DECLARATIONS", Boolean.TRUE);
        }
        return loadingOptions;
    }

    private static byte[] asBytes(String s) {
        return s.getBytes();
    }

    private static Resource createVirtualResource() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)new ResourceFactoryRegistry());
        return resourceSet.createResource(URI.createURI((String)"virtualResource.xmi"));
    }

    @Override
    public int size() {
        int counter = 0;
        Optional maybeReversedReader = Optional.absent();
        try {
            try {
                String line;
                ReversedLinesFileReader reversedReader = new ReversedLinesFileReader(new File(this.getTempFilePath()));
                maybeReversedReader = Optional.of((Object)reversedReader);
                while ((line = reversedReader.readLine()) != null) {
                    if (!line.contains("</operations>")) continue;
                    ++counter;
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        finally {
            if (maybeReversedReader.isPresent()) {
                try {
                    ((ReversedLinesFileReader)maybeReversedReader.get()).close();
                }
                catch (IOException ex) {
                    ModelUtil.logException((Throwable)ex);
                }
            }
        }
        return counter;
    }

    @Override
    public ESCloseableIterable<AbstractOperation> operations() {
        return new FileBasedOperationIterable(this.getTempFilePath(), Direction.Forward);
    }

    @Override
    public boolean isEmpty() {
        Optional maybeReader = Optional.absent();
        try {
            File file = new File(this.getTempFilePath());
            if (!file.exists()) {
                return true;
            }
            OperationEmitter operationEmitter = new OperationEmitter(Direction.Forward);
            maybeReader = Optional.of((Object)new BufferedReader(new FileReader(file)));
            ReadLineCapable create = ReadLineCapable.INSTANCE.create((BufferedReader)maybeReader.get());
            Optional<AbstractOperation> maybeOp = operationEmitter.tryEmit(create);
            boolean bl = !maybeOp.isPresent();
            return bl;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (maybeReader.isPresent()) {
                    ((BufferedReader)maybeReader.get()).close();
                }
            }
            catch (IOException ex) {
                ModelUtil.logException((Throwable)ex);
            }
        }
    }

    @Override
    public List<AbstractOperation> removeAtEnd(int n) {
        ArrayList<AbstractOperation> ops = new ArrayList<AbstractOperation>();
        OperationEmitter operationEmitter = new OperationEmitter(Direction.Backward);
        Optional maybeReversedReader = Optional.absent();
        int counter = n;
        try {
            ReversedLinesFileReader reversedReader = new ReversedLinesFileReader(new File(this.getTempFilePath()));
            maybeReversedReader = Optional.of((Object)reversedReader);
            ReadLineCapable reader = ReadLineCapable.INSTANCE.create(reversedReader);
            Optional<AbstractOperation> maybeOperation = operationEmitter.tryEmit(reader);
            while (counter > 0 && maybeOperation.isPresent()) {
                AbstractOperation operation = (AbstractOperation)maybeOperation.get();
                ops.add(operation);
                --counter;
            }
            long offset = operationEmitter.getOffset();
            RandomAccessFile raf = new RandomAccessFile(this.getTempFilePath(), "rw");
            long skip = raf.length() + 1L - offset;
            raf.seek(skip);
            byte[] bytes = FileBasedChangePackageImpl.asBytes("\n</org.eclipse.emf.emfstore.internal.server.model.versioning:ChangePackage>");
            raf.write(bytes);
            raf.setLength(skip + (long)bytes.length);
            raf.close();
            ArrayList<AbstractOperation> arrayList = ops;
            return arrayList;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            if (maybeReversedReader.isPresent()) {
                try {
                    ((ReversedLinesFileReader)maybeReversedReader.get()).close();
                }
                catch (IOException ex) {
                    ModelUtil.logException((Throwable)ex);
                }
            }
        }
    }

    @Override
    public void clear() {
        Optional maybeRandomAccessFile = Optional.absent();
        try {
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.getTempFilePath(), "rw");
                maybeRandomAccessFile = Optional.of((Object)randomAccessFile);
                randomAccessFile.seek(0L);
                randomAccessFile.write(FileBasedChangePackageImpl.asBytes(EMPTY_CHANGE_PACKAGE));
                randomAccessFile.setLength(EMPTY_CHANGE_PACKAGE.length());
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (maybeRandomAccessFile.isPresent()) {
                try {
                    ((RandomAccessFile)maybeRandomAccessFile.get()).close();
                }
                catch (IOException ex) {
                    ModelUtil.logException((Throwable)ex);
                }
            }
        }
    }

    @Override
    public void attachToProjectSpace(ChangePackageContainer changePackageHolder) {
        URI changePackageUri = changePackageHolder.getChangePackageUri();
        String operationFileString = changePackageUri.toFileString();
        File operationFile = new File(String.valueOf(operationFileString) + TEMP_SUFFIX);
        File thisFile = new File(this.getTempFilePath());
        try {
            FileUtil.copyFile((File)thisFile, (File)operationFile);
            thisFile.delete();
            this.setFilePath(operationFileString);
            changePackageHolder.setChangePackage(this);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void delete() {
        File opFile = new File(this.getFilePath());
        File tempOpFile = new File(this.getTempFilePath());
        opFile.delete();
        tempOpFile.delete();
    }

    @Override
    public int leafSize() {
        return ChangePackageUtil.countLeafOperations(Collections.singletonList(this));
    }

    @Override
    public void initialize(String filePath) {
        this.setFilePath(filePath);
        this.initializeEmptyChangePackage();
    }

    private void initializeEmptyChangePackage() {
        this.needsInit = false;
        Optional maybeWriter = Optional.absent();
        try {
            try {
                FileWriter fileWriter = new FileWriter(this.getTempFilePath());
                maybeWriter = Optional.of((Object)fileWriter);
                fileWriter.write(EMPTY_CHANGE_PACKAGE);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        finally {
            if (maybeWriter.isPresent()) {
                try {
                    ((FileWriter)maybeWriter.get()).close();
                }
                catch (IOException ex) {
                    ModelUtil.logException((Throwable)ex);
                }
            }
        }
    }

    @Override
    public void apply(Project project) {
        this.apply(project, false);
    }

    @Override
    public void apply(Project project, boolean forceApplication) {
        ESCloseableIterable<AbstractOperation> operations = this.operations();
        try {
            Iterable<AbstractOperation> operationsIterable = operations.iterable();
            for (AbstractOperation operation : operationsIterable) {
                try {
                    operation.apply((IdEObjectCollection)project);
                }
                catch (IllegalStateException e) {
                    if (forceApplication) continue;
                    throw e;
                }
            }
        }
        finally {
            operations.close();
        }
    }

    @Override
    public AbstractOperation get(int index) {
        ESCloseableIterable<AbstractOperation> operations = this.operations();
        try {
            Iterable<AbstractOperation> iterable = operations.iterable();
            AbstractOperation abstractOperation = (AbstractOperation)Iterables.get(iterable, (int)index);
            return abstractOperation;
        }
        finally {
            operations.close();
        }
    }

    @Override
    public ChangePackage toInMemoryChangePackage() {
        ChangePackage changePackage = VersioningFactory.eINSTANCE.createChangePackage();
        ESCloseableIterable<AbstractOperation> operationsHandle = this.operations();
        try {
            for (AbstractOperation operation : operationsHandle.iterable()) {
                changePackage.add(operation);
            }
        }
        finally {
            operationsHandle.close();
        }
        changePackage.setLogMessage((LogMessage)ModelUtil.clone((EObject)this.getLogMessage()));
        return changePackage;
    }

    @Override
    public void save() throws IOException {
        File tempFile = new File(this.getTempFilePath());
        File filePath = new File(this.getFilePath());
        FileUtil.copyFile((File)tempFile, (File)filePath);
    }
}

