/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLLoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.Direction;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.ReadLineCapable;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationEmitter
implements Closeable {
    private final Direction direction;
    private final File operationsFile;
    private ReadLineCapable reader;
    private final List<Long> forwardOffsets = new ArrayList<Long>();
    private final List<Long> backwardsOffsets = new ArrayList<Long>();
    private int currentOpIndex;
    private long startOffset;

    public OperationEmitter(Direction direction, File file) {
        this.direction = direction;
        this.operationsFile = file;
        this.determineOperationOffsets();
        this.currentOpIndex = direction == Direction.Forward ? 0 : this.backwardsOffsets.size() - 1;
        this.initReader();
    }

    private void determineOperationOffsets() {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.operationsFile, "r");
            InputStream inputStream = Channels.newInputStream(randomAccessFile.getChannel());
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            long filePointer = 0L;
            try {
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    long filePointerAfterReadline = randomAccessFile.getFilePointer();
                    randomAccessFile.seek(filePointer += (long)line.getBytes().length);
                    int byteAfterLine = randomAccessFile.read();
                    if (byteAfterLine == 13) {
                        ++filePointer;
                        byteAfterLine = randomAccessFile.read();
                    }
                    if (byteAfterLine == 10) {
                        ++filePointer;
                    }
                    randomAccessFile.seek(filePointerAfterReadline);
                    if (line.contains("<org.eclipse.emf.emfstore.internal.server.model.versioning:ChangePackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:org.eclipse.emf.emfstore.internal.server.model.versioning=\"http://eclipse.org/emf/emfstore/server/model/versioning\" xmlns:org.eclipse.emf.emfstore.internal.server.model.versioning.operations=\"http://eclipse.org/emf/emfstore/server/model/versioning/operations\">")) {
                        this.startOffset = filePointer;
                        continue;
                    }
                    if (line.contains("<operations>")) {
                        this.forwardOffsets.add(filePointer);
                        continue;
                    }
                    if (!line.contains("</operations>")) continue;
                    this.backwardsOffsets.add(filePointer);
                }
            }
            finally {
                bufferedReader.close();
                randomAccessFile.close();
            }
        }
        catch (IOException ex) {
            ModelUtil.logException((Throwable)ex);
        }
    }

    private void initReader() {
        try {
            this.reader = this.direction == Direction.Forward ? ReadLineCapable.INSTANCE.create(new BufferedReader(new FileReader(this.operationsFile))) : ReadLineCapable.INSTANCE.create(new ReversedLinesFileReader(this.operationsFile));
        }
        catch (IOException ex) {
            ModelUtil.logException((Throwable)ex);
        }
    }

    public long getOffset() {
        if (this.currentOpIndex < 0) {
            return this.startOffset;
        }
        return this.backwardsOffsets.get(this.currentOpIndex);
    }

    private static void writeDummyResourceToStream(PipedOutputStream pos) throws IOException {
        pos.write("<?xml version=\"1.0\" encoding=\"ASCII\"?>\n<ecore:EObject xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\"/>".getBytes());
    }

    private void readForward(PipedOutputStream pos) {
        try {
            try {
                boolean operationsFound = false;
                boolean withinOperationsElement = false;
                boolean isForwardDir = this.direction == Direction.Forward;
                String closingTag = this.getClosingTag(isForwardDir);
                String line = this.reader.readLine();
                while (line != null && !line.contains(closingTag)) {
                    if (line.contains(this.getOpeningTag(isForwardDir))) {
                        withinOperationsElement = true;
                    } else if (withinOperationsElement) {
                        operationsFound = true;
                        pos.write(line.getBytes());
                    }
                    line = this.reader.readLine();
                }
                if (line != null) {
                    withinOperationsElement = false;
                }
                if (!operationsFound) {
                    OperationEmitter.writeDummyResourceToStream(pos);
                }
            }
            catch (IOException ex) {
                ModelUtil.logException((Throwable)ex);
                try {
                    pos.close();
                }
                catch (IOException ex2) {
                    ModelUtil.logException((Throwable)ex2);
                }
            }
        }
        finally {
            try {
                pos.close();
            }
            catch (IOException ex) {
                ModelUtil.logException((Throwable)ex);
            }
        }
    }

    private void readForward(DataInput reader, PipedOutputStream pos) {
        try {
            try {
                boolean operationsFound = false;
                boolean withinOperationsElement = true;
                String closingTag = this.getClosingTag(true);
                String line = reader.readLine();
                while (line != null && !line.contains(closingTag)) {
                    if (line.contains(this.getOpeningTag(true))) {
                        withinOperationsElement = true;
                    } else if (withinOperationsElement && line.length() > 0) {
                        operationsFound = true;
                        pos.write(line.getBytes());
                    }
                    line = reader.readLine();
                }
                if (!operationsFound) {
                    OperationEmitter.writeDummyResourceToStream(pos);
                }
            }
            catch (IOException ex) {
                ModelUtil.logException((Throwable)ex);
                try {
                    pos.close();
                }
                catch (IOException ex2) {
                    ModelUtil.logException((Throwable)ex2);
                }
            }
        }
        finally {
            try {
                pos.close();
            }
            catch (IOException ex) {
                ModelUtil.logException((Throwable)ex);
            }
        }
    }

    private void readBackward(PipedOutputStream pos) {
        if (this.currentOpIndex < 0) {
            try {
                pos.close();
            }
            catch (IOException ex) {
                ModelUtil.logException((Throwable)ex);
            }
            return;
        }
        long offset = this.forwardOffsets.get(this.currentOpIndex);
        --this.currentOpIndex;
        RandomAccessFile raf = null;
        try {
            try {
                raf = new RandomAccessFile(this.operationsFile, "r");
                raf.skipBytes((int)offset);
                this.readForward(raf, pos);
            }
            catch (IOException ex) {
                ModelUtil.logException((Throwable)ex);
                try {
                    raf.close();
                }
                catch (IOException ex2) {
                    ModelUtil.logException((Throwable)ex2);
                }
            }
        }
        finally {
            try {
                raf.close();
            }
            catch (IOException ex) {
                ModelUtil.logException((Throwable)ex);
            }
        }
    }

    public Optional<AbstractOperation> tryEmit() throws IOException {
        final PipedOutputStream pos = new PipedOutputStream();
        PipedInputStream pis = new PipedInputStream(pos);
        new Thread(new Runnable(){

            public void run() {
                if (OperationEmitter.this.direction == Direction.Forward) {
                    OperationEmitter.this.readForward(pos);
                } else {
                    OperationEmitter.this.readBackward(pos);
                }
            }
        }).start();
        try {
            EObject deserializedObject = this.deserialize(pis);
            if (AbstractOperation.class.isInstance(deserializedObject)) {
                Optional optional = Optional.of((Object)((AbstractOperation)AbstractOperation.class.cast(deserializedObject)));
                return optional;
            }
            Optional optional = Optional.absent();
            return optional;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            pis.close();
        }
    }

    private String getClosingTag(boolean isForward) {
        return isForward ? "</operations>" : "<operations>";
    }

    private String getOpeningTag(boolean isForward) {
        return isForward ? "<operations>" : "</operations>";
    }

    private EObject deserialize(PipedInputStream pis) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createURI((String)"virtualResource.xmi"));
        ((XMLResourceImpl)resource).setIntrinsicIDToEObjectMap((Map)Maps.newLinkedHashMap());
        XMLLoadImpl xmlLoadImpl = new XMLLoadImpl((XMLHelper)new XMLHelperImpl());
        xmlLoadImpl.load((XMLResource)resource, (InputStream)pis, ModelUtil.getResourceLoadOptions());
        return (EObject)resource.getContents().get(0);
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException ex) {
            ModelUtil.logException((Throwable)ex);
        }
    }
}

