/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.lang.NotImplementedException;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.Direction;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.OperationEmitter;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationIterator
implements Iterator<AbstractOperation> {
    private Optional<AbstractOperation> operation;
    private OperationEmitter operationEmitter;
    private boolean isInitialized;
    private final String operationsFilePath;
    private final Direction direction;

    public OperationIterator(String operationsFilePath, Direction direction) {
        this.operationsFilePath = operationsFilePath;
        this.direction = direction;
        this.init();
    }

    private void init() {
        this.operationEmitter = new OperationEmitter(this.direction, new File(this.operationsFilePath));
        this.isInitialized = true;
    }

    @Override
    public boolean hasNext() {
        if (!this.isInitialized) {
            this.init();
        }
        try {
            this.operation = this.operationEmitter.tryEmit();
            boolean hasNext = this.operation.isPresent();
            if (!hasNext) {
                this.close();
            }
            return hasNext;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public AbstractOperation next() {
        if (this.operation == null) {
            this.hasNext();
        }
        return (AbstractOperation)this.operation.get();
    }

    @Override
    public void remove() {
        throw new NotImplementedException();
    }

    public void close() {
        this.operationEmitter.close();
    }
}

