/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.filetransfer;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.Messages;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.server.exceptions.FileTransferException;
import org.eclipse.emf.emfstore.internal.server.model.FileIdentifier;

public class FileTransferCacheManager {
    public static final String TEMP_FOLDER = "tmp";
    public static final String PROJECT_FOLDER_PREFIX = "project-";
    public static final String ATTACHMENT_FOLDER = "attachment";
    public static final String FILE_NAME_DELIMITER = "_";
    private final File cacheFolder;
    private final File tempCacheFolder;

    public FileTransferCacheManager(ProjectSpace projectSpaceImpl) {
        this.cacheFolder = new File(FileTransferCacheManager.getCacheFolder(projectSpaceImpl));
        this.tempCacheFolder = new File(this.cacheFolder, "temp");
        this.mkdirs();
    }

    public FileTransferCacheManager() {
        this.cacheFolder = new File(new File(System.getProperty("java.io.tmpdir")), "ESFileTransferCacheManager" + System.currentTimeMillis());
        this.tempCacheFolder = new File(this.cacheFolder, "temp");
        this.mkdirs();
        this.cacheFolder.deleteOnExit();
    }

    public static String getCacheFolder(ProjectSpace projectSpace) {
        return String.valueOf(Configuration.getFileInfo().getWorkspaceDirectory()) + "ps-" + projectSpace.getIdentifier() + File.separatorChar + "files" + File.separatorChar;
    }

    public boolean hasCachedFile(FileIdentifier identifier) {
        File f = this.getFileFromId(this.cacheFolder, identifier);
        return f.exists();
    }

    public File getCachedFile(FileIdentifier identifier) throws FileTransferException {
        File f = this.getFileFromId(this.cacheFolder, identifier);
        if (!f.exists()) {
            throw new FileTransferException(MessageFormat.format(Messages.FileTransferCacheManager_FileNotInCache, identifier));
        }
        return f;
    }

    public File cacheFile(File input, FileIdentifier id) throws IOException {
        this.mkdirs();
        File destination = new File(this.cacheFolder, id.getIdentifier());
        FileUtil.copyFile((File)input, (File)destination);
        return destination;
    }

    public File createTempFile(FileIdentifier id) throws FileTransferException {
        this.mkdirs();
        File cacheFile = this.getFileFromId(this.tempCacheFolder, id);
        cacheFile.getParentFile().mkdirs();
        if (cacheFile.exists()) {
            cacheFile.delete();
        }
        try {
            cacheFile.createNewFile();
        }
        catch (IOException iOException) {
            throw new FileTransferException(Messages.FileTransferCacheManager_CreateTempFileFailed);
        }
        return cacheFile;
    }

    public File moveTempFileToCache(FileIdentifier id) throws FileTransferException {
        return this.moveTempFileToCache(id, false);
    }

    public File moveTempFileToCache(FileIdentifier id, boolean overwrite) throws FileTransferException {
        this.mkdirs();
        File cacheFile = this.getFileFromId(this.cacheFolder, id);
        File tmpFile = this.getFileFromId(this.tempCacheFolder, id);
        if (!tmpFile.exists()) {
            throw new FileTransferException(String.valueOf(Messages.FileTransferCacheManager_MoveToCacheFailed_FileMissing) + id.getIdentifier());
        }
        if (cacheFile.exists() && overwrite) {
            cacheFile.delete();
        }
        if (cacheFile.exists()) {
            throw new FileTransferException(String.valueOf(Messages.FileTransferCacheManager_MoveToCacheFailed_Exists) + id.getIdentifier());
        }
        cacheFile.getParentFile().mkdirs();
        if (!tmpFile.renameTo(cacheFile)) {
            throw new FileTransferException(Messages.FileTransferCacheManager_MoveToCacheFailed_MoveFailed);
        }
        return cacheFile;
    }

    private File getFileFromId(File folder, FileIdentifier id) {
        return new File(folder, id.getIdentifier());
    }

    private void mkdirs() {
        this.cacheFolder.mkdirs();
        this.tempCacheFolder.mkdirs();
    }

    public boolean removeCachedFile(FileIdentifier fileIdentifier) {
        File toRemove = this.getFileFromId(this.cacheFolder, fileIdentifier);
        if (toRemove.exists()) {
            return toRemove.delete();
        }
        return false;
    }
}

