/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.views.MessageLine;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementListSelectionDialog
extends TrayDialog {
    public static final long serialVersionUID = 1L;
    private FilteredList fFilteredList;
    private MessageLine fStatusLine;
    private IStatus fLastStatus;
    private Image fImage;
    private ILabelProvider fRenderer;
    private boolean fIgnoreCase = true;
    private boolean fIsMultipleSelection;
    private boolean fMatchEmptyString = true;
    private boolean fAllowDuplicates = true;
    private Label fMessage;
    private Text fFilterText;
    private ISelectionStatusValidator fValidator;
    private String fFilter;
    private String fEmptyListMessage = "";
    private String fEmptySelectionMessage = "";
    private int fWidth = 60;
    private int fHeight = 18;
    private boolean fStatusLineAboveButtons;
    private Object[] fSelection = new Object[0];
    private Object[] result;
    private List<Object> initialSelections = new ArrayList<Object>();
    private String title;
    private String message = "";
    private int dialogBoundsStrategy = 3;
    private IDialogSettings dialogBoundsSettings;
    private Object[] fElements;

    protected ElementListSelectionDialog(Shell shell) {
        super(shell);
    }

    public void setStatusLineAboveButtons(boolean aboveButtons) {
        this.fStatusLineAboveButtons = aboveButtons;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
            if (this.fImage != null) {
                shell.setImage(this.fImage);
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Ok", true);
        this.createButton(parent, 1, "Cancel", false);
    }

    protected Control createButtonBar(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        if (!this.fStatusLineAboveButtons) {
            layout.numColumns = 2;
        }
        layout.marginHeight = 0;
        layout.marginLeft = this.convertHorizontalDLUsToPixels(7);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        if (!this.fStatusLineAboveButtons && this.isHelpAvailable()) {
            this.createHelpControl(composite);
        }
        this.fStatusLine = new MessageLine(composite);
        this.fStatusLine.setAlignment(16384);
        GridData statusData = new GridData(768);
        this.fStatusLine.setErrorStatus(null);
        this.fStatusLine.setFont(font);
        if (this.fStatusLineAboveButtons && this.isHelpAvailable()) {
            statusData.horizontalSpan = 2;
            this.createHelpControl(composite);
        }
        this.fStatusLine.setLayoutData(statusData);
        boolean helpAvailable = this.isHelpAvailable();
        this.setHelpAvailable(false);
        super.createButtonBar(composite);
        this.setHelpAvailable(helpAvailable);
        return composite;
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 0);
        if (this.message != null) {
            label.setText(this.message);
        }
        label.setFont(composite.getFont());
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        label.setLayoutData((Object)data);
        this.fMessage = label;
        return label;
    }

    protected List<Object> getInitialElementSelections() {
        return this.initialSelections;
    }

    protected String getMessage() {
        return this.message;
    }

    public Button getOkButton() {
        return this.getButton(0);
    }

    public Object[] getResult() {
        return this.result;
    }

    public void setInitialSelections(Object[] selectedElements) {
        this.initialSelections = new ArrayList<Object>(selectedElements.length);
        int i = 0;
        while (i < selectedElements.length) {
            this.initialSelections.add(selectedElements[i]);
            ++i;
        }
    }

    public void setInitialElementSelections(List<Object> selectedElements) {
        this.initialSelections = selectedElements;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    protected void setResult(List<Object> newResult) {
        if (newResult == null) {
            this.result = null;
        } else {
            this.result = new Object[newResult.size()];
            newResult.toArray(this.result);
        }
    }

    protected void setSelectionResult(Object[] newResult) {
        this.result = newResult;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDialogBoundsSettings(IDialogSettings settings, int strategy) {
        this.dialogBoundsStrategy = strategy;
        this.dialogBoundsSettings = settings;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.dialogBoundsSettings;
    }

    protected int getDialogBoundsStrategy() {
        return this.dialogBoundsStrategy;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public Object getFirstResult() {
        Object[] result = this.getResult();
        if (result == null || result.length == 0) {
            return null;
        }
        return result[0];
    }

    protected void setResult(int position, Object element) {
        Object[] result = this.getResult();
        result[position] = element;
        this.setResult(Arrays.asList(result));
    }

    protected void updateStatus(IStatus status) {
        this.fLastStatus = status;
        if (this.fStatusLine != null && !this.fStatusLine.isDisposed()) {
            this.updateButtonsEnableState(status);
            this.fStatusLine.setErrorStatus(status);
        }
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button okButton = this.getOkButton();
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(!status.matches(4));
        }
    }

    protected void okPressed() {
        this.computeResult();
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }

    protected void handleDefaultSelected() {
        if (this.validateCurrentSelection()) {
            this.buttonPressed(0);
        }
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.fIgnoreCase = ignoreCase;
    }

    public boolean isCaseIgnored() {
        return this.fIgnoreCase;
    }

    public void setMatchEmptyString(boolean matchEmptyString) {
        this.fMatchEmptyString = matchEmptyString;
    }

    public void setMultipleSelection(boolean isMultipleSelectionAllowed) {
        this.fIsMultipleSelection = isMultipleSelectionAllowed;
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this.fAllowDuplicates = allowDuplicates;
    }

    public void setSize(int width, int height) {
        this.fWidth = width;
        this.fHeight = height;
    }

    public void setEmptyListMessage(String message) {
        this.fEmptyListMessage = message;
    }

    public void setEmptySelectionMessage(String message) {
        this.fEmptySelectionMessage = message;
    }

    public void setValidator(ISelectionStatusValidator validator) {
        this.fValidator = validator;
    }

    protected void setListElements(Object[] elements) {
        Assert.isNotNull((Object)this.fFilteredList);
        this.fFilteredList.setElements(elements);
    }

    public void setFilter(String filter) {
        if (this.fFilterText == null) {
            this.fFilter = filter;
        } else {
            this.fFilterText.setText(filter);
        }
    }

    public String getFilter() {
        if (this.fFilteredList == null) {
            return this.fFilter;
        }
        return this.fFilteredList.getFilter();
    }

    protected int[] getSelectionIndices() {
        Assert.isNotNull((Object)this.fFilteredList);
        return this.fFilteredList.getSelectionIndices();
    }

    protected int getSelectionIndex() {
        Assert.isNotNull((Object)this.fFilteredList);
        return this.fFilteredList.getSelectionIndex();
    }

    protected void setSelection(Object[] selection) {
        Assert.isNotNull((Object)this.fFilteredList);
        this.fFilteredList.setSelection(selection);
    }

    protected Object[] getSelectedElements() {
        Assert.isNotNull((Object)this.fFilteredList);
        return this.fFilteredList.getSelection();
    }

    public Object[] getFoldedElements(int index) {
        Assert.isNotNull((Object)this.fFilteredList);
        return this.fFilteredList.getFoldedElements(index);
    }

    protected void handleSelectionChanged() {
        this.validateCurrentSelection();
    }

    protected boolean validateCurrentSelection() {
        Assert.isNotNull((Object)this.fFilteredList);
        Object[] elements = this.getSelectedElements();
        Object status = elements.length > 0 ? (this.fValidator != null ? this.fValidator.validate(elements) : new Status(0, "org.eclipse.ui", 0, "", null)) : (this.fFilteredList.isEmpty() ? new Status(4, "org.eclipse.ui", 4, this.fEmptyListMessage, null) : new Status(4, "org.eclipse.ui", 4, this.fEmptySelectionMessage, null));
        this.updateStatus((IStatus)status);
        return status.isOK();
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected FilteredList createFilteredList(Composite parent) {
        int flags = 0xB00 | (this.fIsMultipleSelection ? 2 : 4);
        FilteredList list = new FilteredList(parent, flags, this.fRenderer, this.fIgnoreCase, this.fAllowDuplicates, this.fMatchEmptyString);
        GridData data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        data.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        list.setLayoutData((Object)data);
        list.setFont(parent.getFont());
        list.setFilter(this.fFilter == null ? "" : this.fFilter);
        list.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ElementListSelectionDialog.this.handleDefaultSelected();
            }

            public void widgetSelected(SelectionEvent e) {
                ElementListSelectionDialog.this.handleWidgetSelected();
            }
        });
        this.fFilteredList = list;
        return list;
    }

    private void handleWidgetSelected() {
        Object[] newSelection = this.fFilteredList.getSelection();
        if (newSelection.length != this.fSelection.length) {
            this.fSelection = newSelection;
            this.handleSelectionChanged();
        } else {
            int i = 0;
            while (i != newSelection.length) {
                if (!newSelection[i].equals(this.fSelection[i])) {
                    this.fSelection = newSelection;
                    this.handleSelectionChanged();
                    break;
                }
                ++i;
            }
        }
    }

    private Text createFilterText(Composite parent) {
        Text text = new Text(parent, 2048);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        text.setLayoutData((Object)data);
        text.setFont(parent.getFont());
        text.setText(this.fFilter == null ? "" : this.fFilter);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                ElementListSelectionDialog.this.fFilteredList.setFilter(ElementListSelectionDialog.this.fFilterText.getText());
            }
        };
        text.addListener(24, listener);
        this.fFilterText = text;
        return text;
    }

    public int open() {
        super.open();
        return this.getReturnCode();
    }

    private void accessSuperCreate() {
        super.create();
    }

    public void create() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                ElementListSelectionDialog.this.accessSuperCreate();
                Assert.isNotNull((Object)ElementListSelectionDialog.this.fFilteredList);
                if (ElementListSelectionDialog.this.fFilteredList.isEmpty()) {
                    ElementListSelectionDialog.this.handleEmptyList();
                } else {
                    ElementListSelectionDialog.this.validateCurrentSelection();
                    ElementListSelectionDialog.this.fFilterText.selectAll();
                    ElementListSelectionDialog.this.fFilterText.setFocus();
                }
            }
        });
        if (this.fLastStatus != null) {
            this.updateStatus(this.fLastStatus);
        }
    }

    protected void handleEmptyList() {
        this.fMessage.setEnabled(false);
        this.fFilterText.setEnabled(false);
        this.fFilteredList.setEnabled(false);
        this.updateOkState();
    }

    protected void updateOkState() {
        Button okButton = this.getOkButton();
        if (okButton != null) {
            okButton.setEnabled(this.getSelectedElements().length != 0);
        }
    }

    protected ISelectionStatusValidator getValidator() {
        return this.fValidator;
    }

    public ElementListSelectionDialog(Shell parent, ILabelProvider renderer) {
        super(parent);
        this.fRenderer = renderer;
    }

    public void setElements(Object[] elements) {
        this.fElements = elements;
    }

    protected void computeResult() {
        this.setResult(Arrays.asList(this.getSelectedElements()));
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createMessageArea(contents);
        this.createFilterText(contents);
        this.createFilteredList(contents);
        this.setListElements(this.fElements);
        this.setSelection(this.getInitialElementSelections().toArray());
        return contents;
    }

    public FilteredList getFilteredList() {
        return this.fFilteredList;
    }
}

