/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.model.versioning.impl;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESChangePackageImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionProperty;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningPackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.events.Event;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.ChangePackageContainer;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util.ChangePackageUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util.OperationsCanonizer;
import org.eclipse.emf.emfstore.server.ESCloseableIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangePackageImpl
extends EObjectImpl
implements ChangePackage {
    private ESChangePackageImpl apiImpl;
    protected LogMessage logMessage;
    protected EList<AbstractOperation> operations;
    protected EList<Event> events;
    protected EList<VersionProperty> versionProperties;

    protected ChangePackageImpl() {
    }

    protected EClass eStaticClass() {
        return VersioningPackage.Literals.CHANGE_PACKAGE;
    }

    @Override
    public EList<AbstractOperation> getOperations() {
        if (this.operations == null) {
            this.operations = new EObjectContainmentEList.Resolving<AbstractOperation>(AbstractOperation.class, (InternalEObject)this, 1){

                protected boolean isUnique() {
                    return false;
                }
            };
        }
        return this.operations;
    }

    @Override
    public EList<Event> getEvents() {
        if (this.events == null) {
            this.events = new EObjectContainmentEList.Resolving(Event.class, (InternalEObject)this, 2);
        }
        return this.events;
    }

    @Override
    public LogMessage getLogMessage() {
        if (this.logMessage != null && this.logMessage.eIsProxy()) {
            InternalEObject oldLogMessage = (InternalEObject)this.logMessage;
            this.logMessage = (LogMessage)this.eResolveProxy(oldLogMessage);
            if (this.logMessage != oldLogMessage) {
                InternalEObject newLogMessage = (InternalEObject)this.logMessage;
                NotificationChain msgs = oldLogMessage.eInverseRemove((InternalEObject)this, -1, null, null);
                if (newLogMessage.eInternalContainer() == null) {
                    msgs = newLogMessage.eInverseAdd((InternalEObject)this, -1, null, msgs);
                }
                if (msgs != null) {
                    msgs.dispatch();
                }
                if (this.eNotificationRequired()) {
                    this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 0, (Object)oldLogMessage, (Object)this.logMessage));
                }
            }
        }
        return this.logMessage;
    }

    public LogMessage basicGetLogMessage() {
        return this.logMessage;
    }

    public NotificationChain basicSetLogMessage(LogMessage newLogMessage, NotificationChain msgs) {
        LogMessage oldLogMessage = this.logMessage;
        this.logMessage = newLogMessage;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldLogMessage, (Object)newLogMessage);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setLogMessage(LogMessage newLogMessage) {
        if (newLogMessage != this.logMessage) {
            NotificationChain msgs = null;
            if (this.logMessage != null) {
                msgs = ((InternalEObject)this.logMessage).eInverseRemove((InternalEObject)this, -1, null, msgs);
            }
            if (newLogMessage != null) {
                msgs = ((InternalEObject)newLogMessage).eInverseAdd((InternalEObject)this, -1, null, msgs);
            }
            if ((msgs = this.basicSetLogMessage(newLogMessage, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)newLogMessage, (Object)newLogMessage));
        }
    }

    @Override
    public EList<VersionProperty> getVersionProperties() {
        if (this.versionProperties == null) {
            this.versionProperties = new EObjectContainmentEList.Resolving(VersionProperty.class, (InternalEObject)this, 3);
        }
        return this.versionProperties;
    }

    @Override
    public ChangePackage reverse() {
        ChangePackage changePackage = VersioningFactory.eINSTANCE.createChangePackage();
        EList<AbstractOperation> copiedSubOperations = changePackage.getOperations();
        for (AbstractOperation abstractOperation : this.getOperations()) {
            copiedSubOperations.add(0, (Object)abstractOperation.reverse());
        }
        return changePackage;
    }

    @Override
    public void apply(Project project) {
        this.apply(project, false);
    }

    @Override
    public void apply(Project project, boolean force) {
        for (AbstractOperation operation : this.getOperations()) {
            try {
                operation.apply((IdEObjectCollection)project);
            }
            catch (IllegalStateException e) {
                if (force) continue;
                throw e;
            }
        }
    }

    @Override
    public void cannonize() {
        OperationsCanonizer.canonize(this.getOperations());
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return this.basicSetLogMessage(null, msgs);
            }
            case 1: {
                return ((InternalEList)this.getOperations()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getEvents()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getVersionProperties()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                if (resolve) {
                    return this.getLogMessage();
                }
                return this.basicGetLogMessage();
            }
            case 1: {
                return this.getOperations();
            }
            case 2: {
                return this.getEvents();
            }
            case 3: {
                return this.getVersionProperties();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setLogMessage((LogMessage)newValue);
                return;
            }
            case 1: {
                this.getOperations().clear();
                this.getOperations().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getEvents().clear();
                this.getEvents().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getVersionProperties().clear();
                this.getVersionProperties().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setLogMessage(null);
                return;
            }
            case 1: {
                this.getOperations().clear();
                return;
            }
            case 2: {
                this.getEvents().clear();
                return;
            }
            case 3: {
                this.getVersionProperties().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.logMessage != null;
            }
            case 1: {
                return this.operations != null && !this.operations.isEmpty();
            }
            case 2: {
                return this.events != null && !this.events.isEmpty();
            }
            case 3: {
                return this.versionProperties != null && !this.versionProperties.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public List<AbstractOperation> getCopyOfOperations() {
        ArrayList<AbstractOperation> copiedOperations = new ArrayList<AbstractOperation>();
        for (AbstractOperation operation : this.getOperations()) {
            copiedOperations.add((AbstractOperation)ModelUtil.clone((EObject)operation));
        }
        return copiedOperations;
    }

    @Override
    public List<AbstractOperation> getLeafOperations() {
        ArrayList<AbstractOperation> leafOperations = new ArrayList<AbstractOperation>();
        for (AbstractOperation operation : this.getOperations()) {
            leafOperations.addAll(operation.getLeafOperations());
        }
        return leafOperations;
    }

    @Override
    public Set<ModelElementId> getAllInvolvedModelElements() {
        LinkedHashSet<ModelElementId> result = new LinkedHashSet<ModelElementId>();
        for (AbstractOperation operation : this.getOperations()) {
            result.addAll(operation.getAllInvolvedModelElements());
        }
        return result;
    }

    @Override
    public List<AbstractOperation> getTouchingOperations(ModelElementId modelElementId) {
        ArrayList<AbstractOperation> result = new ArrayList<AbstractOperation>();
        for (AbstractOperation operation : this.getOperations()) {
            if (!operation.getAllInvolvedModelElements().contains(modelElementId)) continue;
            result.add(operation);
        }
        return result;
    }

    @Override
    public int getSize() {
        return ChangePackageUtil.countLeafOperations(this.getOperations());
    }

    @Override
    public ESChangePackageImpl toAPI() {
        if (this.apiImpl == null) {
            this.apiImpl = this.createAPI();
        }
        return this.apiImpl;
    }

    public ESChangePackageImpl createAPI() {
        return new ESChangePackageImpl(this);
    }

    @Override
    public void add(AbstractOperation operation) {
        this.getOperations().add((Object)operation);
    }

    @Override
    public void addAll(List<AbstractOperation> operations) {
        this.getOperations().addAll(operations);
    }

    @Override
    public int size() {
        return this.getOperations().size();
    }

    @Override
    public ESCloseableIterable<AbstractOperation> operations() {
        return new ESCloseableIterable<AbstractOperation>(){

            @Override
            public void close() {
            }

            @Override
            public Iterable<AbstractOperation> iterable() {
                return ChangePackageImpl.this.getOperations();
            }
        };
    }

    @Override
    public ESCloseableIterable<AbstractOperation> reversedOperations() {
        return new ESCloseableIterable<AbstractOperation>(){

            @Override
            public void close() {
            }

            @Override
            public Iterable<AbstractOperation> iterable() {
                return Lists.reverse(ChangePackageImpl.this.getOperations());
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.getOperations().isEmpty();
    }

    @Override
    public List<AbstractOperation> removeAtEnd(int n) {
        ArrayList<AbstractOperation> removedOperations = new ArrayList<AbstractOperation>();
        int i = 0;
        while (i < n) {
            int size = this.getOperations().size();
            removedOperations.add((AbstractOperation)this.getOperations().get(size - 1));
            this.getOperations().remove(size - 1);
            ++i;
        }
        return removedOperations;
    }

    @Override
    public void clear() {
        this.getOperations().clear();
    }

    @Override
    public void attachToProjectSpace(ChangePackageContainer changePackageHolder) {
        changePackageHolder.setChangePackage(this);
    }

    @Override
    public int leafSize() {
        return ChangePackageUtil.countLeafOperations(Collections.singletonList(this));
    }

    @Override
    public void save() throws IOException {
        Resource eResource = this.eResource();
        if (eResource != null) {
            eResource.save(ModelUtil.getResourceSaveOptions());
        }
    }

    @Override
    public AbstractOperation get(int index) {
        return (AbstractOperation)this.getOperations().get(index);
    }
}

