/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.rowset;

import java.util.NoSuchElementException;
import org.apache.jena.riot.rowset.RowSetWrapper;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.RowSet;

public class RowSetOnClose
extends RowSetWrapper {
    private final Runnable onClose;
    private boolean isClosed = false;

    public RowSetOnClose(RowSet rs, Runnable onClose) {
        super(rs);
        this.onClose = onClose;
    }

    private void onClose() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.onClose.run();
    }

    @Override
    public boolean hasNext() {
        boolean b = super.hasNext();
        if (!b) {
            this.onClose();
        }
        return b;
    }

    @Override
    public Binding next() {
        try {
            return super.next();
        }
        catch (NoSuchElementException ex) {
            this.onClose();
            throw ex;
        }
    }

    @Override
    public void close() {
        super.close();
        this.onClose();
    }
}

