/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased;

import java.util.ArrayDeque;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.AutomatonHelper;
import org.eclipse.escet.cif.eventbased.automata.Edge;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.eventbased.automata.Location;
import org.eclipse.escet.cif.eventbased.automata.origin.LocationSetOrigin;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;

public class NfaToDfa {
    private NfaToDfa() {
    }

    public static Automaton toDFA(Automaton aut, Set<Event> preservedEvents) {
        Map locMap = Maps.map();
        ArrayDeque<Set<Location>> notDone = new ArrayDeque<Set<Location>>(1000);
        Automaton result = new Automaton(preservedEvents);
        result.kind = aut.kind;
        if (aut.initial == null) {
            return result;
        }
        Set skipEvents = Sets.copy(aut.alphabet);
        skipEvents.removeAll(preservedEvents);
        Set locSet = AutomatonHelper.expandLocations(Sets.set((Object)aut.initial), null, skipEvents);
        LocationSetOrigin org = new LocationSetOrigin(locSet);
        Location loc = new Location(result, org);
        loc.marked = AutomatonHelper.hasMarkedLocation(locSet);
        locMap.put(locSet, loc);
        notDone.add(locSet);
        result.setInitial(loc);
        while (!notDone.isEmpty()) {
            locSet = (Set)notDone.poll();
            loc = (Location)locMap.get(locSet);
            for (Event evt : preservedEvents) {
                Set<Location> destSet = AutomatonHelper.expandLocations(locSet, evt, skipEvents);
                if (destSet.isEmpty()) continue;
                Location dest = (Location)locMap.get(destSet);
                if (dest == null) {
                    LocationSetOrigin destOrg = new LocationSetOrigin(destSet);
                    dest = new Location(result, destOrg);
                    dest.marked = AutomatonHelper.hasMarkedLocation(destSet);
                    locMap.put(destSet, dest);
                    notDone.add(destSet);
                }
                Edge.addEdge(evt, loc, dest);
            }
        }
        return result;
    }
}

