/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.postprocessing;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.etrice.core.common.postprocessing.PostprocessingHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.GeneratedMetamodel;

public class DocuPostprocessor {
    public void process(GeneratedMetamodel metamodel) {
        EPackage pckg = metamodel.getEPackage();
        EClass cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"RoomElement");
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("The marker interface for all classes belonging to the ROOM model.");
        stringConcatenation.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"RoomModel");
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("The root object for the ROOM model. It gives access to {@link Import imports} and");
        stringConcatenation2.newLine();
        stringConcatenation2.append("the {@link SubSystemClass sub system},");
        stringConcatenation2.newLine();
        stringConcatenation2.append("{@link ActorClass actor}, {@link ProtocolClass protocol} and");
        stringConcatenation2.newLine();
        stringConcatenation2.append("{@link DataClass data} classes defined.");
        stringConcatenation2.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation2.toString());
        EAttribute eAttribute = PostprocessingHelpers.getAttribute((EClass)cls, (String)"name");
        StringConcatenation stringConcatenation3 = new StringConcatenation();
        stringConcatenation3.append("The model name is a dot separated fully qualified name and is");
        stringConcatenation3.newLine();
        stringConcatenation3.append("used to provide a name space. The generators may use that also");
        stringConcatenation3.newLine();
        stringConcatenation3.append("to place the generated code into separate directories.");
        stringConcatenation3.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute, (String)stringConcatenation3.toString());
        EReference eReference = PostprocessingHelpers.getReference((EClass)cls, (String)"docu");
        StringConcatenation stringConcatenation4 = new StringConcatenation();
        stringConcatenation4.append("This is an optional documentation.");
        stringConcatenation4.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference, (String)stringConcatenation4.toString());
        EReference eReference2 = PostprocessingHelpers.getReference((EClass)cls, (String)"imports");
        StringConcatenation stringConcatenation5 = new StringConcatenation();
        stringConcatenation5.append("This is a list of all imported models.");
        stringConcatenation5.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference2, (String)stringConcatenation5.toString());
        EReference eReference3 = PostprocessingHelpers.getReference((EClass)cls, (String)"roomClasses");
        StringConcatenation stringConcatenation6 = new StringConcatenation();
        stringConcatenation6.append("This is a list of all room classes defined by this model.");
        stringConcatenation6.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference3, (String)stringConcatenation6.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"RoomClass");
        StringConcatenation stringConcatenation7 = new StringConcatenation();
        stringConcatenation7.append("This class is the super class of all classes");
        stringConcatenation7.newLine();
        stringConcatenation7.append("of the ROOM class model:");
        stringConcatenation7.newLine();
        stringConcatenation7.append("<ul>");
        stringConcatenation7.newLine();
        stringConcatenation7.append("  ");
        stringConcatenation7.append("<li>{@link DataType}</li>");
        stringConcatenation7.newLine();
        stringConcatenation7.append("  ");
        stringConcatenation7.append("<li>{@link ProtocolClass}</li>");
        stringConcatenation7.newLine();
        stringConcatenation7.append("  ");
        stringConcatenation7.append("<li>{@link StructureClass}</li>");
        stringConcatenation7.newLine();
        stringConcatenation7.append("</ul>");
        stringConcatenation7.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation7.toString());
        EReference eReference4 = PostprocessingHelpers.getReference((EClass)cls, (String)"docu");
        StringConcatenation stringConcatenation8 = new StringConcatenation();
        stringConcatenation8.append("This is an optional documentation.");
        stringConcatenation8.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference4, (String)stringConcatenation8.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"StructureClass");
        StringConcatenation stringConcatenation9 = new StringConcatenation();
        stringConcatenation9.append("This class is the super class of the structural classes");
        stringConcatenation9.newLine();
        stringConcatenation9.append("<ul>");
        stringConcatenation9.newLine();
        stringConcatenation9.append("  ");
        stringConcatenation9.append("<li>{@link ActorContainerClass}</li>");
        stringConcatenation9.newLine();
        stringConcatenation9.append("  ");
        stringConcatenation9.append("<li>{@link LogicalSystem}</li>");
        stringConcatenation9.newLine();
        stringConcatenation9.append("</ul>");
        stringConcatenation9.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation9.toString());
        EReference eReference5 = PostprocessingHelpers.getReference((EClass)cls, (String)"annotations");
        StringConcatenation stringConcatenation10 = new StringConcatenation();
        stringConcatenation10.append("This is a list of structure class annotations.");
        stringConcatenation10.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference5, (String)stringConcatenation10.toString());
        EReference eReference6 = PostprocessingHelpers.getReference((EClass)cls, (String)"bindings");
        StringConcatenation stringConcatenation11 = new StringConcatenation();
        stringConcatenation11.append("This is a list of structure class bindings.");
        stringConcatenation11.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference6, (String)stringConcatenation11.toString());
        EReference eReference7 = PostprocessingHelpers.getReference((EClass)cls, (String)"connections");
        StringConcatenation stringConcatenation12 = new StringConcatenation();
        stringConcatenation12.append("This is a list of structure class connections.");
        stringConcatenation12.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference7, (String)stringConcatenation12.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"ActorContainerClass");
        StringConcatenation stringConcatenation13 = new StringConcatenation();
        stringConcatenation13.append("This class is the super class of the structural classes");
        stringConcatenation13.newLine();
        stringConcatenation13.append("<ul>");
        stringConcatenation13.newLine();
        stringConcatenation13.append("  ");
        stringConcatenation13.append("<li>{@link ActorClass}</li>");
        stringConcatenation13.newLine();
        stringConcatenation13.append("  ");
        stringConcatenation13.append("<li>{@link SubSystemClass}</li>");
        stringConcatenation13.newLine();
        stringConcatenation13.append("</ul>");
        stringConcatenation13.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation13.toString());
        EReference eReference8 = PostprocessingHelpers.getReference((EClass)cls, (String)"serviceProvisionPoints");
        StringConcatenation stringConcatenation14 = new StringConcatenation();
        stringConcatenation14.append("This is a list of all interface SPPs.");
        stringConcatenation14.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference8, (String)stringConcatenation14.toString());
        EReference eReference9 = PostprocessingHelpers.getReference((EClass)cls, (String)"actorRefs");
        StringConcatenation stringConcatenation15 = new StringConcatenation();
        stringConcatenation15.append("This is a list of all actor refs.");
        stringConcatenation15.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference9, (String)stringConcatenation15.toString());
        EReference eReference10 = PostprocessingHelpers.getReference((EClass)cls, (String)"userCode1");
        StringConcatenation stringConcatenation16 = new StringConcatenation();
        stringConcatenation16.append("The user code is treated in a generator dependent way.");
        stringConcatenation16.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference10, (String)stringConcatenation16.toString());
        EReference eReference11 = PostprocessingHelpers.getReference((EClass)cls, (String)"userCode2");
        StringConcatenation stringConcatenation17 = new StringConcatenation();
        stringConcatenation17.append("The user code is treated in a generator dependent way.");
        stringConcatenation17.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference11, (String)stringConcatenation17.toString());
        EReference eReference12 = PostprocessingHelpers.getReference((EClass)cls, (String)"userCode3");
        StringConcatenation stringConcatenation18 = new StringConcatenation();
        stringConcatenation18.append("The user code is treated in a generator dependent way.");
        stringConcatenation18.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference12, (String)stringConcatenation18.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"VarDecl");
        StringConcatenation stringConcatenation19 = new StringConcatenation();
        stringConcatenation19.append("A variable declaration consists of a name and a type.");
        stringConcatenation19.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation19.toString());
        EAttribute eAttribute2 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"name");
        StringConcatenation stringConcatenation20 = new StringConcatenation();
        stringConcatenation20.append("By this name the variable is referred to in the model.");
        stringConcatenation20.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute2, (String)stringConcatenation20.toString());
        EReference eReference13 = PostprocessingHelpers.getReference((EClass)cls, (String)"refType");
        StringConcatenation stringConcatenation21 = new StringConcatenation();
        stringConcatenation21.append("This is the data type of the variable.");
        stringConcatenation21.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference13, (String)stringConcatenation21.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"RefableType");
        StringConcatenation stringConcatenation22 = new StringConcatenation();
        stringConcatenation22.append("This is a type with an optional reference attribute.");
        stringConcatenation22.newLine();
        stringConcatenation22.append("If 'ref' is {@code true} then by reference semantic is chosen.");
        stringConcatenation22.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation22.toString());
        EReference eReference14 = PostprocessingHelpers.getReference((EClass)cls, (String)"type");
        StringConcatenation stringConcatenation23 = new StringConcatenation();
        stringConcatenation23.append("This is the data type.");
        stringConcatenation23.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference14, (String)stringConcatenation23.toString());
        EAttribute eAttribute3 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"ref");
        StringConcatenation stringConcatenation24 = new StringConcatenation();
        stringConcatenation24.append("If {@code true} then by reference semantics is chosen, by value semantics else.");
        stringConcatenation24.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute3, (String)stringConcatenation24.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"DataType");
        StringConcatenation stringConcatenation25 = new StringConcatenation();
        stringConcatenation25.append("The super class of");
        stringConcatenation25.newLine();
        stringConcatenation25.append("<ul>");
        stringConcatenation25.newLine();
        stringConcatenation25.append("  ");
        stringConcatenation25.append("<li>{@link PrimitiveType}</li>");
        stringConcatenation25.newLine();
        stringConcatenation25.append("  ");
        stringConcatenation25.append("<li>{@link EnumerationType}</li>");
        stringConcatenation25.newLine();
        stringConcatenation25.append("  ");
        stringConcatenation25.append("<li>{@link ComplexType}</li>");
        stringConcatenation25.newLine();
        stringConcatenation25.append("</ul>");
        stringConcatenation25.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation25.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"EnumerationType");
        StringConcatenation stringConcatenation26 = new StringConcatenation();
        stringConcatenation26.append("A sub type of {@link DataType} for enumerations.");
        stringConcatenation26.newLine();
        stringConcatenation26.append("The EnumerationType can be associated with a {@link PrimitiveType} as value type for");
        stringConcatenation26.newLine();
        stringConcatenation26.append("the {@link EnumLiteral}s. It has to contain at least one literal.");
        stringConcatenation26.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation26.toString());
        EReference eReference15 = PostprocessingHelpers.getReference((EClass)cls, (String)"primitiveType");
        StringConcatenation stringConcatenation27 = new StringConcatenation();
        stringConcatenation27.append("The value type of the literals.");
        stringConcatenation27.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference15, (String)stringConcatenation27.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"EnumLiteral");
        StringConcatenation stringConcatenation28 = new StringConcatenation();
        stringConcatenation28.append("A literal value of the enumeration.");
        stringConcatenation28.newLine();
        stringConcatenation28.append("It can have a value associated.");
        stringConcatenation28.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation28.toString());
        EAttribute eAttribute4 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"name");
        StringConcatenation stringConcatenation29 = new StringConcatenation();
        stringConcatenation29.append("The name of the literal.");
        stringConcatenation29.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute4, (String)stringConcatenation29.toString());
        EReference eReference16 = PostprocessingHelpers.getReference((EClass)cls, (String)"literal");
        StringConcatenation stringConcatenation30 = new StringConcatenation();
        stringConcatenation30.append("The value of the literal. It is associated with a target type which defaults to");
        stringConcatenation30.newLine();
        stringConcatenation30.append("{@code int} and can be set explicitly using the {@link EnumerationType#getPrimitiveType()}");
        stringConcatenation30.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference16, (String)stringConcatenation30.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"ComplexType");
        StringConcatenation stringConcatenation31 = new StringConcatenation();
        stringConcatenation31.append("The super class of");
        stringConcatenation31.newLine();
        stringConcatenation31.append("<ul>");
        stringConcatenation31.newLine();
        stringConcatenation31.append("  ");
        stringConcatenation31.append("<li>{@link DataClass}</li>");
        stringConcatenation31.newLine();
        stringConcatenation31.append("  ");
        stringConcatenation31.append("<li>{@link ExternalType}</li>");
        stringConcatenation31.newLine();
        stringConcatenation31.append("</ul>");
        stringConcatenation31.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation31.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"PrimitiveType");
        StringConcatenation stringConcatenation32 = new StringConcatenation();
        stringConcatenation32.append("A primitive type describes a type like int, char, float");
        stringConcatenation32.newLine();
        stringConcatenation32.append("and can represent the type with a certain precision");
        stringConcatenation32.newLine();
        stringConcatenation32.append("in the target language");
        stringConcatenation32.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation32.toString());
        EAttribute eAttribute5 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"type");
        StringConcatenation stringConcatenation33 = new StringConcatenation();
        stringConcatenation33.append("This is one of the basic variable types.");
        stringConcatenation33.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute5, (String)stringConcatenation33.toString());
        EAttribute eAttribute6 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"targetName");
        StringConcatenation stringConcatenation34 = new StringConcatenation();
        stringConcatenation34.append("This is the type name in the target language.");
        stringConcatenation34.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute6, (String)stringConcatenation34.toString());
        EAttribute eAttribute7 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"castName");
        StringConcatenation stringConcatenation35 = new StringConcatenation();
        stringConcatenation35.append("This (optional) name is used for casts to this type.");
        stringConcatenation35.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute7, (String)stringConcatenation35.toString());
        EAttribute eAttribute8 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"defaultValueLiteral");
        StringConcatenation stringConcatenation36 = new StringConcatenation();
        stringConcatenation36.append("This is an optional default value literal.");
        stringConcatenation36.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute8, (String)stringConcatenation36.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"ExternalType");
        StringConcatenation stringConcatenation37 = new StringConcatenation();
        stringConcatenation37.append("An external type is not defined in the ROOM model");
        stringConcatenation37.newLine();
        stringConcatenation37.append("but only referenced. It can not be instantiated.");
        stringConcatenation37.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation37.toString());
        EAttribute eAttribute9 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"targetName");
        StringConcatenation stringConcatenation38 = new StringConcatenation();
        stringConcatenation38.append("This is the type name in the target language.");
        stringConcatenation38.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute9, (String)stringConcatenation38.toString());
        EAttribute eAttribute10 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"defaultValueLiteral");
        StringConcatenation stringConcatenation39 = new StringConcatenation();
        stringConcatenation39.append("This is an optional default value literal.");
        stringConcatenation39.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute10, (String)stringConcatenation39.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"DataClass");
        StringConcatenation stringConcatenation40 = new StringConcatenation();
        stringConcatenation40.append("Together with {@link ProtocolClass} and {@link ActorClass} one of");
        stringConcatenation40.newLine();
        stringConcatenation40.append("the main class types of the ROOM language.");
        stringConcatenation40.newLine();
        stringConcatenation40.newLine();
        stringConcatenation40.append("<p>");
        stringConcatenation40.newLine();
        stringConcatenation40.append("In ROOM this is the equivalent to a class in Java or C++.");
        stringConcatenation40.newLine();
        stringConcatenation40.append("A data class can be derived from a base class (single");
        stringConcatenation40.newLine();
        stringConcatenation40.append("inheritance), has {@link Attribute}s and {@link Operation}s.");
        stringConcatenation40.newLine();
        stringConcatenation40.append("</p>");
        stringConcatenation40.newLine();
        stringConcatenation40.newLine();
        stringConcatenation40.append("<p>");
        stringConcatenation40.newLine();
        stringConcatenation40.append("Additionally it can be annotated with generator specific");
        stringConcatenation40.newLine();
        stringConcatenation40.append("meaning and user ocde can be added in several places");
        stringConcatenation40.newLine();
        stringConcatenation40.append("(again generator specific).");
        stringConcatenation40.newLine();
        stringConcatenation40.append("</p>");
        stringConcatenation40.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation40.toString());
        EAttribute eAttribute11 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"name");
        StringConcatenation stringConcatenation41 = new StringConcatenation();
        stringConcatenation41.append("The name of the data class by which it is referred to in the model.");
        stringConcatenation41.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute11, (String)stringConcatenation41.toString());
        EReference eReference17 = PostprocessingHelpers.getReference((EClass)cls, (String)"base");
        StringConcatenation stringConcatenation42 = new StringConcatenation();
        stringConcatenation42.append("The base class from which all attributes and operations are inherited.");
        stringConcatenation42.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference17, (String)stringConcatenation42.toString());
        EReference eReference18 = PostprocessingHelpers.getReference((EClass)cls, (String)"attributes");
        StringConcatenation stringConcatenation43 = new StringConcatenation();
        stringConcatenation43.append("Attributes are the data members of the data class.");
        stringConcatenation43.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference18, (String)stringConcatenation43.toString());
        EReference eReference19 = PostprocessingHelpers.getReference((EClass)cls, (String)"operations");
        StringConcatenation stringConcatenation44 = new StringConcatenation();
        stringConcatenation44.append("Operations are the methods of the data class.");
        stringConcatenation44.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference19, (String)stringConcatenation44.toString());
        EReference eReference20 = PostprocessingHelpers.getReference((EClass)cls, (String)"annotations");
        StringConcatenation stringConcatenation45 = new StringConcatenation();
        stringConcatenation45.append("This is a list of data class annotations.");
        stringConcatenation45.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference20, (String)stringConcatenation45.toString());
        EReference eReference21 = PostprocessingHelpers.getReference((EClass)cls, (String)"userCode1");
        StringConcatenation stringConcatenation46 = new StringConcatenation();
        stringConcatenation46.append("The user code is treated in a generator dependent way.");
        stringConcatenation46.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference21, (String)stringConcatenation46.toString());
        EReference eReference22 = PostprocessingHelpers.getReference((EClass)cls, (String)"userCode2");
        StringConcatenation stringConcatenation47 = new StringConcatenation();
        stringConcatenation47.append("The user code is treated in a generator dependent way.");
        stringConcatenation47.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference22, (String)stringConcatenation47.toString());
        EReference eReference23 = PostprocessingHelpers.getReference((EClass)cls, (String)"userCode3");
        StringConcatenation stringConcatenation48 = new StringConcatenation();
        stringConcatenation48.append("The user code is treated in a generator dependent way.");
        stringConcatenation48.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference23, (String)stringConcatenation48.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"Attribute");
        StringConcatenation stringConcatenation49 = new StringConcatenation();
        stringConcatenation49.append("An attribute is a named member of a");
        stringConcatenation49.newLine();
        stringConcatenation49.append("<ul>");
        stringConcatenation49.newLine();
        stringConcatenation49.append("  ");
        stringConcatenation49.append("<li>{@link DataClass}</li>");
        stringConcatenation49.newLine();
        stringConcatenation49.append("  ");
        stringConcatenation49.append("<li>{@link ActorClass}</li>");
        stringConcatenation49.newLine();
        stringConcatenation49.append("  ");
        stringConcatenation49.append("<li>{@link PortClass}</li>");
        stringConcatenation49.newLine();
        stringConcatenation49.append("</ul>");
        stringConcatenation49.newLine();
        stringConcatenation49.append("<p>");
        stringConcatenation49.newLine();
        stringConcatenation49.append("It can be of scalar or array type and is of a {@link RefableType}.");
        stringConcatenation49.newLine();
        stringConcatenation49.append("It is possible to assign a default value literal.");
        stringConcatenation49.newLine();
        stringConcatenation49.append("</p>");
        stringConcatenation49.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation49.toString());
        EAttribute eAttribute12 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"name");
        StringConcatenation stringConcatenation50 = new StringConcatenation();
        stringConcatenation50.append("The name of the attribute by which it is referred to in the model.");
        stringConcatenation50.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute12, (String)stringConcatenation50.toString());
        EAttribute eAttribute13 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"size");
        StringConcatenation stringConcatenation51 = new StringConcatenation();
        stringConcatenation51.append("The default is scalar ({@code size=1}), values {@code >1} indicate an array.");
        stringConcatenation51.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute13, (String)stringConcatenation51.toString());
        EReference eReference24 = PostprocessingHelpers.getReference((EClass)cls, (String)"type");
        StringConcatenation stringConcatenation52 = new StringConcatenation();
        stringConcatenation52.append("This is the attribute's type.");
        stringConcatenation52.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference24, (String)stringConcatenation52.toString());
        EAttribute eAttribute14 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"defaultValueLiteral");
        StringConcatenation stringConcatenation53 = new StringConcatenation();
        stringConcatenation53.append("This is an optional default value literal.");
        stringConcatenation53.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute14, (String)stringConcatenation53.toString());
        EReference eReference25 = PostprocessingHelpers.getReference((EClass)cls, (String)"docu");
        StringConcatenation stringConcatenation54 = new StringConcatenation();
        stringConcatenation54.append("This is an optional documentation.");
        stringConcatenation54.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference25, (String)stringConcatenation54.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"Operation");
        StringConcatenation stringConcatenation55 = new StringConcatenation();
        stringConcatenation55.append("The super class of");
        stringConcatenation55.newLine();
        stringConcatenation55.append("<ul>");
        stringConcatenation55.newLine();
        stringConcatenation55.append("  ");
        stringConcatenation55.append("<li>{@link StandardOperation}</li>");
        stringConcatenation55.newLine();
        stringConcatenation55.append("  ");
        stringConcatenation55.append("<li>{@link PortOperation}</li>");
        stringConcatenation55.newLine();
        stringConcatenation55.append("</ul>");
        stringConcatenation55.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation55.toString());
        EAttribute eAttribute15 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"name");
        StringConcatenation stringConcatenation56 = new StringConcatenation();
        stringConcatenation56.append("The name of the operation by which it is referred to in the model.");
        stringConcatenation56.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute15, (String)stringConcatenation56.toString());
        EReference eReference26 = PostprocessingHelpers.getReference((EClass)cls, (String)"arguments");
        StringConcatenation stringConcatenation57 = new StringConcatenation();
        stringConcatenation57.append("This is a list of arguments for the operation.");
        stringConcatenation57.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference26, (String)stringConcatenation57.toString());
        EReference eReference27 = PostprocessingHelpers.getReference((EClass)cls, (String)"returnType");
        StringConcatenation stringConcatenation58 = new StringConcatenation();
        stringConcatenation58.append("This is an optional return type of the operation.");
        stringConcatenation58.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference27, (String)stringConcatenation58.toString());
        EReference eReference28 = PostprocessingHelpers.getReference((EClass)cls, (String)"docu");
        StringConcatenation stringConcatenation59 = new StringConcatenation();
        stringConcatenation59.append("This is an optional documentation.");
        stringConcatenation59.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference28, (String)stringConcatenation59.toString());
        EReference eReference29 = PostprocessingHelpers.getReference((EClass)cls, (String)"detailCode");
        StringConcatenation stringConcatenation60 = new StringConcatenation();
        stringConcatenation60.append("This is the operation body written in code generator target language.");
        stringConcatenation60.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference29, (String)stringConcatenation60.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"StandardOperation");
        StringConcatenation stringConcatenation61 = new StringConcatenation();
        stringConcatenation61.append("The standard form of an operation as used by");
        stringConcatenation61.newLine();
        stringConcatenation61.append("{@link ActorClass} and {@link DataClass}.");
        stringConcatenation61.newLine();
        stringConcatenation61.append("<p>");
        stringConcatenation61.newLine();
        stringConcatenation61.append("The operation has a list of {@link VarDecl} arguments, an");
        stringConcatenation61.newLine();
        stringConcatenation61.append("optional return {@link RefableType} and a body (specified");
        stringConcatenation61.newLine();
        stringConcatenation61.append("as {@link DetailCode}).");
        stringConcatenation61.newLine();
        stringConcatenation61.append("</p>");
        stringConcatenation61.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation61.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"PortOperation");
        StringConcatenation stringConcatenation62 = new StringConcatenation();
        stringConcatenation62.append("The port operation is very similar to the {@link StandardOperation}");
        stringConcatenation62.newLine();
        stringConcatenation62.append("and is used in the {@link PortClass}.");
        stringConcatenation62.newLine();
        stringConcatenation62.append("<p>");
        stringConcatenation62.newLine();
        stringConcatenation62.append("Optionally a {@link Message} can be specified which is sent");
        stringConcatenation62.newLine();
        stringConcatenation62.append("when the method is invoked. For this reason these operations");
        stringConcatenation62.newLine();
        stringConcatenation62.append("are also shown in the 'messages' dialog of the behavior editor.");
        stringConcatenation62.newLine();
        stringConcatenation62.append("</p>");
        stringConcatenation62.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation62.toString());
        EReference eReference30 = PostprocessingHelpers.getReference((EClass)cls, (String)"sendsMsg");
        StringConcatenation stringConcatenation63 = new StringConcatenation();
        stringConcatenation63.append("This optional reference to a message means that the operation sends a message.");
        stringConcatenation63.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference30, (String)stringConcatenation63.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"ClassStructor");
        StringConcatenation stringConcatenation64 = new StringConcatenation();
        stringConcatenation64.append("Represents either the constructor (ctor) or destructor (dtor) of a ROOM class.");
        stringConcatenation64.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation64.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"ProtocolClass");
        StringConcatenation stringConcatenation65 = new StringConcatenation();
        stringConcatenation65.append("Together with {@link ActorClass} and {@link DataClass} one of");
        stringConcatenation65.newLine();
        stringConcatenation65.append("the main class types of the ROOM language.");
        stringConcatenation65.newLine();
        stringConcatenation65.append("<p>");
        stringConcatenation65.newLine();
        stringConcatenation65.append("A protocol class specifies a directed {@link Port} interface");
        stringConcatenation65.newLine();
        stringConcatenation65.append("by two sets of {@link Message}s: incoming and outgoing.");
        stringConcatenation65.newLine();
        stringConcatenation65.append("</p>");
        stringConcatenation65.newLine();
        stringConcatenation65.append("<p>");
        stringConcatenation65.newLine();
        stringConcatenation65.append("A protocol class can derive from a base class (single inheritance).");
        stringConcatenation65.newLine();
        stringConcatenation65.append("In this case it must only extend <em>one</em> of the message sets:");
        stringConcatenation65.newLine();
        stringConcatenation65.append("incoming <em>or</em> outgoing.");
        stringConcatenation65.newLine();
        stringConcatenation65.append("</p>");
        stringConcatenation65.newLine();
        stringConcatenation65.append("<p>");
        stringConcatenation65.newLine();
        stringConcatenation65.append("Optionally {@link PortClass}es may be defined for regular and");
        stringConcatenation65.newLine();
        stringConcatenation65.append("conjugate {@link Port}s. These classes can be used to add specific");
        stringConcatenation65.newLine();
        stringConcatenation65.append("behavior e.g. by adding message handlers. This kind of felxibility");
        stringConcatenation65.newLine();
        stringConcatenation65.append("can be used in particular for the efficient implementation of");
        stringConcatenation65.newLine();
        stringConcatenation65.append("services (SAPs and SPPs).");
        stringConcatenation65.newLine();
        stringConcatenation65.append("</p>");
        stringConcatenation65.newLine();
        stringConcatenation65.append("<p>");
        stringConcatenation65.newLine();
        stringConcatenation65.append("Last not least a so called 'legal execution tree' can be specified");
        stringConcatenation65.newLine();
        stringConcatenation65.append("using {@link ProtocolSemantics}.");
        stringConcatenation65.newLine();
        stringConcatenation65.append("</p>");
        stringConcatenation65.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation65.toString());
        EAttribute eAttribute16 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"name");
        StringConcatenation stringConcatenation66 = new StringConcatenation();
        stringConcatenation66.append("The name of the protocol class by which it is referred to in the model.");
        stringConcatenation66.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute16, (String)stringConcatenation66.toString());
        EReference eReference31 = PostprocessingHelpers.getReference((EClass)cls, (String)"base");
        StringConcatenation stringConcatenation67 = new StringConcatenation();
        stringConcatenation67.append("The base class from which all messages are inherited.");
        stringConcatenation67.newLine();
        stringConcatenation67.append("The port classes and the semantics are not inherited.");
        stringConcatenation67.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference31, (String)stringConcatenation67.toString());
        EAttribute eAttribute17 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"commType");
        StringConcatenation stringConcatenation68 = new StringConcatenation();
        stringConcatenation68.append("This is the communication type of the protocol.");
        stringConcatenation68.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute17, (String)stringConcatenation68.toString());
        EReference eReference32 = PostprocessingHelpers.getReference((EClass)cls, (String)"userCode1");
        StringConcatenation stringConcatenation69 = new StringConcatenation();
        stringConcatenation69.append("The user code is treated in a generator dependent way.");
        stringConcatenation69.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference32, (String)stringConcatenation69.toString());
        EReference eReference33 = PostprocessingHelpers.getReference((EClass)cls, (String)"userCode2");
        StringConcatenation stringConcatenation70 = new StringConcatenation();
        stringConcatenation70.append("The user code is treated in a generator dependent way.");
        stringConcatenation70.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference33, (String)stringConcatenation70.toString());
        EReference eReference34 = PostprocessingHelpers.getReference((EClass)cls, (String)"userCode3");
        StringConcatenation stringConcatenation71 = new StringConcatenation();
        stringConcatenation71.append("The user code is treated in a generator dependent way.");
        stringConcatenation71.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference34, (String)stringConcatenation71.toString());
        EReference eReference35 = PostprocessingHelpers.getReference((EClass)cls, (String)"incomingMessages");
        StringConcatenation stringConcatenation72 = new StringConcatenation();
        stringConcatenation72.append("This is the set of incoming messages of this protocol.");
        stringConcatenation72.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference35, (String)stringConcatenation72.toString());
        EReference eReference36 = PostprocessingHelpers.getReference((EClass)cls, (String)"outgoingMessages");
        StringConcatenation stringConcatenation73 = new StringConcatenation();
        stringConcatenation73.append("This is the set of outgoing messages of this protocol.");
        stringConcatenation73.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference36, (String)stringConcatenation73.toString());
        EReference eReference37 = PostprocessingHelpers.getReference((EClass)cls, (String)"regular");
        StringConcatenation stringConcatenation74 = new StringConcatenation();
        stringConcatenation74.append("This is the optional regular port class specification.");
        stringConcatenation74.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference37, (String)stringConcatenation74.toString());
        EReference eReference38 = PostprocessingHelpers.getReference((EClass)cls, (String)"conjugated");
        StringConcatenation stringConcatenation75 = new StringConcatenation();
        stringConcatenation75.append("This is the optional conjugate port class specification.");
        stringConcatenation75.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference38, (String)stringConcatenation75.toString());
        EReference eReference39 = PostprocessingHelpers.getReference((EClass)cls, (String)"semantics");
        StringConcatenation stringConcatenation76 = new StringConcatenation();
        stringConcatenation76.append("This is the optional semantics specification for this protocol.");
        stringConcatenation76.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference39, (String)stringConcatenation76.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"Message");
        StringConcatenation stringConcatenation77 = new StringConcatenation();
        stringConcatenation77.append("This is a concrete sub class of an {@link AbstractMessage}.");
        stringConcatenation77.newLine();
        stringConcatenation77.append("A message in ROOM is part of a {@link ProtocolClass}. Messages are exchanged via {@link Port}s.");
        stringConcatenation77.newLine();
        stringConcatenation77.append("For event driven protocols the message is an object that is deliverd using a message");
        stringConcatenation77.newLine();
        stringConcatenation77.append("service of the runtime. For data driven systems only messages holding data are valid. In this");
        stringConcatenation77.newLine();
        stringConcatenation77.append("case the conjugate port is the one holding (and writing) the data and the regular port is");
        stringConcatenation77.newLine();
        stringConcatenation77.append("reading the data.");
        stringConcatenation77.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation77.toString());
        EAttribute eAttribute18 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"name");
        StringConcatenation stringConcatenation78 = new StringConcatenation();
        stringConcatenation78.append("By this name the message is referred to in the model.");
        stringConcatenation78.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute18, (String)stringConcatenation78.toString());
        EAttribute eAttribute19 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"priv");
        StringConcatenation stringConcatenation79 = new StringConcatenation();
        stringConcatenation79.append("If this flag is {@code true} then the message is treated as private for this protocol");
        stringConcatenation79.newLine();
        stringConcatenation79.append("and can only be sent by a PortClass.");
        stringConcatenation79.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute19, (String)stringConcatenation79.toString());
        EReference eReference40 = PostprocessingHelpers.getReference((EClass)cls, (String)"data");
        StringConcatenation stringConcatenation80 = new StringConcatenation();
        stringConcatenation80.append("This is a reference to optional message data.");
        stringConcatenation80.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference40, (String)stringConcatenation80.toString());
        EReference eReference41 = PostprocessingHelpers.getReference((EClass)cls, (String)"docu");
        StringConcatenation stringConcatenation81 = new StringConcatenation();
        stringConcatenation81.append("This is an optional documentation.");
        stringConcatenation81.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference41, (String)stringConcatenation81.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"PortClass");
        StringConcatenation stringConcatenation82 = new StringConcatenation();
        stringConcatenation82.append("A port class can be specified to customize the behavior of a {@link ProtocolClass}.");
        stringConcatenation82.newLine();
        stringConcatenation82.append("There can be one for regular ports and another one for conjugate ports independently.");
        stringConcatenation82.newLine();
        stringConcatenation82.newLine();
        stringConcatenation82.append("<p>");
        stringConcatenation82.newLine();
        stringConcatenation82.append("Port classes can be used to define attributes and operations and message handlers");
        stringConcatenation82.newLine();
        stringConcatenation82.append("(or interceptors).");
        stringConcatenation82.newLine();
        stringConcatenation82.append("</p>");
        stringConcatenation82.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation82.toString());
        EReference eReference42 = PostprocessingHelpers.getReference((EClass)cls, (String)"operations");
        StringConcatenation stringConcatenation83 = new StringConcatenation();
        stringConcatenation83.append("This is a list of operations of this nested class.");
        stringConcatenation83.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference42, (String)stringConcatenation83.toString());
        EReference eReference43 = PostprocessingHelpers.getReference((EClass)cls, (String)"attributes");
        StringConcatenation stringConcatenation84 = new StringConcatenation();
        stringConcatenation84.append("This is a list of attributes of this nested class.");
        stringConcatenation84.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference43, (String)stringConcatenation84.toString());
        EReference eReference44 = PostprocessingHelpers.getReference((EClass)cls, (String)"userCode");
        StringConcatenation stringConcatenation85 = new StringConcatenation();
        stringConcatenation85.append("The user code is treated in a generator dependent way.");
        stringConcatenation85.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference44, (String)stringConcatenation85.toString());
        EReference eReference45 = PostprocessingHelpers.getReference((EClass)cls, (String)"msgHandlers");
        StringConcatenation stringConcatenation86 = new StringConcatenation();
        stringConcatenation86.append("This is a list of message handlers.");
        stringConcatenation86.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference45, (String)stringConcatenation86.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"MessageHandler");
        StringConcatenation stringConcatenation87 = new StringConcatenation();
        stringConcatenation87.append("The super class of");
        stringConcatenation87.newLine();
        stringConcatenation87.append("<ul>");
        stringConcatenation87.newLine();
        stringConcatenation87.append("  ");
        stringConcatenation87.append("<li>{@link InMessageHandler}</li>");
        stringConcatenation87.newLine();
        stringConcatenation87.append("  ");
        stringConcatenation87.append("<li>{@link OutMessageHandler}</li>");
        stringConcatenation87.newLine();
        stringConcatenation87.append("</ul>");
        stringConcatenation87.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation87.toString());
        EReference eReference46 = PostprocessingHelpers.getReference((EClass)cls, (String)"msg");
        StringConcatenation stringConcatenation88 = new StringConcatenation();
        stringConcatenation88.append("This is the message that is handled.");
        stringConcatenation88.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference46, (String)stringConcatenation88.toString());
        EReference eReference47 = PostprocessingHelpers.getReference((EClass)cls, (String)"detailCode");
        StringConcatenation stringConcatenation89 = new StringConcatenation();
        stringConcatenation89.append("This is the handler code written in code generator target language.");
        stringConcatenation89.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference47, (String)stringConcatenation89.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"InMessageHandler");
        StringConcatenation stringConcatenation90 = new StringConcatenation();
        stringConcatenation90.append("Is a handler (or interceptor) for incoming messages. In the generated code the");
        stringConcatenation90.newLine();
        stringConcatenation90.append("message is available. It is derived from {@link MessageHandler}.");
        stringConcatenation90.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation90.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"OutMessageHandler");
        StringConcatenation stringConcatenation91 = new StringConcatenation();
        stringConcatenation91.append("Is a handler (or interceptor) for outgoing messages. In the generated code the");
        stringConcatenation91.newLine();
        stringConcatenation91.append("message is available. It is derived from {@link MessageHandler}.");
        stringConcatenation91.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation91.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"ActorClass");
        StringConcatenation stringConcatenation92 = new StringConcatenation();
        stringConcatenation92.append("Together with {@link ProtocolClass} and {@link DataClass} one of");
        stringConcatenation92.newLine();
        stringConcatenation92.append("the main class types of the ROOM language.");
        stringConcatenation92.newLine();
        stringConcatenation92.newLine();
        stringConcatenation92.append("<p>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("The actor class in ROOM has three compartments which aren't represented as separate model objects.");
        stringConcatenation92.newLine();
        stringConcatenation92.append("To understand to which compartment an attribute or reference belongs to here is a list");
        stringConcatenation92.newLine();
        stringConcatenation92.append("<ul>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("  ");
        stringConcatenation92.append("<li>Interface: everything which is visible from the outside from a model point of view");
        stringConcatenation92.newLine();
        stringConcatenation92.append("  ");
        stringConcatenation92.append("<ul>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("    ");
        stringConcatenation92.append("<li>{@link #getInterfacePorts}: a list of all interface {@link Port}s</li>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("    ");
        stringConcatenation92.append("<li>{@link ActorContainerClass#getServiceProvisionPoints()}: a list of all interface {@link SPP}s</li>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("  ");
        stringConcatenation92.append("</ul>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("  ");
        stringConcatenation92.append("<li>Structure: all internal structural aspects of an actor class</li>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("  ");
        stringConcatenation92.append("<ul>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("    ");
        stringConcatenation92.append("<li>{@link #getUserCode1}-3: user defined code with generator dependent meaning</li>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("    ");
        stringConcatenation92.append("<li>{@link #getInternalPorts}: a list of all internal end {@link Port}s</li>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("    ");
        stringConcatenation92.append("<li>{@link #getExternalPorts}: a list of all {@link ExternalPort}s (the interface ports that");
        stringConcatenation92.newLine();
        stringConcatenation92.append("       ");
        stringConcatenation92.append("are end ports, not relay ports</li>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("    ");
        stringConcatenation92.append("<li>{@link #getServiceImplementations}: a list of all {@link ServiceImplementation}s</li>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("    ");
        stringConcatenation92.append("<li>{@link #getServiceAccessPoints}: a list of all {@link SAP}s used by this actor class</li>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("    ");
        stringConcatenation92.append("<li>{@link #getAttributes}: a list of all actor class {@link Attribute}s</li>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("    ");
        stringConcatenation92.append("<li>{@link #getActorRefs}: a list of all referenced actor classes (an {@link ActorRef}");
        stringConcatenation92.newLine();
        stringConcatenation92.append("       ");
        stringConcatenation92.append("has the meaning of a composition)</li>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("    ");
        stringConcatenation92.append("<li>{@link #getBindings}: a list of all port {@link Binding}s of this actor class</li>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("    ");
        stringConcatenation92.append("<li>{@link #getConnections}: a list of all {@link LayerConnection}s</li>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("  ");
        stringConcatenation92.append("</ul>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("  ");
        stringConcatenation92.append("<li>Behavior: the behavioral aspects of an actor class</li>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("  ");
        stringConcatenation92.append("<ul>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("    ");
        stringConcatenation92.append("<li>{@link #getOperations}: a list of {@link Operation}s</li>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("    ");
        stringConcatenation92.append("<li>{@link #getStateMachine}: the {@link StateGraph state machine} definition</li>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("  ");
        stringConcatenation92.append("</ul>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("</ul>");
        stringConcatenation92.newLine();
        stringConcatenation92.append("</p>");
        stringConcatenation92.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation92.toString());
        EAttribute eAttribute20 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"name");
        StringConcatenation stringConcatenation93 = new StringConcatenation();
        stringConcatenation93.append("By this name the actor class is referred to in the model.");
        stringConcatenation93.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute20, (String)stringConcatenation93.toString());
        EAttribute eAttribute21 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"abstract");
        StringConcatenation stringConcatenation94 = new StringConcatenation();
        stringConcatenation94.append("If {@code true} this actor class can not be instantiated and can only be base class");
        stringConcatenation94.newLine();
        stringConcatenation94.append("for other actor classes.");
        stringConcatenation94.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute21, (String)stringConcatenation94.toString());
        EAttribute eAttribute22 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"commType");
        StringConcatenation stringConcatenation95 = new StringConcatenation();
        stringConcatenation95.append("The communication type of this actor class.");
        stringConcatenation95.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute22, (String)stringConcatenation95.toString());
        EReference eReference48 = PostprocessingHelpers.getReference((EClass)cls, (String)"base");
        StringConcatenation stringConcatenation96 = new StringConcatenation();
        stringConcatenation96.append("The base class from which all attributes, operations, ports, SAPs");
        stringConcatenation96.newLine();
        stringConcatenation96.append("and state machine are inherited.");
        stringConcatenation96.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference48, (String)stringConcatenation96.toString());
        EReference eReference49 = PostprocessingHelpers.getReference((EClass)cls, (String)"interfacePorts");
        StringConcatenation stringConcatenation97 = new StringConcatenation();
        stringConcatenation97.append("This is a list containing all ports of the actor interface.");
        stringConcatenation97.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference49, (String)stringConcatenation97.toString());
        EReference eReference50 = PostprocessingHelpers.getReference((EClass)cls, (String)"internalPorts");
        StringConcatenation stringConcatenation98 = new StringConcatenation();
        stringConcatenation98.append("This is a list containing all ports of the actor structure (internal end ports).");
        stringConcatenation98.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference50, (String)stringConcatenation98.toString());
        EReference eReference51 = PostprocessingHelpers.getReference((EClass)cls, (String)"externalPorts");
        StringConcatenation stringConcatenation99 = new StringConcatenation();
        stringConcatenation99.append("This is a list containing all ports of the actor interface that are end ports.");
        stringConcatenation99.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference51, (String)stringConcatenation99.toString());
        EReference eReference52 = PostprocessingHelpers.getReference((EClass)cls, (String)"structureDocu");
        StringConcatenation stringConcatenation100 = new StringConcatenation();
        stringConcatenation100.append("This is an optional documentation of the actor structure.");
        stringConcatenation100.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference52, (String)stringConcatenation100.toString());
        EReference eReference53 = PostprocessingHelpers.getReference((EClass)cls, (String)"serviceImplementations");
        StringConcatenation stringConcatenation101 = new StringConcatenation();
        stringConcatenation101.append("This is a list of all service implementations.");
        stringConcatenation101.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference53, (String)stringConcatenation101.toString());
        EReference eReference54 = PostprocessingHelpers.getReference((EClass)cls, (String)"serviceAccessPoints");
        StringConcatenation stringConcatenation102 = new StringConcatenation();
        stringConcatenation102.append("This is a list of all SAPs.");
        stringConcatenation102.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference54, (String)stringConcatenation102.toString());
        EReference eReference55 = PostprocessingHelpers.getReference((EClass)cls, (String)"attributes");
        StringConcatenation stringConcatenation103 = new StringConcatenation();
        stringConcatenation103.append("This is a list of all actor class private attributes.");
        stringConcatenation103.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference55, (String)stringConcatenation103.toString());
        EReference eReference56 = PostprocessingHelpers.getReference((EClass)cls, (String)"behaviorDocu");
        StringConcatenation stringConcatenation104 = new StringConcatenation();
        stringConcatenation104.append("This is an optional documentation of the actor behavior.");
        stringConcatenation104.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference56, (String)stringConcatenation104.toString());
        EReference eReference57 = PostprocessingHelpers.getReference((EClass)cls, (String)"behaviorAnnotations");
        StringConcatenation stringConcatenation105 = new StringConcatenation();
        stringConcatenation105.append("This is a list of annotations to the actor behavior.");
        stringConcatenation105.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference57, (String)stringConcatenation105.toString());
        EReference eReference58 = PostprocessingHelpers.getReference((EClass)cls, (String)"operations");
        StringConcatenation stringConcatenation106 = new StringConcatenation();
        stringConcatenation106.append("This is a list of all private operations of this actor class.");
        stringConcatenation106.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference58, (String)stringConcatenation106.toString());
        EReference eReference59 = PostprocessingHelpers.getReference((EClass)cls, (String)"stateMachine");
        StringConcatenation stringConcatenation107 = new StringConcatenation();
        stringConcatenation107.append("This is the actor's optional state machine.");
        stringConcatenation107.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference59, (String)stringConcatenation107.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"InterfaceItem");
        StringConcatenation stringConcatenation108 = new StringConcatenation();
        stringConcatenation108.append("This is a concrete sub class of an {@link AbstractInterfaceItem}.");
        stringConcatenation108.newLine();
        stringConcatenation108.newLine();
        stringConcatenation108.append("It is the super class of");
        stringConcatenation108.newLine();
        stringConcatenation108.append("<ul>");
        stringConcatenation108.newLine();
        stringConcatenation108.append("  ");
        stringConcatenation108.append("<li>{@link Port}</li>");
        stringConcatenation108.newLine();
        stringConcatenation108.append("  ");
        stringConcatenation108.append("<li>{@link SAP}</li>");
        stringConcatenation108.newLine();
        stringConcatenation108.append("  ");
        stringConcatenation108.append("<li>{@link SPP}</li>");
        stringConcatenation108.newLine();
        stringConcatenation108.append("</ul>");
        stringConcatenation108.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation108.toString());
        EAttribute eAttribute23 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"name");
        StringConcatenation stringConcatenation109 = new StringConcatenation();
        stringConcatenation109.append("By this name the interface item is referred to in the model.");
        stringConcatenation109.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute23, (String)stringConcatenation109.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"Port");
        StringConcatenation stringConcatenation110 = new StringConcatenation();
        stringConcatenation110.append("A port defines a part of the interface of an {@link ActorClass} in a specific role.");
        stringConcatenation110.newLine();
        stringConcatenation110.append("The port is associated with a {@link ProtocolClass}. If it is conjugated then the");
        stringConcatenation110.newLine();
        stringConcatenation110.append("roles of incoming and outgoing messages of the protocol are inverted.");
        stringConcatenation110.newLine();
        stringConcatenation110.newLine();
        stringConcatenation110.append("<p>");
        stringConcatenation110.newLine();
        stringConcatenation110.append("Ports can have a multiplicity. If it is greater one the port is called replicated.");
        stringConcatenation110.newLine();
        stringConcatenation110.append("</p>");
        stringConcatenation110.newLine();
        stringConcatenation110.newLine();
        stringConcatenation110.append("<p>");
        stringConcatenation110.newLine();
        stringConcatenation110.append("Whether a port is a relay port or not is a property that is derived from how it is");
        stringConcatenation110.newLine();
        stringConcatenation110.append("referenced by its {@link ActorClass}:");
        stringConcatenation110.newLine();
        stringConcatenation110.append("<ul>");
        stringConcatenation110.newLine();
        stringConcatenation110.append("  ");
        stringConcatenation110.append("<li>ports contained in the actor structure are called <em>internal end ports</em></li>");
        stringConcatenation110.newLine();
        stringConcatenation110.append("  ");
        stringConcatenation110.append("<li>ports contained in the actor interface and are also referenced by an {@link ExternalPort}");
        stringConcatenation110.newLine();
        stringConcatenation110.append("     ");
        stringConcatenation110.append("are called <em>external end ports</em></li>");
        stringConcatenation110.newLine();
        stringConcatenation110.append("  ");
        stringConcatenation110.append("<li>ports contained in the actor interface only are called <em>relay ports</em></li>");
        stringConcatenation110.newLine();
        stringConcatenation110.append("</ul>");
        stringConcatenation110.newLine();
        stringConcatenation110.append("Relay ports delegate to sub actors and end ports are connected to the actor's state machine.");
        stringConcatenation110.newLine();
        stringConcatenation110.append("</p>");
        stringConcatenation110.newLine();
        stringConcatenation110.newLine();
        stringConcatenation110.append("@see org.eclipse.etrice.core.room.util.RoomHelpers#isRelay(Port) RoomHelpers.isRelay(Port)");
        stringConcatenation110.newLine();
        stringConcatenation110.append("@see org.eclipse.etrice.core.room.util.RoomHelpers#isInternal(Port) RoomHelpers.isInternal(Port)");
        stringConcatenation110.newLine();
        stringConcatenation110.append("@see org.eclipse.etrice.core.room.util.RoomHelpers#isExternal(Port) RoomHelpers.isExternal(Port)");
        stringConcatenation110.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation110.toString());
        EAttribute eAttribute24 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"conjugated");
        StringConcatenation stringConcatenation111 = new StringConcatenation();
        stringConcatenation111.append("If a port is conjugated then the roles of outgoing and incoming messages are interchanged.");
        stringConcatenation111.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute24, (String)stringConcatenation111.toString());
        EAttribute eAttribute25 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"multiplicity");
        StringConcatenation stringConcatenation112 = new StringConcatenation();
        stringConcatenation112.append("Ports with multiplicity >1 are called replicated ports. A multiplicity of {@code -1} means replicated");
        stringConcatenation112.newLine();
        stringConcatenation112.append("port with arbitrary multiplicity.");
        stringConcatenation112.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute25, (String)stringConcatenation112.toString());
        EReference eReference60 = PostprocessingHelpers.getReference((EClass)cls, (String)"protocol");
        StringConcatenation stringConcatenation113 = new StringConcatenation();
        stringConcatenation113.append("This is the port's protocol class.");
        stringConcatenation113.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference60, (String)stringConcatenation113.toString());
        EReference eReference61 = PostprocessingHelpers.getReference((EClass)cls, (String)"docu");
        StringConcatenation stringConcatenation114 = new StringConcatenation();
        stringConcatenation114.append("This is an optional documentation.");
        stringConcatenation114.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference61, (String)stringConcatenation114.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"ExternalPort");
        StringConcatenation stringConcatenation115 = new StringConcatenation();
        stringConcatenation115.append("An external port is part of the actor structure and references an interface port.");
        stringConcatenation115.newLine();
        stringConcatenation115.append("An interface port which is referenced by an external port is an external end port.");
        stringConcatenation115.newLine();
        stringConcatenation115.append("If it is not referenced it is a relay port.");
        stringConcatenation115.newLine();
        stringConcatenation115.newLine();
        stringConcatenation115.append("@see Port");
        stringConcatenation115.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation115.toString());
        EReference eReference62 = PostprocessingHelpers.getReference((EClass)cls, (String)"interfacePort");
        StringConcatenation stringConcatenation116 = new StringConcatenation();
        stringConcatenation116.append("This is the referenced interface port of the actor class which is now an external end port.");
        stringConcatenation116.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference62, (String)stringConcatenation116.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"SAP");
        StringConcatenation stringConcatenation117 = new StringConcatenation();
        stringConcatenation117.append("A service access point is similar to a {@link Port} but is not explicitly bound to a peer.");
        stringConcatenation117.newLine();
        stringConcatenation117.append("Rather, it is bound to a {@link ServiceImplementation} which is connected to one of the");
        stringConcatenation117.newLine();
        stringConcatenation117.append("containing actors.");
        stringConcatenation117.newLine();
        stringConcatenation117.newLine();
        stringConcatenation117.append("<p>");
        stringConcatenation117.newLine();
        stringConcatenation117.append("An SAP is associated with a {@link ProtocolClass} and is conjugate to this protocol.");
        stringConcatenation117.newLine();
        stringConcatenation117.append("</p>");
        stringConcatenation117.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation117.toString());
        EReference eReference63 = PostprocessingHelpers.getReference((EClass)cls, (String)"protocol");
        StringConcatenation stringConcatenation118 = new StringConcatenation();
        stringConcatenation118.append("This is the SAP's protocol class.");
        stringConcatenation118.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference63, (String)stringConcatenation118.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"SPP");
        StringConcatenation stringConcatenation119 = new StringConcatenation();
        stringConcatenation119.append("A service provision point is used to connect an actor class with a {@link ServiceImplementation}.");
        stringConcatenation119.newLine();
        stringConcatenation119.append("It can (similar to relay ports) delegate to another actor class (using a {@link LayerConnection})");
        stringConcatenation119.newLine();
        stringConcatenation119.append("or connect to a {@link ServiceImplementation} of its actor class.");
        stringConcatenation119.newLine();
        stringConcatenation119.newLine();
        stringConcatenation119.append("<p>");
        stringConcatenation119.newLine();
        stringConcatenation119.append("An SPP is associated with a {@link ProtocolClass} and is regular to this protocol.");
        stringConcatenation119.newLine();
        stringConcatenation119.append("</p>");
        stringConcatenation119.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation119.toString());
        EReference eReference64 = PostprocessingHelpers.getReference((EClass)cls, (String)"protocol");
        StringConcatenation stringConcatenation120 = new StringConcatenation();
        stringConcatenation120.append("This is the SAP's protocol class.");
        stringConcatenation120.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference64, (String)stringConcatenation120.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"ServiceImplementation");
        StringConcatenation stringConcatenation121 = new StringConcatenation();
        stringConcatenation121.append("A service implementation can be reagrded as the replicated peer port of all {@link SAP}s");
        stringConcatenation121.newLine();
        stringConcatenation121.append("that are bound to it following the service resolution logic.");
        stringConcatenation121.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation121.toString());
        EReference eReference65 = PostprocessingHelpers.getReference((EClass)cls, (String)"spp");
        StringConcatenation stringConcatenation122 = new StringConcatenation();
        stringConcatenation122.append("This is the SPP connected to the service.");
        stringConcatenation122.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference65, (String)stringConcatenation122.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"LogicalSystem");
        StringConcatenation stringConcatenation123 = new StringConcatenation();
        stringConcatenation123.append("The top level structural class. It can only contain sub systems using {@link SubSystemRef}s.");
        stringConcatenation123.newLine();
        stringConcatenation123.append("This way the logical system is composed of sub system instances. It also defines");
        stringConcatenation123.newLine();
        stringConcatenation123.append("{@link Binding}s and {@link LayerConnection}s between those sub systems.");
        stringConcatenation123.newLine();
        stringConcatenation123.newLine();
        stringConcatenation123.append("<p>");
        stringConcatenation123.newLine();
        stringConcatenation123.append("The logical system is the root of the instance tree of the generator model.");
        stringConcatenation123.newLine();
        stringConcatenation123.append("Each {@link SubSystemRef} is turned into a {@link org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance} and each");
        stringConcatenation123.newLine();
        stringConcatenation123.append("{@link ActorRef} is turned into an {@link org.eclipse.etrice.core.genmodel.etricegen.ActorInstance}.");
        stringConcatenation123.newLine();
        stringConcatenation123.append("</p>");
        stringConcatenation123.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation123.toString());
        EReference eReference66 = PostprocessingHelpers.getReference((EClass)cls, (String)"subSystems");
        StringConcatenation stringConcatenation124 = new StringConcatenation();
        stringConcatenation124.append("The list of all sub systems contained in the logical system.");
        stringConcatenation124.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference66, (String)stringConcatenation124.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"ActorContainerRef");
        StringConcatenation stringConcatenation125 = new StringConcatenation();
        stringConcatenation125.append("The super class of");
        stringConcatenation125.newLine();
        stringConcatenation125.append("<ul>");
        stringConcatenation125.newLine();
        stringConcatenation125.append("  ");
        stringConcatenation125.append("<li>{@link SubSystemRef}</li>");
        stringConcatenation125.newLine();
        stringConcatenation125.append("  ");
        stringConcatenation125.append("<li>{@link ActorRef}</li>");
        stringConcatenation125.newLine();
        stringConcatenation125.append("</ul>");
        stringConcatenation125.newLine();
        stringConcatenation125.append("The reference designates a specific role of the referenced structure class.");
        stringConcatenation125.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation125.toString());
        EAttribute eAttribute26 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"name");
        StringConcatenation stringConcatenation126 = new StringConcatenation();
        stringConcatenation126.append("By this name the actor container reference is referred to in the model.");
        stringConcatenation126.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute26, (String)stringConcatenation126.toString());
        EReference eReference67 = PostprocessingHelpers.getReference((EClass)cls, (String)"docu");
        StringConcatenation stringConcatenation127 = new StringConcatenation();
        stringConcatenation127.append("This is an optional documentation.");
        stringConcatenation127.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference67, (String)stringConcatenation127.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"SubSystemRef");
        StringConcatenation stringConcatenation128 = new StringConcatenation();
        stringConcatenation128.append("A means to compose {@link LogicalSystem}s of {@link SubSystemClass}es. Each ref will");
        stringConcatenation128.newLine();
        stringConcatenation128.append("be turned into a sub system instance of the referenced type.");
        stringConcatenation128.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation128.toString());
        EReference eReference68 = PostprocessingHelpers.getReference((EClass)cls, (String)"type");
        StringConcatenation stringConcatenation129 = new StringConcatenation();
        stringConcatenation129.append("The type of the reference.");
        stringConcatenation129.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference68, (String)stringConcatenation129.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"SubSystemClass");
        StringConcatenation stringConcatenation130 = new StringConcatenation();
        stringConcatenation130.append("A sub system class corresponds to a process with a separate address space.");
        stringConcatenation130.newLine();
        stringConcatenation130.append("It has no behavior of its own and is composed of {@link ActorClass}es.");
        stringConcatenation130.newLine();
        stringConcatenation130.newLine();
        stringConcatenation130.append("<p>");
        stringConcatenation130.newLine();
        stringConcatenation130.append("Sub systems can be connected using {@link Port}s and {@link Binding}s.");
        stringConcatenation130.newLine();
        stringConcatenation130.append("All ports of a sub system are relay ports.");
        stringConcatenation130.newLine();
        stringConcatenation130.append("</p>");
        stringConcatenation130.newLine();
        stringConcatenation130.newLine();
        stringConcatenation130.append("<p>");
        stringConcatenation130.newLine();
        stringConcatenation130.append("Sub systems can define an arbitrary number of logical threads onto which their actor");
        stringConcatenation130.newLine();
        stringConcatenation130.append("instances are mapped.");
        stringConcatenation130.newLine();
        stringConcatenation130.append("</p>");
        stringConcatenation130.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation130.toString());
        EReference eReference69 = PostprocessingHelpers.getReference((EClass)cls, (String)"relayPorts");
        StringConcatenation stringConcatenation131 = new StringConcatenation();
        stringConcatenation131.append("This is a list of all relay ports of the sub system.");
        stringConcatenation131.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference69, (String)stringConcatenation131.toString());
        EReference eReference70 = PostprocessingHelpers.getReference((EClass)cls, (String)"threads");
        StringConcatenation stringConcatenation132 = new StringConcatenation();
        stringConcatenation132.append("This is a list of all threads of the sub system.");
        stringConcatenation132.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference70, (String)stringConcatenation132.toString());
        EReference eReference71 = PostprocessingHelpers.getReference((EClass)cls, (String)"threads");
        StringConcatenation stringConcatenation133 = new StringConcatenation();
        stringConcatenation133.append("This is a list of all actor instance mappings of the sub system.");
        stringConcatenation133.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference71, (String)stringConcatenation133.toString());
        EReference eReference72 = PostprocessingHelpers.getReference((EClass)cls, (String)"actorInstanceMappings");
        StringConcatenation stringConcatenation134 = new StringConcatenation();
        stringConcatenation134.append("This is a list of actor instance mappings.");
        stringConcatenation134.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference72, (String)stringConcatenation134.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"LogicalThread");
        StringConcatenation stringConcatenation135 = new StringConcatenation();
        stringConcatenation135.append("A logical thread is addressed by the {@link ActorInstanceMapping}s of a {@link SubSystemClass}.");
        stringConcatenation135.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation135.toString());
        EAttribute eAttribute27 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"name");
        StringConcatenation stringConcatenation136 = new StringConcatenation();
        stringConcatenation136.append("By this name the thread is referred to in the model.");
        stringConcatenation136.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute27, (String)stringConcatenation136.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"ActorInstanceMapping");
        StringConcatenation stringConcatenation137 = new StringConcatenation();
        stringConcatenation137.append("An actor instance mapping maps an actor instances (described as a path of actor references)");
        stringConcatenation137.newLine();
        stringConcatenation137.append("to a {@link LogicalThread}");
        stringConcatenation137.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation137.toString());
        EReference eReference73 = PostprocessingHelpers.getReference((EClass)cls, (String)"path");
        StringConcatenation stringConcatenation138 = new StringConcatenation();
        stringConcatenation138.append("This is the path of references starting at this sub system that uniquely references an actor instance.");
        stringConcatenation138.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference73, (String)stringConcatenation138.toString());
        EReference eReference74 = PostprocessingHelpers.getReference((EClass)cls, (String)"thread");
        StringConcatenation stringConcatenation139 = new StringConcatenation();
        stringConcatenation139.append("This is the logical thread to which the referenced actor instance and all of its contained instances");
        stringConcatenation139.newLine();
        stringConcatenation139.append("are mapped.");
        stringConcatenation139.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference74, (String)stringConcatenation139.toString());
        EReference eReference75 = PostprocessingHelpers.getReference((EClass)cls, (String)"actorInstanceMappings");
        StringConcatenation stringConcatenation140 = new StringConcatenation();
        stringConcatenation140.append("This is a list of nested mappings which override parent mappings.");
        stringConcatenation140.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference75, (String)stringConcatenation140.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"RefPath");
        StringConcatenation stringConcatenation141 = new StringConcatenation();
        stringConcatenation141.append("A path of strings that are interpreted as {@link org.eclipse.etrice.core.room.ActorRef}s starting at a {@link org.eclipse.etrice.core.room.SubSystemClass}.");
        stringConcatenation141.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation141.toString());
        EReference eReference76 = PostprocessingHelpers.getReference((EClass)cls, (String)"refs");
        StringConcatenation stringConcatenation142 = new StringConcatenation();
        stringConcatenation142.append("This is a path in the instance tree where each segment corresponds to the name of the");
        stringConcatenation142.newLine();
        stringConcatenation142.append("corresponding {@link ActorContainerRef}.");
        stringConcatenation142.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference76, (String)stringConcatenation142.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"RefSegment");
        StringConcatenation stringConcatenation143 = new StringConcatenation();
        stringConcatenation143.append("A segment of a {@link RefPath}. It consists of a name and an optional index.");
        stringConcatenation143.newLine();
        stringConcatenation143.append("If the index is not set it will be {@code -1}.");
        stringConcatenation143.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation143.toString());
        EAttribute eAttribute28 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"ref");
        StringConcatenation stringConcatenation144 = new StringConcatenation();
        stringConcatenation144.append("The segment name corresponding to an actor reference.");
        stringConcatenation144.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute28, (String)stringConcatenation144.toString());
        EAttribute eAttribute29 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"idx");
        StringConcatenation stringConcatenation145 = new StringConcatenation();
        stringConcatenation145.append("The optional index of the reference (for replicated actors).");
        stringConcatenation145.newLine();
        stringConcatenation145.append("If not set the index is {@code -1}.");
        stringConcatenation145.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute29, (String)stringConcatenation145.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"Binding");
        StringConcatenation stringConcatenation146 = new StringConcatenation();
        stringConcatenation146.append("A binding connects two {@link Port}s.");
        stringConcatenation146.newLine();
        stringConcatenation146.append("To be able to distinguish the ports of two {@link ActorContainerRef}s of the same type");
        stringConcatenation146.newLine();
        stringConcatenation146.append("a {@link BindingEndPoint} is needed for disambiguation.");
        stringConcatenation146.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation146.toString());
        EReference eReference77 = PostprocessingHelpers.getReference((EClass)cls, (String)"endpoint1");
        StringConcatenation stringConcatenation147 = new StringConcatenation();
        stringConcatenation147.append("The first end point of a binding.");
        stringConcatenation147.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference77, (String)stringConcatenation147.toString());
        EReference eReference78 = PostprocessingHelpers.getReference((EClass)cls, (String)"endpoint2");
        StringConcatenation stringConcatenation148 = new StringConcatenation();
        stringConcatenation148.append("The second end point of a binding.");
        stringConcatenation148.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference78, (String)stringConcatenation148.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"BindingEndPoint");
        StringConcatenation stringConcatenation149 = new StringConcatenation();
        stringConcatenation149.append("A binding end point is a pair of an {@link ActorContainerRef} and a {@link Port} and is used");
        stringConcatenation149.newLine();
        stringConcatenation149.append("to uniquely describe a port of a sub actor. If the actor container ref is {@code null} then");
        stringConcatenation149.newLine();
        stringConcatenation149.append("a port of the actor class itself is addressed.");
        stringConcatenation149.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation149.toString());
        EReference eReference79 = PostprocessingHelpers.getReference((EClass)cls, (String)"actorRef");
        StringConcatenation stringConcatenation150 = new StringConcatenation();
        stringConcatenation150.append("The actor reference holding the bound port or {@code null} in case of a local port.");
        stringConcatenation150.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference79, (String)stringConcatenation150.toString());
        EReference eReference80 = PostprocessingHelpers.getReference((EClass)cls, (String)"port");
        StringConcatenation stringConcatenation151 = new StringConcatenation();
        stringConcatenation151.append("This is the bound port.");
        stringConcatenation151.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference80, (String)stringConcatenation151.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"LayerConnection");
        StringConcatenation stringConcatenation152 = new StringConcatenation();
        stringConcatenation152.append("Layer connections are used to connect {@link SAP}s and {@link ServiceImplementation}s.");
        stringConcatenation152.newLine();
        stringConcatenation152.append("The source is described by a {@link SAPoint} and the target by a {@link SPPoint}.");
        stringConcatenation152.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation152.toString());
        EReference eReference81 = PostprocessingHelpers.getReference((EClass)cls, (String)"from");
        StringConcatenation stringConcatenation153 = new StringConcatenation();
        stringConcatenation153.append("This is source point of the layer connection.");
        stringConcatenation153.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference81, (String)stringConcatenation153.toString());
        EReference eReference82 = PostprocessingHelpers.getReference((EClass)cls, (String)"to");
        StringConcatenation stringConcatenation154 = new StringConcatenation();
        stringConcatenation154.append("This is target point of the layer connection.");
        stringConcatenation154.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference82, (String)stringConcatenation154.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"SAPoint");
        StringConcatenation stringConcatenation155 = new StringConcatenation();
        stringConcatenation155.append("The super class of");
        stringConcatenation155.newLine();
        stringConcatenation155.append("<ul>");
        stringConcatenation155.newLine();
        stringConcatenation155.append("  ");
        stringConcatenation155.append("<li>{@link RefSAPoint}</li>");
        stringConcatenation155.newLine();
        stringConcatenation155.append("  ");
        stringConcatenation155.append("<li>{@link RelaySAPoint}</li>");
        stringConcatenation155.newLine();
        stringConcatenation155.append("</ul>");
        stringConcatenation155.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation155.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"RefSAPoint");
        StringConcatenation stringConcatenation156 = new StringConcatenation();
        stringConcatenation156.append("Links from a {@link ActorContainerRef}, i.e. from a sub actor.");
        stringConcatenation156.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation156.toString());
        EReference eReference83 = PostprocessingHelpers.getReference((EClass)cls, (String)"ref");
        StringConcatenation stringConcatenation157 = new StringConcatenation();
        stringConcatenation157.append("This is the referenced actor container ref.");
        stringConcatenation157.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference83, (String)stringConcatenation157.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"RelaySAPoint");
        StringConcatenation stringConcatenation158 = new StringConcatenation();
        stringConcatenation158.append("Links from a relay {@link SPP} of the actor class.");
        stringConcatenation158.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation158.toString());
        EReference eReference84 = PostprocessingHelpers.getReference((EClass)cls, (String)"relay");
        StringConcatenation stringConcatenation159 = new StringConcatenation();
        stringConcatenation159.append("This is the referenced SPP.");
        stringConcatenation159.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference84, (String)stringConcatenation159.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"SPPoint");
        StringConcatenation stringConcatenation160 = new StringConcatenation();
        stringConcatenation160.append("Links to a {@link SPP} of an {@link ActorContainerRef}, i.e. an SPP of a sub actor");
        stringConcatenation160.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation160.toString());
        EReference eReference85 = PostprocessingHelpers.getReference((EClass)cls, (String)"ref");
        StringConcatenation stringConcatenation161 = new StringConcatenation();
        stringConcatenation161.append("This is the referenced actor container ref.");
        stringConcatenation161.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference85, (String)stringConcatenation161.toString());
        EReference eReference86 = PostprocessingHelpers.getReference((EClass)cls, (String)"service");
        StringConcatenation stringConcatenation162 = new StringConcatenation();
        stringConcatenation162.append("This is the referenced service.");
        stringConcatenation162.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference86, (String)stringConcatenation162.toString());
        cls = PostprocessingHelpers.getClass((EPackage)pckg, (String)"ActorRef");
        StringConcatenation stringConcatenation163 = new StringConcatenation();
        stringConcatenation163.append("A means to compose {@link SubSystemClass}es of {@link ActorClass}es. Each ref will");
        stringConcatenation163.newLine();
        stringConcatenation163.append("be turned into an actor instance of the referenced type.");
        stringConcatenation163.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, (String)stringConcatenation163.toString());
        EReference eReference87 = PostprocessingHelpers.getReference((EClass)cls, (String)"type");
        StringConcatenation stringConcatenation164 = new StringConcatenation();
        stringConcatenation164.append("This is the type (i.e. actor class) of the actor ref.");
        stringConcatenation164.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference87, (String)stringConcatenation164.toString());
        EAttribute eAttribute30 = PostprocessingHelpers.getAttribute((EClass)cls, (String)"multiplicity");
        StringConcatenation stringConcatenation165 = new StringConcatenation();
        stringConcatenation165.append("If the size is >1 then this is a replicated actor.");
        stringConcatenation165.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute30, (String)stringConcatenation165.toString());
    }
}

