/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.expressions.detailcode;

import com.google.common.base.Objects;
import java.util.LinkedList;
import org.eclipse.etrice.expressions.detailcode.IDetailExpressionProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@FinalFieldsConstructor
public class DetailExpressionAssistParser {
    private final IDocument document;
    private final int invocationOffset;
    private final IDetailExpressionProvider provider;
    private final IWordDetector anyIdScanner = new IWordDetector(){

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }

        public boolean isWordStart(char c) {
            return Character.isJavaIdentifierStart(c);
        }
    };

    public String computeIdentifierPrefix(int offset) throws BadLocationException {
        int start = offset - 1;
        while (start >= 0 && this.anyIdScanner.isWordPart(this.document.getChar(start))) {
            --start;
        }
        return this.document.get(++start, offset - start);
    }

    public IDetailExpressionProvider.ExpressionFeature computeExpressionFeature(int offset) throws BadLocationException {
        String idResult;
        IDetailExpressionProvider.ExpressionPostfix postfixResult;
        block9: {
            boolean bl;
            postfixResult = null;
            char openingChar = '\u0000';
            char closingChar = '\u0000';
            String string = Character.valueOf(this.document.getChar(offset - 1)).toString();
            boolean bl2 = false;
            if (Objects.equal((Object)string, (Object)")")) {
                bl2 = true;
                postfixResult = IDetailExpressionProvider.ExpressionPostfix.PARENTHESES;
                openingChar = '(';
                closingChar = ')';
            }
            if (!bl2 && Objects.equal((Object)string, (Object)"]")) {
                bl2 = true;
                postfixResult = IDetailExpressionProvider.ExpressionPostfix.BRACKETS;
                openingChar = '[';
                closingChar = ']';
            }
            if (!bl2) {
                postfixResult = IDetailExpressionProvider.ExpressionPostfix.NONE;
            }
            int start = offset;
            boolean bl3 = bl = !Objects.equal((Object)((Object)postfixResult), (Object)((Object)IDetailExpressionProvider.ExpressionPostfix.NONE));
            if (bl) {
                --start;
                int counter = 1;
                while (start > 0 && counter > 0) {
                    char c = this.document.getChar(--start);
                    boolean bl4 = false;
                    if (Objects.equal((Object)Character.valueOf(c), (Object)Character.valueOf(openingChar))) {
                        bl4 = true;
                        --counter;
                    }
                    if (bl4 || !Objects.equal((Object)Character.valueOf(c), (Object)Character.valueOf(closingChar))) continue;
                    bl4 = true;
                    ++counter;
                }
                if (counter > 0) {
                    postfixResult = null;
                }
            }
            idResult = null;
            try {
                idResult = this.computeIdentifierPrefix(start);
            }
            catch (Throwable throwable) {
                if (throwable instanceof BadLocationException) break block9;
                throw Exceptions.sneakyThrow((Throwable)throwable);
            }
        }
        return new IDetailExpressionProvider.ExpressionFeature(idResult, postfixResult);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public IDetailExpressionProvider.ExpressionFeature resolveLatestCompleted() {
        LinkedList parsedFeatures;
        block9: {
            int n;
            int lastSeparatorPos;
            block8: {
                lastSeparatorPos = this.invocationOffset - 1;
                try {
                    String invocationPrefix = this.computeIdentifierPrefix(this.invocationOffset);
                    int n2 = lastSeparatorPos;
                    n = invocationPrefix.length();
                    lastSeparatorPos = n2 - n;
                }
                catch (Throwable invocationPrefix) {
                    if (invocationPrefix instanceof BadLocationException) break block8;
                    throw Exceptions.sneakyThrow((Throwable)invocationPrefix);
                }
            }
            parsedFeatures = CollectionLiterals.newLinkedList();
            try {
                while (this.document.getChar(lastSeparatorPos) == '.') {
                    boolean bl;
                    IDetailExpressionProvider.ExpressionFeature parseResult = this.computeExpressionFeature(lastSeparatorPos);
                    n = this.isValid(parseResult) ? 1 : 0;
                    boolean bl2 = bl = n == 0;
                    if (bl) {
                        return null;
                    }
                    parsedFeatures.push(parseResult);
                    int n3 = lastSeparatorPos;
                    int n4 = parseResult.getId().length();
                    int n5 = n4 + 1;
                    lastSeparatorPos = n3 - n5;
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof BadLocationException) break block9;
                throw Exceptions.sneakyThrow((Throwable)throwable);
            }
        }
        boolean bl = parsedFeatures.isEmpty();
        if (bl) {
            return null;
        }
        final IDetailExpressionProvider.ExpressionFeature firstParseResult = (IDetailExpressionProvider.ExpressionFeature)parsedFeatures.pop();
        Functions.Function1<IDetailExpressionProvider.ExpressionFeature, Boolean> function1 = new Functions.Function1<IDetailExpressionProvider.ExpressionFeature, Boolean>(){

            public Boolean apply(IDetailExpressionProvider.ExpressionFeature it) {
                return DetailExpressionAssistParser.this.matches(it, firstParseResult);
            }
        };
        IDetailExpressionProvider.ExpressionFeature lastMatch = (IDetailExpressionProvider.ExpressionFeature)IterableExtensions.findFirst(this.provider.getInitialFeatures(), (Functions.Function1)function1);
        while (lastMatch != null && !parsedFeatures.isEmpty()) {
            final IDetailExpressionProvider.ExpressionFeature nextParseResult = (IDetailExpressionProvider.ExpressionFeature)parsedFeatures.pop();
            Functions.Function1<IDetailExpressionProvider.ExpressionFeature, Boolean> function12 = new Functions.Function1<IDetailExpressionProvider.ExpressionFeature, Boolean>(){

                public Boolean apply(IDetailExpressionProvider.ExpressionFeature it) {
                    return DetailExpressionAssistParser.this.matches(it, nextParseResult);
                }
            };
            lastMatch = (IDetailExpressionProvider.ExpressionFeature)IterableExtensions.findFirst(this.provider.getContextFeatures(lastMatch), (Functions.Function1)function12);
        }
        return lastMatch;
    }

    public boolean isContextExpression() {
        boolean bl = false;
        try {
            bl = this.document.getChar(this.invocationOffset - 1) == '.' || this.anyIdScanner.isWordPart(this.document.getChar(this.invocationOffset - 1));
        }
        catch (Throwable throwable) {
            if (throwable instanceof BadLocationException) {
                bl = false;
            }
            throw Exceptions.sneakyThrow((Throwable)throwable);
        }
        return bl;
    }

    public boolean isInitialExpression() {
        boolean bl = false;
        try {
            bl = this.document.getChar(this.invocationOffset - 1) != '.' && !Objects.equal((Object)this.document.get(this.invocationOffset - 2, 2), (Object)"->");
        }
        catch (Throwable throwable) {
            if (throwable instanceof BadLocationException) {
                bl = true;
            }
            throw Exceptions.sneakyThrow((Throwable)throwable);
        }
        return bl;
    }

    private boolean isValid(IDetailExpressionProvider.ExpressionFeature feature) {
        return !Strings.isEmpty((String)feature.getId()) && feature.getPostfix() != null;
    }

    private boolean matches(IDetailExpressionProvider.ExpressionFeature f1, IDetailExpressionProvider.ExpressionFeature f2) {
        return Objects.equal((Object)f1.getId(), (Object)f2.getId()) && Objects.equal((Object)((Object)f1.getPostfix()), (Object)((Object)f2.getPostfix()));
    }

    public DetailExpressionAssistParser(IDocument document, int invocationOffset, IDetailExpressionProvider provider) {
        this.document = document;
        this.invocationOffset = invocationOffset;
        this.provider = provider;
    }
}

