/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.doc.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInterfaceInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SystemInstance;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class InstanceDiagramGen {
    @Inject
    @Extension
    private RoomExtensions roomExt;

    public void doGenerate(Root root, IGeneratorFileIO fileIO) {
        String path = "images/";
        EList eList = root.getSystemInstances();
        for (SystemInstance sys : eList) {
            String string = sys.getName();
            String file = String.valueOf(string) + "_instanceTree.dot";
            fileIO.generateFile("generating instance tree diagram", String.valueOf(path) + file, this.generate(root, sys));
        }
    }

    private CharSequence generate(Root root, SystemInstance sys) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("//@startdot");
        stringConcatenation.newLine();
        stringConcatenation.append("digraph ");
        String string = sys.getName();
        stringConcatenation.append(string);
        stringConcatenation.append(" {");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        stringConcatenation.append("//rankdir=LR;");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("node [shape=box];");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        String string2 = this.roomExt.getPathName(sys.getPath());
        stringConcatenation.append(string2, "\t");
        stringConcatenation.append(" [label=\"");
        String string3 = sys.getName();
        stringConcatenation.append(string3, "\t");
        stringConcatenation.append("\\n(");
        String string4 = sys.getName();
        stringConcatenation.append(string4, "\t");
        stringConcatenation.append(")\" style=filled color=red];");
        stringConcatenation.newLineIfNotEmpty();
        EList eList = sys.getInstances();
        for (SubSystemInstance ssi : eList) {
            stringConcatenation.append("\t");
            String string5 = this.roomExt.getPathName(ssi.getPath());
            stringConcatenation.append(string5, "\t");
            stringConcatenation.append(" [label=\"");
            String string6 = ssi.getName();
            stringConcatenation.append(string6, "\t");
            stringConcatenation.append("\\n(");
            String string7 = ssi.getSubSystemClass().getName();
            stringConcatenation.append(string7, "\t");
            stringConcatenation.append(")\" style=filled color=yellow];");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\t");
            String string8 = this.roomExt.getPathName(sys.getPath());
            stringConcatenation.append(string8, "\t");
            stringConcatenation.append(" -> ");
            String string9 = this.roomExt.getPathName(ssi.getPath());
            stringConcatenation.append(string9, "\t");
            stringConcatenation.append(";");
            stringConcatenation.newLineIfNotEmpty();
            EList eList2 = ssi.getInstances();
            for (AbstractInstance ai : eList2) {
                stringConcatenation.append("\t");
                String string10 = this.instance(ai);
                stringConcatenation.append(string10, "\t");
                stringConcatenation.newLineIfNotEmpty();
            }
        }
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.append("//@enddot");
        stringConcatenation.newLine();
        return stringConcatenation;
    }

    private String instance(AbstractInstance ai) {
        boolean bl;
        String string = null;
        EObject eObject = ai.eContainer();
        StructureInstance parent = (StructureInstance)eObject;
        ETMapUtil.MappedThread pthread = ETMapUtil.getMappedThread((AbstractInstance)ai);
        String string2 = null;
        string2 = pthread == null ? "?" : pthread.getThread().getName();
        String tname = string2;
        NodeRef node = ETMapUtil.getNodeRef((AbstractInstance)ai);
        String string3 = null;
        string3 = node == null ? "?" : node.getName();
        String nname = string3;
        String string4 = null;
        string4 = ai instanceof ActorInterfaceInstance ? "optional " : "";
        String optional = string4;
        String string5 = null;
        if (ai instanceof ActorInstance) {
            string5 = ((ActorInstance)ai).getActorClass().getName();
        } else {
            String string6 = null;
            string6 = ai instanceof ActorInterfaceInstance ? ((ActorInterfaceInstance)ai).getActorClass().getName() : "?";
            string5 = string6;
        }
        String clsname = string5;
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string7 = this.roomExt.getPathName(ai.getPath());
        stringConcatenation.append(string7);
        stringConcatenation.append(" [label=\"");
        stringConcatenation.append(optional);
        String string8 = ai.getName();
        stringConcatenation.append(string8);
        stringConcatenation.append("\\n(");
        stringConcatenation.append(clsname);
        stringConcatenation.append(")\\n@");
        stringConcatenation.append(nname);
        stringConcatenation.append(":");
        stringConcatenation.append(tname);
        stringConcatenation.append("\"");
        boolean bl2 = optional.isEmpty();
        boolean bl3 = bl = !bl2;
        if (bl) {
            stringConcatenation.append(" color=blue style=dashed");
        }
        stringConcatenation.append("];");
        stringConcatenation.newLineIfNotEmpty();
        String string9 = this.roomExt.getPathName(parent.getPath());
        stringConcatenation.append(string9);
        stringConcatenation.append(" -> ");
        String string10 = this.roomExt.getPathName(ai.getPath());
        stringConcatenation.append(string10);
        stringConcatenation.append(";");
        stringConcatenation.newLineIfNotEmpty();
        if (ai instanceof StructureInstance) {
            EList eList = ((StructureInstance)ai).getInstances();
            for (AbstractInstance sub_ai : eList) {
                String string11 = this.instance(sub_ai);
                stringConcatenation.append(string11);
                stringConcatenation.newLineIfNotEmpty();
            }
        }
        string = stringConcatenation.toString();
        return string;
    }
}

