/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.launch;

import com.google.inject.Inject;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.ui.RoomUiModule;
import org.eclipse.xtext.ui.resource.XtextResourceSetProvider;

public class GeneratorLaunchHelper {
    @Inject
    private XtextResourceSetProvider resourceSetProvider;

    public GeneratorLaunchHelper() {
        RoomUiModule.getInjector().injectMembers((Object)this);
    }

    public List<Resource> loadResources(IProject project, List<IFile> files, boolean includeDependencies) throws CoreException {
        ResourceSet resourceSet = this.resourceSetProvider.get(project);
        List uris = files.stream().map(file -> URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true)).collect(Collectors.toList());
        for (URI uri2 : uris) {
            try {
                resourceSet.getResource(uri2, true);
            }
            catch (RuntimeException e) {
                throw new CoreException((IStatus)new Status(4, this.getClass(), "Failed to load resource " + uri2, (Throwable)e));
            }
        }
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        if (includeDependencies) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            return resourceSet.getResources().stream().filter(resource -> resource.getURI().isPlatformResource() && root.getFile((IPath)new Path(resource.getURI().toPlatformString(true))).getProject().equals((Object)project)).collect(Collectors.toList());
        }
        return uris.stream().map(uri -> resourceSet.getResource(uri, false)).collect(Collectors.toList());
    }
}

