/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.scoping;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.xtext.resource.IEObjectDescription;

public class ActorRefFilter
implements Predicate<IEObjectDescription> {
    @Inject
    private RoomHelpers roomHelpers;
    private ActorClass ac;

    public ActorRefFilter(ActorClass ac) {
        this.ac = ac;
    }

    public boolean apply(IEObjectDescription input) {
        if (input == null) {
            return false;
        }
        if (this.ac == null) {
            return true;
        }
        EObject obj = input.getEObjectOrProxy();
        if (obj instanceof ActorClass) {
            ActorClass ref = (ActorClass)obj;
            if (ref.getName() == null) {
                return true;
            }
            return !this.roomHelpers.isReferencing(ref, this.ac);
        }
        return true;
    }
}

