/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.contractmonitor.util;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.util.InterfaceContractHelpers;
import org.eclipse.etrice.generator.base.ModelValidator;
import org.eclipse.etrice.generator.base.args.Arguments;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ContractModelValidator
extends ModelValidator {
    @Inject
    private InterfaceContractHelpers helpers;

    @Inject
    public ContractModelValidator(IResourceValidator validator) {
        super(validator);
    }

    public void validate(List<Resource> resources, Arguments arguments, ILogger logger) {
        super.validate(this.getRelevantResources(resources), arguments, logger);
    }

    private List<Resource> getRelevantResources(Iterable<Resource> resources) {
        Functions.Function1<Resource, EList<EObject>> function1 = new Functions.Function1<Resource, EList<EObject>>(){

            public EList<EObject> apply(Resource it) {
                return it.getContents();
            }
        };
        Functions.Function1<RoomModel, Iterable<ProtocolClass>> function12 = new Functions.Function1<RoomModel, Iterable<ProtocolClass>>(){

            public Iterable<ProtocolClass> apply(RoomModel model) {
                Functions.Function1<ProtocolClass, Boolean> function1 = new Functions.Function1<ProtocolClass, Boolean>(){

                    public Boolean apply(ProtocolClass it) {
                        boolean bl = it.getAnnotations().isEmpty();
                        return !bl;
                    }
                };
                Functions.Function1<ProtocolClass, Boolean> function12 = new Functions.Function1<ProtocolClass, Boolean>(){

                    public Boolean apply(ProtocolClass pc) {
                        return (this).ContractModelValidator.this.helpers.hasContract(pc) || !EcoreUtil.UnresolvedProxyCrossReferencer.find((Collection)pc.getAnnotations()).isEmpty();
                    }
                };
                return IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)model.getRoomClasses(), ProtocolClass.class), (Functions.Function1)function1), (Functions.Function1)function12);
            }
        };
        List contractProtocols = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map(resources, (Functions.Function1)function1)), RoomModel.class), (Functions.Function1)function12)));
        Functions.Function1<ProtocolClass, ActorClass> function13 = new Functions.Function1<ProtocolClass, ActorClass>(){

            public ActorClass apply(ProtocolClass protocol) {
                return ContractModelValidator.this.helpers.getInterfaceContractActorClass(protocol);
            }
        };
        List contractMonitors = IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)contractProtocols, (Functions.Function1)function13)));
        Functions.Function1<RoomClass, Resource> function14 = new Functions.Function1<RoomClass, Resource>(){

            public Resource apply(RoomClass it) {
                return it.eResource();
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)Iterables.concat((Iterable)contractProtocols, (Iterable)contractMonitors), (Functions.Function1)function14)));
    }
}

