/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ui.editor;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.common.ui.editor.ISaveOnFocusLostEditor;
import org.eclipse.etrice.core.common.ui.editor.IValidatingEditor;
import org.eclipse.etrice.core.common.ui.editor.SaveDialogEditor;
import org.eclipse.etrice.core.common.validation.IssueUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class SaveOnFocusLostXtextEditor
extends XtextEditor
implements ISaveOnFocusLostEditor,
IValidatingEditor {
    @Inject
    protected IResourceValidator resourceValidator;
    protected SaveDialogEditor saveDialog = new SaveDialogEditor();

    @Override
    public boolean isValid() {
        return (Boolean)this.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<Boolean, XtextResource>(){

            public Boolean exec(XtextResource resource) throws Exception {
                return SaveOnFocusLostXtextEditor.this.isValid(resource);
            }
        });
    }

    protected boolean isValid(XtextResource resource) {
        List result = this.resourceValidator.validate((Resource)resource, CheckMode.NORMAL_AND_FAST, CancelIndicator.NullImpl);
        return !result.stream().anyMatch(issue -> issue.isSyntaxError() || IssueUtils.isBlocking((Issue)issue));
    }

    public int promptToSaveOnClose() {
        return this.saveDialog.open(this.getShell(), this.getPartName());
    }

    @Override
    public boolean shouldSaveOnFocusLost() {
        return this.saveDialog.getResult() != 1 && this.isDirty() && this.isValid();
    }
}

