/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.converter;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class CCStringIndentation {
    private static final Pattern lineSeparatorPattern = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("(\\r(\\n)?|\\n)");
            Pattern pattern = Pattern.compile(stringConcatenation.toString());
            return pattern;
        }
    }.apply();
    private final String ccString;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final ImmutableList<String> splittedLines;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final boolean ignoreFirst;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final boolean ignoreLast;

    public static boolean hasLineBreak(String nodeText) {
        int n = Strings.countLineBreaks((CharSequence)nodeText);
        return n > 0;
    }

    public static String firstLineSeparator(String it) {
        boolean bl;
        int n;
        boolean bl2;
        String string = null;
        boolean bl3 = false;
        int n2 = it.indexOf("\r\n");
        boolean bl4 = bl2 = n2 >= 0;
        if (bl2) {
            bl3 = true;
            string = "\r\n";
        }
        if (!bl3) {
            n = it.indexOf("\n");
            boolean bl5 = bl = n >= 0;
            if (bl) {
                bl3 = true;
                string = "\n";
            }
        }
        if (!bl3) {
            n = it.indexOf("\r");
            boolean bl6 = bl = n >= 0;
            if (bl) {
                bl3 = true;
                string = "\r";
            }
        }
        if (!bl3) {
            string = Strings.newLine();
        }
        return string;
    }

    public CCStringIndentation(final String ccString) {
        this.ccString = ccString;
        ArrayList arrayList = CollectionLiterals.newArrayList();
        Procedures.Procedure1<ArrayList<String>> procedure1 = new Procedures.Procedure1<ArrayList<String>>(){

            public void apply(ArrayList<String> lines) {
                boolean bl;
                Matcher matcher = lineSeparatorPattern.matcher(ccString);
                int lastOffset = 0;
                while (matcher.find()) {
                    String string = ccString.substring(lastOffset, matcher.end());
                    lines.add(string);
                    lastOffset = matcher.end();
                }
                int n = ccString.length();
                boolean bl2 = bl = lastOffset < n;
                if (bl) {
                    String string = ccString.substring(lastOffset);
                    lines.add(string);
                } else if (ccString.endsWith("\n") || ccString.endsWith("\r")) {
                    lines.add("");
                }
            }
        };
        ArrayList arrayList2 = (ArrayList)ObjectExtensions.operator_doubleArrow((Object)arrayList, (Procedures.Procedure1)procedure1);
        this.splittedLines = ImmutableList.copyOf((Collection)arrayList2);
        this.ignoreFirst = this.splittedLines.size() >= 2 && ((String)IterableExtensions.head(this.splittedLines)).trim().isEmpty();
        this.ignoreLast = this.splittedLines.size() >= 2 && ((String)IterableExtensions.last(this.splittedLines)).trim().isEmpty();
    }

    public String removeEditorWhiteSpace() {
        return this.removeEditorWhiteSpace("", null);
    }

    protected String removeEditorWhiteSpace(final String indent, final String lineSeparator) {
        Functions.Function1<Pair<Integer, Integer>, String> function1 = new Functions.Function1<Pair<Integer, Integer>, String>(){

            public String apply(Pair<Integer, Integer> offsetLength) {
                Integer n = (Integer)offsetLength.getKey();
                Integer n2 = (Integer)offsetLength.getValue();
                int n3 = n + n2;
                String string = CCStringIndentation.this.ccString.substring((Integer)offsetLength.getKey(), n3);
                return String.valueOf(indent) + string;
            }
        };
        Functions.Function1<String, String> function12 = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return CCStringIndentation.this.replaceLineBreak(it, lineSeparator);
            }
        };
        return IterableExtensions.join((Iterable)ListExtensions.map((List)ListExtensions.map(this.highlight(), (Functions.Function1)function1), (Functions.Function1)function12));
    }

    public boolean canRemoveEditorIndentation() {
        return this.splittedLines.size() >= 2 && this.ignoreFirst && this.hasConsistentIndentation();
    }

    public String replaceEditorIndentation(String indentation, final String lineSeparator) {
        String string = null;
        if (indentation != null && this.canRemoveEditorIndentation()) {
            String string2;
            String string3 = null;
            String string4 = null;
            if (this.ignoreFirst && this.splittedLines.size() > 2) {
                String string5 = null;
                if (lineSeparator != null) {
                    string5 = lineSeparator;
                } else {
                    string2 = (String)IterableExtensions.head(this.splittedLines);
                    String string6 = null;
                    if (string2 != null) {
                        string6 = CCStringIndentation.firstLineSeparator(string2);
                    }
                    string5 = string6;
                }
                string4 = string5;
            } else {
                string4 = "";
            }
            String addFirstLine = string4;
            string2 = this.removeEditorWhiteSpace(indentation, lineSeparator);
            string = string3 = String.valueOf(addFirstLine) + string2;
        } else {
            String string7 = null;
            ArrayList arrayList = CollectionLiterals.newArrayList((Object[])((String[])Conversions.unwrapArray(this.splittedLines, String.class)));
            Procedures.Procedure1<ArrayList<String>> procedure1 = new Procedures.Procedure1<ArrayList<String>>(){

                public void apply(ArrayList<String> it) {
                    if (CCStringIndentation.this.ignoreFirst) {
                        it.set(0, CCStringIndentation.firstLineSeparator((String)IterableExtensions.head(it)));
                    }
                    if (CCStringIndentation.this.ignoreLast) {
                        int n = it.size();
                        int n2 = n - 1;
                        it.remove(n2);
                    }
                }
            };
            ArrayList lines = (ArrayList)ObjectExtensions.operator_doubleArrow((Object)arrayList, (Procedures.Procedure1)procedure1);
            Functions.Function1<String, String> function1 = new Functions.Function1<String, String>(){

                public String apply(String it) {
                    return CCStringIndentation.this.replaceLineBreak(it, lineSeparator);
                }
            };
            string = string7 = IterableExtensions.join((Iterable)ListExtensions.map((List)lines, (Functions.Function1)function1));
        }
        return string;
    }

    private String replaceLineBreak(String line, String newLineSeparator) {
        String string = null;
        if (newLineSeparator != null && Strings.countLineBreaks((CharSequence)line) > 0) {
            CharSequence charSequence = Strings.trimTrailingLineBreak((CharSequence)line);
            string = charSequence + newLineSeparator;
        } else {
            string = line;
        }
        return string;
    }

    public List<Pair<Integer, Integer>> highlight() {
        ArrayList offsetLengthLines = CollectionLiterals.newArrayList();
        String editorIndent = this.computeEditorIndent(false);
        int skip = editorIndent.length();
        int offset = 0;
        int i = 0;
        while (i < ((Object[])Conversions.unwrapArray(this.splittedLines, Object.class)).length) {
            int n;
            String line = (String)this.splittedLines.get(i);
            if (i == 0 && this.ignoreFirst) {
                int n2 = offset;
                n = line.length();
                offset = n2 + n;
            } else if (i != this.splittedLines.size() - 1 || !this.ignoreLast) {
                int n3;
                int n4;
                Pair pair = null;
                n = line.startsWith(editorIndent) ? 1 : 0;
                if (n != 0) {
                    n4 = line.length();
                    n3 = n4 - skip;
                    pair = Pair.of((Object)(offset + skip), (Object)n3);
                } else {
                    n4 = line.length();
                    pair = Pair.of((Object)offset, (Object)n4);
                }
                offsetLengthLines.add(pair);
                n4 = offset;
                n3 = line.length();
                offset = n4 + n3;
            }
            ++i;
        }
        return offsetLengthLines;
    }

    public boolean hasConsistentIndentation() {
        String string = this.computeEditorIndent(true);
        return string != null;
    }

    protected String computeEditorIndent(boolean consistentOnly) {
        Functions.Function1<Iterable<String>, String> function1;
        String string = null;
        if (this.splittedLines.size() <= 1 || !this.ignoreFirst) {
            return "";
        }
        List list = null;
        int n = 0;
        n = this.ignoreFirst ? 1 : 0;
        int begin = n;
        int n2 = this.splittedLines.size();
        int n3 = 0;
        n3 = this.ignoreLast ? 1 : 0;
        int end = n2 - n3;
        Functions.Function1<String, String> function12 = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return Strings.trimTrailingLineBreak((CharSequence)it).toString();
            }
        };
        Object object = new Functions.Function1<String, Pair<String, String>>(){

            public Pair<String, String> apply(String line) {
                String string = Strings.getLeadingWhiteSpace((String)line);
                return Pair.of((Object)string, (Object)line);
            }
        };
        List wsLinePairs = list = IterableExtensions.toList((Iterable)ListExtensions.map(ListExtensions.map(this.splittedLines, (Functions.Function1)function12).subList(begin, end), (Functions.Function1)object));
        Functions.Function1<Iterable<String>, String> minWSComputor = function1 = new Functions.Function1<Iterable<String>, String>(){

            public String apply(Iterable<String> it) {
                String string = null;
                boolean bl = IterableExtensions.isEmpty(it);
                string = bl ? "" : (String)((Object)IterableExtensions.min(it));
                return string;
            }
        };
        Functions.Function1<Pair<String, String>, Boolean> function13 = new Functions.Function1<Pair<String, String>, Boolean>(){

            public Boolean apply(Pair<String, String> it) {
                boolean bl = ((String)it.getValue()).trim().isEmpty();
                return !bl;
            }
        };
        Functions.Function1<Pair<String, String>, String> function14 = new Functions.Function1<Pair<String, String>, String>(){

            public String apply(Pair<String, String> it) {
                return (String)it.getKey();
            }
        };
        final String textIndent = (String)minWSComputor.apply((Object)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)wsLinePairs, (Functions.Function1)function13), (Functions.Function1)function14));
        object = new Functions.Function1<Pair<String, String>, String>(){

            public String apply(Pair<String, String> it) {
                return (String)it.getKey();
            }
        };
        Functions.Function1<String, Boolean> function15 = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                boolean bl = it.isEmpty();
                return !bl;
            }
        };
        Functions.Function1<String, Boolean> function16 = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String nonEmptyIndent) {
                return nonEmptyIndent.startsWith(textIndent);
            }
        };
        boolean consistent = IterableExtensions.forall((Iterable)IterableExtensions.filter((Iterable)ListExtensions.map((List)wsLinePairs, (Functions.Function1)object), (Functions.Function1)function15), (Functions.Function1)function16);
        String string2 = null;
        boolean bl = false;
        if (consistent) {
            bl = true;
            string2 = textIndent;
        }
        if (!bl && consistentOnly) {
            bl = true;
            string2 = null;
        }
        if (!bl) {
            Functions.Function1<Pair<String, String>, String> function17 = new Functions.Function1<Pair<String, String>, String>(){

                public String apply(Pair<String, String> it) {
                    return (String)it.getKey();
                }
            };
            Functions.Function1<String, Boolean> function18 = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String it) {
                    boolean bl = it.isEmpty();
                    return !bl;
                }
            };
            string2 = (String)minWSComputor.apply((Object)IterableExtensions.filter((Iterable)ListExtensions.map((List)wsLinePairs, (Functions.Function1)function17), (Functions.Function1)function18));
        }
        string = string2;
        return string;
    }

    @Pure
    public ImmutableList<String> getSplittedLines() {
        return this.splittedLines;
    }

    @Pure
    public boolean isIgnoreFirst() {
        return this.ignoreFirst;
    }

    @Pure
    public boolean isIgnoreLast() {
        return this.ignoreLast;
    }
}

