/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.postprocessing;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.etrice.core.common.postprocessing.PostprocessingHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.GeneratedMetamodel;

public class DocuPostprocessor {
    public void process(GeneratedMetamodel metamodel) {
        EPackage pckg = metamodel.getEPackage();
        EClass cls = PostprocessingHelpers.getClass(pckg, "Import");
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("The import declares an imported {@link org.eclipse.etrice.core.room.RoomModel room model} (given as a URI) and");
        stringConcatenation.newLine();
        stringConcatenation.append("an optional imported namespace.");
        stringConcatenation.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, stringConcatenation.toString());
        EAttribute eAttribute = PostprocessingHelpers.getAttribute(cls, "importedNamespace");
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("The imported name space has to be a dot separated qualified name followed by .*.");
        stringConcatenation2.newLine();
        stringConcatenation2.append("Example: my.namespace.*");
        stringConcatenation2.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute, stringConcatenation2.toString());
        EAttribute eAttribute2 = PostprocessingHelpers.getAttribute(cls, "importURI");
        StringConcatenation stringConcatenation3 = new StringConcatenation();
        stringConcatenation3.append("The import URI can be a relative or absolute file system path.");
        stringConcatenation3.newLine();
        stringConcatenation3.append("It may contain environment variables in ${} which will be expanded.");
        stringConcatenation3.newLine();
        stringConcatenation3.append("<p>");
        stringConcatenation3.newLine();
        stringConcatenation3.append("Examples:");
        stringConcatenation3.newLine();
        stringConcatenation3.append("<ul>");
        stringConcatenation3.newLine();
        stringConcatenation3.append("  ");
        stringConcatenation3.append("<li>import model \"AnotherModel.room\"</li>");
        stringConcatenation3.newLine();
        stringConcatenation3.append("  ");
        stringConcatenation3.append("<li>import my.namespace.* from \"AnotherModel.room\"</li>");
        stringConcatenation3.newLine();
        stringConcatenation3.append("  ");
        stringConcatenation3.append("<li>import my.namespace.* from \"../../AnotherProject/models/AnotherModel.room\"</li>");
        stringConcatenation3.newLine();
        stringConcatenation3.append("  ");
        stringConcatenation3.append("<li>import my.namespace.* from \"/${ROOM_MODELS}/SomeModel.room\"</li>");
        stringConcatenation3.newLine();
        stringConcatenation3.append("</ul>");
        stringConcatenation3.newLine();
        stringConcatenation3.append("</p>");
        stringConcatenation3.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute2, stringConcatenation3.toString());
        cls = PostprocessingHelpers.getClass(pckg, "LiteralArray");
        StringConcatenation stringConcatenation4 = new StringConcatenation();
        stringConcatenation4.append("Aggregates one or more {@link Literal literals}.\t\t");
        stringConcatenation4.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, stringConcatenation4.toString());
        EReference eReference = PostprocessingHelpers.getReference(cls, "literals");
        StringConcatenation stringConcatenation5 = new StringConcatenation();
        stringConcatenation5.append("This is a list of literals.");
        stringConcatenation5.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference, stringConcatenation5.toString());
        cls = PostprocessingHelpers.getClass(pckg, "Literal");
        StringConcatenation stringConcatenation6 = new StringConcatenation();
        stringConcatenation6.append("It is the super class of");
        stringConcatenation6.newLine();
        stringConcatenation6.append("<ul>");
        stringConcatenation6.newLine();
        stringConcatenation6.append("\t");
        stringConcatenation6.append("<li>{@link BooleanLiteral}</li>");
        stringConcatenation6.newLine();
        stringConcatenation6.append("\t");
        stringConcatenation6.append("<li>{@link NumberLiteral}</li>");
        stringConcatenation6.newLine();
        stringConcatenation6.append("\t");
        stringConcatenation6.append("<li>{@link StringLiteral}</li>");
        stringConcatenation6.newLine();
        stringConcatenation6.append("</ul>");
        stringConcatenation6.newLine();
        stringConcatenation6.append("that represents a primitive value.");
        stringConcatenation6.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, stringConcatenation6.toString());
        cls = PostprocessingHelpers.getClass(pckg, "Documentation");
        StringConcatenation stringConcatenation7 = new StringConcatenation();
        stringConcatenation7.append("A piece of documentation that can be optionally attached at");
        stringConcatenation7.newLine();
        stringConcatenation7.append("certain places in the model.");
        stringConcatenation7.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, stringConcatenation7.toString());
        EAttribute eAttribute3 = PostprocessingHelpers.getAttribute(cls, "lines");
        StringConcatenation stringConcatenation8 = new StringConcatenation();
        stringConcatenation8.append("This is the documentation's contents.");
        stringConcatenation8.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute3, stringConcatenation8.toString());
        cls = PostprocessingHelpers.getClass(pckg, "Annotation");
        StringConcatenation stringConcatenation9 = new StringConcatenation();
        stringConcatenation9.append("An annotation similar to Java annotations that can be used");
        stringConcatenation9.newLine();
        stringConcatenation9.append("to add {@link KeyValue} pairs to certain model items. The structure ");
        stringConcatenation9.newLine();
        stringConcatenation9.append("of Annotations are defined by {@link AnnotationType}s.");
        stringConcatenation9.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, stringConcatenation9.toString());
        EReference eReference2 = PostprocessingHelpers.getReference(cls, "type");
        StringConcatenation stringConcatenation10 = new StringConcatenation();
        stringConcatenation10.append("The {@link AnnotationType} that defines the structure of ");
        stringConcatenation10.newLine();
        stringConcatenation10.append("the annotation.");
        stringConcatenation10.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference2, stringConcatenation10.toString());
        EReference eReference3 = PostprocessingHelpers.getReference(cls, "attributes");
        StringConcatenation stringConcatenation11 = new StringConcatenation();
        stringConcatenation11.append("This is a list of key/value pairs.");
        stringConcatenation11.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference3, stringConcatenation11.toString());
        cls = PostprocessingHelpers.getClass(pckg, "KeyValue");
        StringConcatenation stringConcatenation12 = new StringConcatenation();
        stringConcatenation12.append("A key/value pair.");
        stringConcatenation12.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, stringConcatenation12.toString());
        EAttribute eAttribute4 = PostprocessingHelpers.getAttribute(cls, "key");
        StringConcatenation stringConcatenation13 = new StringConcatenation();
        stringConcatenation13.append("This is the key of the pair.");
        stringConcatenation13.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute4, stringConcatenation13.toString());
        EReference eReference4 = PostprocessingHelpers.getReference(cls, "value");
        StringConcatenation stringConcatenation14 = new StringConcatenation();
        stringConcatenation14.append("This is the value of the pair.");
        stringConcatenation14.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eReference4, stringConcatenation14.toString());
        cls = PostprocessingHelpers.getClass(pckg, "AnnotationType");
        StringConcatenation stringConcatenation15 = new StringConcatenation();
        stringConcatenation15.append("Defines the structure of {@link Annotation}s.");
        PostprocessingHelpers.setDocumentation((EModelElement)cls, stringConcatenation15.toString());
        EAttribute eAttribute5 = PostprocessingHelpers.getAttribute(cls, "name");
        StringConcatenation stringConcatenation16 = new StringConcatenation();
        stringConcatenation16.append("The name of the AnnotationType");
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute5, stringConcatenation16.toString());
        EAttribute eAttribute6 = PostprocessingHelpers.getAttribute(cls, "targets");
        StringConcatenation stringConcatenation17 = new StringConcatenation();
        stringConcatenation17.append("A list of names representing the locations in which ");
        stringConcatenation17.newLine();
        stringConcatenation17.append("\t\t\t");
        stringConcatenation17.append("{@link Annotation}s of this AnnotationType can occur");
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute6, stringConcatenation17.toString());
        EReference eReference5 = PostprocessingHelpers.getReference(cls, "docu");
        StringConcatenation stringConcatenation18 = new StringConcatenation();
        stringConcatenation18.append("Optional model-level documentation");
        PostprocessingHelpers.setDocumentation((EModelElement)eReference5, stringConcatenation18.toString());
        EReference eReference6 = PostprocessingHelpers.getReference(cls, "attributes");
        StringConcatenation stringConcatenation19 = new StringConcatenation();
        stringConcatenation19.append("Defines the {@link AnnotationAttribute}s that are required or allowed in ");
        stringConcatenation19.newLine();
        stringConcatenation19.append("\t\t\t");
        stringConcatenation19.append("{@link Annotation} instances of this AnnotationType");
        PostprocessingHelpers.setDocumentation((EModelElement)eReference6, stringConcatenation19.toString());
        cls = PostprocessingHelpers.getClass(pckg, "AnnotationAttribute");
        StringConcatenation stringConcatenation20 = new StringConcatenation();
        stringConcatenation20.append("Defines an attribute in an {@link AnnotationType}. This attribute ");
        stringConcatenation20.newLine();
        stringConcatenation20.append("\t\t\t");
        stringConcatenation20.append("can then be declared in respective {@link Annotation} instances.");
        PostprocessingHelpers.setDocumentation((EModelElement)cls, stringConcatenation20.toString());
        EAttribute eAttribute7 = PostprocessingHelpers.getAttribute(cls, "optional");
        StringConcatenation stringConcatenation21 = new StringConcatenation();
        stringConcatenation21.append("Specifies whether the attribute should be optional or not. If the ");
        stringConcatenation21.newLine();
        stringConcatenation21.append("\t\t\t");
        stringConcatenation21.append("attribute is optional, it can be omitted by {@link Annotation}s of ");
        stringConcatenation21.newLine();
        stringConcatenation21.append("\t\t\t");
        stringConcatenation21.append("the same {@link AnnotationType}.");
        stringConcatenation21.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute7, stringConcatenation21.toString());
        EAttribute eAttribute8 = PostprocessingHelpers.getAttribute(cls, "name");
        StringConcatenation stringConcatenation22 = new StringConcatenation();
        stringConcatenation22.append("The name of the attribute");
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute8, stringConcatenation22.toString());
        cls = PostprocessingHelpers.getClass(pckg, "SimpleAnnotationAttribute");
        StringConcatenation stringConcatenation23 = new StringConcatenation();
        stringConcatenation23.append("An {@link AnnotationAttribute} that is associated with a ");
        stringConcatenation23.newLine();
        stringConcatenation23.append("\t\t\t");
        stringConcatenation23.append("{@link LiteralType}.");
        PostprocessingHelpers.setDocumentation((EModelElement)cls, stringConcatenation23.toString());
        EAttribute eAttribute9 = PostprocessingHelpers.getAttribute(cls, "type");
        StringConcatenation stringConcatenation24 = new StringConcatenation();
        stringConcatenation24.append("The type of the attribute");
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute9, stringConcatenation24.toString());
        cls = PostprocessingHelpers.getClass(pckg, "EnumAnnotationAttribute");
        StringConcatenation stringConcatenation25 = new StringConcatenation();
        stringConcatenation25.append("An {@link AnnotationAttribute} whose possible values are defined ");
        stringConcatenation25.newLine();
        stringConcatenation25.append("\t\t\t");
        stringConcatenation25.append("by a list of String values.");
        PostprocessingHelpers.setDocumentation((EModelElement)cls, stringConcatenation25.toString());
        EAttribute eAttribute10 = PostprocessingHelpers.getAttribute(cls, "values");
        StringConcatenation stringConcatenation26 = new StringConcatenation();
        stringConcatenation26.append("A list of values that define the enumeration");
        PostprocessingHelpers.setDocumentation((EModelElement)eAttribute10, stringConcatenation26.toString());
    }
}

