/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.genmodel.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.etrice.core.genmodel.etricegen.ETriceGenFactory;
import org.eclipse.etrice.core.genmodel.etricegen.OpenBinding;
import org.eclipse.etrice.core.genmodel.etricegen.OpenServiceConnection;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.Wire;
import org.eclipse.etrice.core.genmodel.etricegen.WiredActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.WiredStructureClass;
import org.eclipse.etrice.core.genmodel.etricegen.WiredSubSystemClass;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefSAPoint;
import org.eclipse.etrice.core.room.ReferenceType;
import org.eclipse.etrice.core.room.RelaySAPoint;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;

public class Wiring {
    private RoomHelpers roomHelpers = new RoomHelpers();
    private static final String SEP = "#";
    private Root root;
    private HashMap<ActorClass, WiredActorClass> handled = new HashMap();

    public Wiring(Root root) {
        this.root = root;
    }

    public void createWiredClasses() {
        for (ActorClass ac2 : this.root.getActorClasses()) {
            this.getWiredActorClass(ac2);
        }
        for (RoomModel model : this.root.getImportedModels()) {
            this.roomHelpers.getRoomClasses(model, ActorClass.class).forEach(ac -> {
                WiredActorClass wiredActorClass = this.getWiredActorClass((ActorClass)ac);
            });
        }
        for (SubSystemClass ssc : this.root.getSubSystemClasses()) {
            this.createWiredSubSystemClass(ssc);
        }
    }

    private WiredActorClass createWiredActorClass(ActorClass ac) {
        WiredActorClass wired = ETriceGenFactory.eINSTANCE.createWiredActorClass();
        wired.setActorClass(ac);
        this.wireBindings(wired, this.roomHelpers.getAllBindings(ac));
        this.wireServices(wired, this.roomHelpers.getAllActorContainerRefs((StructureClass)ac), this.roomHelpers.getAllLayerConnections(ac), this.roomHelpers.getAllSAPs(ac), this.roomHelpers.getAllServiceImplementations(ac));
        this.handled.put(ac, wired);
        this.root.getWiredInstances().add((Object)wired);
        return wired;
    }

    private WiredSubSystemClass createWiredSubSystemClass(SubSystemClass ssc) {
        WiredSubSystemClass wired = ETriceGenFactory.eINSTANCE.createWiredSubSystemClass();
        wired.setSubSystemClass(ssc);
        this.wireBindings(wired, (List<Binding>)ssc.getBindings());
        this.wireServices(wired, this.roomHelpers.getAllActorContainerRefs((StructureClass)ssc), (List<LayerConnection>)ssc.getConnections(), null, null);
        this.root.getWiredInstances().add((Object)wired);
        return wired;
    }

    private WiredActorClass getWiredActorClass(ActorClass ac) {
        WiredActorClass cls = this.handled.get(ac);
        if (cls != null) {
            return cls;
        }
        return this.createWiredActorClass(ac);
    }

    private void wireBindings(WiredStructureClass wired, List<Binding> bindings) {
        HashMap<String, EndPointCreator> epkey2creator = new HashMap<String, EndPointCreator>();
        for (Binding binding : bindings) {
            int r2;
            EndPointCreator epc1 = this.getEndPointCreator(binding.getEndpoint1(), epkey2creator);
            EndPointCreator epc2 = this.getEndPointCreator(binding.getEndpoint2(), epkey2creator);
            int n = this.getMultiplicity(binding);
            int r1 = epc1.remaining();
            if (r1 >= 0) {
                n = Math.min(n, r1);
            }
            if ((r2 = epc2.remaining()) >= 0) {
                n = Math.min(n, r2);
            }
            int i = 0;
            while (i < n) {
                EndPoint ep1 = epc1.createEndPoint();
                EndPoint ep2 = epc2.createEndPoint();
                if (ep1 != null && ep2 != null) {
                    if (ep1.getActorRef() == null) {
                        this.handleBindingToLocal(wired, ep1, ep2);
                    } else if (ep2.getActorRef() == null) {
                        this.handleBindingToLocal(wired, ep2, ep1);
                    } else {
                        this.handleBindingBetweenRefs(wired, ep1, ep2);
                    }
                }
                ++i;
            }
        }
    }

    private EndPointCreator getEndPointCreator(BindingEndPoint ep, HashMap<String, EndPointCreator> epkey2creator) {
        String key = Wiring.getEndPointKey(ep);
        EndPointCreator creator = epkey2creator.get(key);
        if (creator == null) {
            creator = new EndPointCreator(ep, this.roomHelpers);
            epkey2creator.put(key, creator);
        }
        return creator;
    }

    private int getMultiplicity(Binding binding) {
        int m1 = this.getMultiplicity(binding.getEndpoint1());
        int m2 = this.getMultiplicity(binding.getEndpoint2());
        return Math.max(m1, m2);
    }

    private int getMultiplicity(BindingEndPoint ep) {
        if (ep.getActorRef() instanceof ActorRef && ((ActorRef)ep.getActorRef()).getRefType() == ReferenceType.FIXED) {
            return ((ActorRef)ep.getActorRef()).getMultiplicity();
        }
        return 1;
    }

    private void handleBindingBetweenRefs(WiredStructureClass wired, EndPoint ep1, EndPoint ep2) {
        List<String> path2;
        List<String> path1 = this.getPath(ep1);
        if (path1 != null && (path2 = this.getPath(ep2)) != null) {
            Wire wire = ETriceGenFactory.eINSTANCE.createWire();
            wire.setDataDriven(this.roomHelpers.isDataDriven((InterfaceItem)ep1.port) && this.roomHelpers.isDataDriven((InterfaceItem)ep2.port));
            wire.getPath1().addAll(path1);
            wire.getPath2().addAll(path2);
            wired.getWires().add((Object)wire);
        }
    }

    private List<String> getPath(EndPoint ep) {
        assert (ep.getActorRef() != null) : "endpoint expected on ref";
        assert (ep.getActorRef() instanceof ActorRef) : "ActorRef expected";
        ActorRef ar = (ActorRef)ep.getActorRef();
        if (ar.getRefType() == ReferenceType.FIXED && this.roomHelpers.isRelay(ep.getPort())) {
            OpenBinding open = this.getOpenBinding(ep);
            if (open != null) {
                ArrayList<String> path = new ArrayList<String>();
                path.add(ep.getRefName());
                path.addAll((Collection<String>)open.getPath());
                return path;
            }
            return null;
        }
        ArrayList<String> path = new ArrayList<String>();
        path.add(ep.getRefName());
        path.add(ep.getPortName());
        return path;
    }

    private OpenBinding getOpenBinding(EndPoint ep) {
        assert (ep.getActorRef() != null) : "endpoint expected on ref";
        ActorRef ref = (ActorRef)ep.getActorRef();
        WiredActorClass wiredRef = this.getWiredActorClass(ref.getType());
        for (OpenBinding ob : wiredRef.getOpenBindings()) {
            if (ob.getPort() != ep.getPort()) continue;
            return ob;
        }
        return null;
    }

    private void handleBindingToLocal(WiredStructureClass wired, EndPoint localEnd, EndPoint refEnd) {
        List<String> refPath = this.getPath(refEnd);
        if (refPath != null) {
            if (this.roomHelpers.isRelay(localEnd.getPort())) {
                OpenBinding myOpen = ETriceGenFactory.eINSTANCE.createOpenBinding();
                myOpen.getPath().addAll(refPath);
                myOpen.setPort(localEnd.getPort());
                wired.getOpenBindings().add((Object)myOpen);
            } else {
                Wire wire = ETriceGenFactory.eINSTANCE.createWire();
                wire.setDataDriven(this.roomHelpers.isDataDriven((InterfaceItem)localEnd.port) && this.roomHelpers.isDataDriven((InterfaceItem)refEnd.port));
                wire.getPath1().addAll(refPath);
                wire.getPath2().add((Object)localEnd.getPortName());
                wired.getWires().add((Object)wire);
            }
        }
    }

    private void wireServices(WiredStructureClass wired, List<ActorContainerRef> refs, List<LayerConnection> connections, List<SAP> allSAPs, List<ServiceImplementation> allServiceImplementations) {
        OpenServiceConnection osc;
        if (allServiceImplementations != null) {
            for (ServiceImplementation svcImpl : allServiceImplementations) {
                if (svcImpl.getSpp() == null) continue;
                osc = ETriceGenFactory.eINSTANCE.createOpenServiceConnection();
                osc.setProtocol(svcImpl.getSpp().getProtocol());
                osc.getPath().add((Object)svcImpl.getSpp().getName());
                wired.getProvidedServices().add((Object)osc);
            }
        }
        if (allSAPs != null) {
            for (SAP sap : allSAPs) {
                osc = ETriceGenFactory.eINSTANCE.createOpenServiceConnection();
                osc.setProtocol(sap.getProtocol());
                osc.getPath().add((Object)sap.getName());
                wired.getRequiredServices().add((Object)osc);
            }
        }
        HashSet<OpenServiceConnection> satisfied = new HashSet<OpenServiceConnection>();
        block2: for (LayerConnection conn : connections) {
            RefSAPoint from;
            if (conn.getFrom() instanceof RefSAPoint) {
                ActorRef reqRef;
                WiredActorClass requestor;
                from = (RefSAPoint)conn.getFrom();
                if (!(from.getRef() instanceof ActorRef) || !(conn.getTo().getRef() instanceof ActorRef) || (requestor = this.getWiredActorClass((reqRef = (ActorRef)from.getRef()).getType())).getRequiredServices().isEmpty()) continue;
                Iterator prvRef = (ActorRef)conn.getTo().getRef();
                WiredActorClass provider = this.getWiredActorClass(prvRef.getType());
                for (OpenServiceConnection prv : provider.getProvidedServices()) {
                    if (conn.getTo().getService().getProtocol() != prv.getProtocol()) continue;
                    for (OpenServiceConnection req : requestor.getRequiredServices()) {
                        if (req.getProtocol() != prv.getProtocol()) continue;
                        Wire wire = ETriceGenFactory.eINSTANCE.createWire();
                        wire.setDataDriven(this.roomHelpers.isDataDriven((InterfaceItem)conn.getTo().getService()));
                        wire.getPath1().add((Object)prvRef.getName());
                        wire.getPath1().addAll(prv.getPath());
                        wire.getPath2().add((Object)reqRef.getName());
                        wire.getPath2().addAll(req.getPath());
                        wired.getWires().add((Object)wire);
                        satisfied.add(req);
                    }
                    continue block2;
                }
                continue;
            }
            if (conn.getFrom() instanceof RelaySAPoint) {
                from = (RelaySAPoint)conn.getFrom();
                WiredActorClass sub = this.getWiredActorClass(((ActorRef)conn.getTo().getRef()).getType());
                for (OpenServiceConnection prv : sub.getProvidedServices()) {
                    if (prv.getProtocol() != from.getRelay().getProtocol()) continue;
                    OpenServiceConnection osc2 = ETriceGenFactory.eINSTANCE.createOpenServiceConnection();
                    osc2.setProtocol(prv.getProtocol());
                    osc2.getPath().add((Object)conn.getTo().getRef().getName());
                    osc2.getPath().addAll(prv.getPath());
                    wired.getProvidedServices().add((Object)osc2);
                    continue block2;
                }
                continue;
            }
            assert (false) : "unexpected sub type";
        }
        for (ActorContainerRef ref : refs) {
            WiredStructureClass sub = null;
            if (ref instanceof ActorRef && ((ActorRef)ref).getRefType() == ReferenceType.FIXED) {
                sub = this.getWiredActorClass(((ActorRef)ref).getType());
            }
            if (sub == null) continue;
            for (OpenServiceConnection req : sub.getRequiredServices()) {
                if (satisfied.contains(req)) continue;
                OpenServiceConnection osc3 = ETriceGenFactory.eINSTANCE.createOpenServiceConnection();
                osc3.setProtocol(req.getProtocol());
                osc3.getPath().add((Object)ref.getName());
                osc3.getPath().addAll(req.getPath());
                wired.getRequiredServices().add((Object)osc3);
            }
        }
    }

    private static String getEndPointKey(BindingEndPoint ep) {
        return Wiring.getEndPointKey(ep.getActorRef(), ep.getPort());
    }

    private static String getEndPointKey(ActorContainerRef ref, Port port) {
        return ref == null ? SEP + port.getName() : String.valueOf(ref.getName()) + SEP + port.getName();
    }

    private static class EndPoint {
        ActorContainerRef ref;
        Port port;
        int ridx = 0;

        public EndPoint(ActorContainerRef ref, Port port, int ridx) {
            this.ref = ref;
            this.port = port;
            this.ridx = ridx;
        }

        String getPortName() {
            return this.port.getName();
        }

        String getRefName() {
            if (this.ridx >= 0) {
                return String.valueOf(this.ref.getName()) + ':' + this.ridx;
            }
            return this.ref.getName();
        }

        public ActorContainerRef getActorRef() {
            return this.ref;
        }

        public Port getPort() {
            return this.port;
        }
    }

    private static class EndPointCreator {
        ActorContainerRef ref;
        Port port;
        int rsize = 1;
        int ridx = 0;
        int psize;
        int pidx = 0;

        public EndPointCreator(BindingEndPoint ep, RoomHelpers roomHelpers) {
            this(ep.getActorRef(), ep.getPort(), roomHelpers);
        }

        public EndPointCreator(ActorContainerRef ref, Port port, RoomHelpers roomHelpers) {
            ProtocolClass pc;
            boolean implicitMany;
            this.ref = ref;
            this.port = port;
            this.psize = port.getMultiplicity();
            if (ref instanceof ActorRef) {
                ActorRef ar = (ActorRef)ref;
                this.rsize = ar.getMultiplicity();
            }
            boolean bl = implicitMany = (pc = port.getProtocol()).getCommType() == CommunicationType.DATA_DRIVEN;
            if (implicitMany) {
                this.psize = -1;
            }
        }

        EndPoint createEndPoint() {
            if (this.psize > 0 && this.pidx >= this.psize) {
                return null;
            }
            if (this.rsize > 0 && this.ridx >= this.rsize) {
                return null;
            }
            if (this.rsize == 1) {
                ++this.pidx;
                EndPoint ep = new EndPoint(this.ref, this.port, -1);
                return ep;
            }
            if (this.rsize < 0) {
                EndPoint ep = new EndPoint(this.ref, this.port, -1);
                return ep;
            }
            EndPoint ep = new EndPoint(this.ref, this.port, this.ridx);
            ++this.pidx;
            if (this.pidx >= this.psize && this.ridx < this.rsize) {
                ++this.ridx;
                this.pidx = 0;
            }
            return ep;
        }

        public int remaining() {
            if (this.psize > 0 && this.pidx >= this.psize) {
                return 0;
            }
            if (this.rsize > 0 && this.ridx >= this.rsize) {
                return 0;
            }
            if (this.rsize == 1) {
                if (this.psize < 0) {
                    return -1;
                }
                return this.psize - this.pidx;
            }
            if (this.rsize < 0) {
                return -1;
            }
            return (this.rsize - this.ridx - 1) * this.psize + (this.psize - this.pidx);
        }
    }
}

