/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.fsm.support;

import com.google.inject.Injector;
import java.util.ArrayList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.fsm.fSM.FSMFactory;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.RefinedState;
import org.eclipse.etrice.core.fsm.fSM.SimpleState;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateGraphItem;
import org.eclipse.etrice.core.fsm.fSM.StateTerminal;
import org.eclipse.etrice.core.fsm.fSM.TrPoint;
import org.eclipse.etrice.core.fsm.fSM.TransitionTerminal;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.IFSMDialogFactory;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.IStatePropertyDialog;
import org.eclipse.etrice.ui.behavior.fsm.editor.AbstractFSMEditor;
import org.eclipse.etrice.ui.behavior.fsm.editor.DecoratorUtil;
import org.eclipse.etrice.ui.behavior.fsm.provider.IInjectorProvider;
import org.eclipse.etrice.ui.behavior.fsm.support.ContextSwitcher;
import org.eclipse.etrice.ui.behavior.fsm.support.QuickFixFeature;
import org.eclipse.etrice.ui.behavior.fsm.support.util.DiagramEditingUtil;
import org.eclipse.etrice.ui.behavior.fsm.support.util.FSMSupportUtil;
import org.eclipse.etrice.ui.behavior.fsm.support.util.ModelEditingUtil;
import org.eclipse.etrice.ui.common.base.support.ChangeAwareCreateFeature;
import org.eclipse.etrice.ui.common.base.support.ChangeAwareCustomFeature;
import org.eclipse.etrice.ui.common.base.support.CommonSupportUtil;
import org.eclipse.etrice.ui.common.base.support.DeleteWithoutConfirmFeature;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.features.impl.AbstractLayoutFeature;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.DefaultMoveShapeFeature;
import org.eclipse.graphiti.features.impl.DefaultRemoveFeature;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IDecorator;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.tb.ImageDecorator;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class StateSupport {
    private static final int LINE_WIDTH = 1;
    public static final int DEFAULT_SIZE_X = 60;
    public static final int DEFAULT_SIZE_Y = 30;
    public static final int MIN_SIZE_X = 60;
    public static final int MIN_SIZE_Y = 30;
    public static final int MARGIN = 30;
    public static final int CORNER_WIDTH = 20;
    public static final int HINT_CORNER_WIDTH = 5;
    private static final int TEXT_MARGIN = 10;
    public static final IColorConstant LINE_COLOR = new ColorConstant(0, 0, 0);
    public static final IColorConstant INHERITED_COLOR = new ColorConstant(100, 100, 100);
    private static final IColorConstant BACKGROUND = new ColorConstant(200, 200, 200);
    private static final IColorConstant INHERITED_BACKGROUND = new ColorConstant(230, 230, 230);
    private FeatureProvider pfp;
    private BehaviorProvider tbp;

    public StateSupport(IDiagramTypeProvider dtp, IFeatureProvider fp) {
        this.pfp = new FeatureProvider(dtp, fp);
        this.tbp = new BehaviorProvider(dtp);
    }

    public IFeatureProvider getFeatureProvider() {
        return this.pfp;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.tbp;
    }

    private static void addHints(State s, RoundedRectangle border, Color lineColor) {
        int x = border.getWidth() - 25;
        int y = 3;
        IGaService gaService = Graphiti.getGaService();
        RoundedRectangle hint = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)border, 5, 5);
        hint.setForeground(lineColor);
        hint.setFilled(Boolean.valueOf(false));
        hint.setLineWidth(Integer.valueOf(1));
        gaService.setLocationAndSize((GraphicsAlgorithm)hint, x, y, 15, 8);
        ModelComponent mc = FSMSupportUtil.getInstance().getModelComponent(FSMSupportUtil.getInstance().getDiagram((GraphicsAlgorithm)border));
        if (!FSMSupportUtil.getInstance().getFSMHelpers().hasSubStructure(s, mc)) {
            hint.setLineVisible(Boolean.valueOf(false));
        }
        x = border.getWidth() / 2;
        y = border.getHeight() - 6;
        gaService = Graphiti.getGaService();
        int[] xy1 = new int[]{-3, -3, -3, 3, -11, 3};
        Polygon entryHint = gaService.createPolygon((GraphicsAlgorithmContainer)border, xy1);
        entryHint.setForeground(lineColor);
        entryHint.setFilled(Boolean.valueOf(false));
        entryHint.setLineWidth(Integer.valueOf(1));
        gaService.setLocation((GraphicsAlgorithm)entryHint, x, y);
        int[] xy2 = new int[]{3, -3, 3, 3, 11, 3};
        Polygon exitHint = gaService.createPolygon((GraphicsAlgorithmContainer)border, xy2);
        exitHint.setForeground(lineColor);
        exitHint.setFilled(Boolean.valueOf(false));
        exitHint.setLineWidth(Integer.valueOf(1));
        gaService.setLocation((GraphicsAlgorithm)exitHint, x, y);
        int[] xy3 = new int[]{-2, -3, -2, 3, 2, 3, 2, -3};
        Polygon doHint = gaService.createPolygon((GraphicsAlgorithmContainer)border, xy3);
        doHint.setForeground(lineColor);
        doHint.setFilled(Boolean.valueOf(false));
        doHint.setLineWidth(Integer.valueOf(1));
        gaService.setLocation((GraphicsAlgorithm)doHint, x, y);
        if (!FSMSupportUtil.getInstance().getFSMHelpers().hasEntryCode(s, true)) {
            entryHint.setLineVisible(Boolean.valueOf(false));
        }
        if (!FSMSupportUtil.getInstance().getFSMHelpers().hasExitCode(s, true)) {
            exitHint.setLineVisible(Boolean.valueOf(false));
        }
        if (!FSMSupportUtil.getInstance().getFSMHelpers().hasDoCode(s, true)) {
            doHint.setLineVisible(Boolean.valueOf(false));
        }
    }

    protected static void updateHints(State s, GraphicsAlgorithm border) {
        ModelComponent mc = FSMSupportUtil.getInstance().getModelComponent(FSMSupportUtil.getInstance().getDiagram(border));
        GraphicsAlgorithm hint = (GraphicsAlgorithm)border.getGraphicsAlgorithmChildren().get(0);
        hint.setLineVisible(Boolean.valueOf(FSMSupportUtil.getInstance().getFSMHelpers().hasSubStructure(s, mc)));
        hint = (GraphicsAlgorithm)border.getGraphicsAlgorithmChildren().get(1);
        hint.setLineVisible(Boolean.valueOf(FSMSupportUtil.getInstance().getFSMHelpers().hasEntryCode(s, true)));
        hint = (GraphicsAlgorithm)border.getGraphicsAlgorithmChildren().get(2);
        hint.setLineVisible(Boolean.valueOf(FSMSupportUtil.getInstance().getFSMHelpers().hasExitCode(s, true)));
        hint = (GraphicsAlgorithm)border.getGraphicsAlgorithmChildren().get(3);
        hint.setLineVisible(Boolean.valueOf(FSMSupportUtil.getInstance().getFSMHelpers().hasDoCode(s, true)));
    }

    private class BehaviorProvider
    extends DefaultToolBehaviorProvider {
        public BehaviorProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }

        public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return new GraphicsAlgorithm[]{rectangle};
        }

        public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return rectangle;
        }

        public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
            PictogramElement pe = context.getPictogramElements()[0];
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
            if (bo instanceof State) {
                ModelComponent mc = FSMSupportUtil.getInstance().getModelComponent(FSMSupportUtil.getInstance().getDiagram(pe));
                State s = (State)bo;
                if (!FSMSupportUtil.getInstance().getFSMHelpers().hasSubStructure(s, mc)) {
                    boolean editable = FSMSupportUtil.getInstance().getFSMHelpers().getModelComponent((StateGraphItem)s) == mc;
                    return new FeatureProvider.PropertyFeature(this.getDiagramTypeProvider().getFeatureProvider(), editable);
                }
            }
            return new FeatureProvider.GoDownFeature(this.getDiagramTypeProvider().getFeatureProvider());
        }

        public Object getToolTip(GraphicsAlgorithm ga) {
            PictogramElement pe = ga.getPictogramElement();
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
            if (bo instanceof State) {
                String label = "";
                State s = (State)bo;
                String entry = "";
                if (s instanceof RefinedState) {
                    entry = String.valueOf(entry) + FSMSupportUtil.getInstance().getFSMHelpers().getBaseEntryCode((RefinedState)s);
                }
                if (FSMSupportUtil.getInstance().getFSMHelpers().hasDetailCode(s.getEntryCode())) {
                    entry = String.valueOf(entry) + FSMSupportUtil.getInstance().getFSMHelpers().getDetailCode(s.getEntryCode());
                }
                if (!entry.isEmpty()) {
                    label = String.valueOf(label) + "entry:\n" + entry;
                }
                String exit = "";
                if (FSMSupportUtil.getInstance().getFSMHelpers().hasDetailCode(s.getExitCode())) {
                    exit = String.valueOf(exit) + FSMSupportUtil.getInstance().getFSMHelpers().getDetailCode(s.getExitCode());
                }
                if (s instanceof RefinedState) {
                    exit = String.valueOf(exit) + FSMSupportUtil.getInstance().getFSMHelpers().getBaseExitCode((RefinedState)s);
                }
                if (!exit.isEmpty()) {
                    if (!label.isEmpty()) {
                        label = String.valueOf(label) + "\n";
                    }
                    label = String.valueOf(label) + "exit:\n" + exit;
                }
                String doCode = "";
                if (FSMSupportUtil.getInstance().getFSMHelpers().hasDetailCode(s.getDoCode())) {
                    doCode = String.valueOf(doCode) + "do:\n" + FSMSupportUtil.getInstance().getFSMHelpers().getDetailCode(s.getDoCode());
                }
                if (s instanceof RefinedState) {
                    doCode = String.valueOf(doCode) + FSMSupportUtil.getInstance().getFSMHelpers().getBaseDoCode((RefinedState)s);
                }
                if (!doCode.isEmpty()) {
                    if (!label.isEmpty()) {
                        label = String.valueOf(label) + "\n";
                    }
                    label = String.valueOf(label) + "do:\n" + doCode;
                }
                if (!label.isEmpty()) {
                    return label;
                }
            }
            return super.getToolTip(ga);
        }

        public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
            ICreateConnectionFeature[] features;
            IContextButtonPadData data = super.getContextButtonPad(context);
            PictogramElement pe = context.getPictogramElement();
            CreateConnectionContext ccc = new CreateConnectionContext();
            ccc.setSourcePictogramElement(pe);
            Anchor anchor = null;
            if (pe instanceof AnchorContainer) {
                anchor = (Anchor)((ContainerShape)pe).getAnchors().get(0);
            }
            ccc.setSourceAnchor(anchor);
            ContextButtonEntry button = new ContextButtonEntry(null, (IContext)context);
            button.setText("Create Transition");
            button.setIconId("org.eclipse.etrice.ui.behavior.transition");
            ICreateConnectionFeature[] iCreateConnectionFeatureArray = features = this.getFeatureProvider().getCreateConnectionFeatures();
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                ICreateConnectionFeature feature = iCreateConnectionFeatureArray[n2];
                if (feature.isAvailable((IContext)ccc) && feature.canStartConnection((ICreateConnectionContext)ccc)) {
                    button.addDragAndDropFeature((IFeature)feature);
                }
                ++n2;
            }
            if (button.getDragAndDropFeatures().size() > 0) {
                data.getDomainSpecificContextButtons().add(button);
            }
            return data;
        }

        public IDecorator[] getDecorators(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            int xOrigin = rectangle.getX();
            int yOrigin = rectangle.getY();
            int xGap = 10;
            int yGap = 0;
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
            ArrayList<Diagnostic> diagnostics = ((AbstractFSMEditor)this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer()).getDiagnosingModelObserver().getElementDiagonsticMap().get(bo);
            ArrayList<IDecorator> decorators = DecoratorUtil.getMarkersFromDiagnostics(diagnostics);
            if (decorators.isEmpty()) {
                return super.getDecorators(pe);
            }
            int i = 0;
            for (IDecorator decorator : decorators) {
                ((ImageDecorator)decorator).setX(xOrigin + xGap * i);
                ((ImageDecorator)decorator).setY(yOrigin + yGap * i);
                ++i;
            }
            return decorators.toArray(new IDecorator[decorators.size()]);
        }
    }

    private static class FeatureProvider
    extends DefaultFeatureProvider {
        private IFeatureProvider fp;

        public FeatureProvider(IDiagramTypeProvider dtp, IFeatureProvider fp) {
            super(dtp);
            this.fp = fp;
        }

        public static RoundedRectangle createFigure(State s, GraphicsAlgorithm invisibleRect, Color darkColor, Color brightColor) {
            IGaService gaService = Graphiti.getGaService();
            RoundedRectangle rect = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)invisibleRect, 20, 20);
            rect.setForeground(darkColor);
            rect.setBackground(brightColor);
            rect.setLineWidth(Integer.valueOf(1));
            gaService.setLocationAndSize((GraphicsAlgorithm)rect, 30, 30, invisibleRect.getWidth() - 60, invisibleRect.getHeight() - 60);
            StateSupport.addHints(s, rect, darkColor);
            return rect;
        }

        public ICreateFeature[] getCreateFeatures() {
            return new ICreateFeature[]{new CreateFeature(this.fp)};
        }

        public IAddFeature getAddFeature(IAddContext context) {
            return new AddFeature(this.fp);
        }

        public ILayoutFeature getLayoutFeature(ILayoutContext context) {
            return new LayoutFeature(this.fp);
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            return new UpdateFeature(this.fp);
        }

        public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
            return new MoveShapeFeature(this.fp);
        }

        public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
            return new ResizeFeature(this.fp);
        }

        public IRemoveFeature getRemoveFeature(IRemoveContext context) {
            return new RemoveFeature(this.fp);
        }

        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            return new DeleteFeature(this.fp);
        }

        public ICustomFeature[] getCustomFeatures(ICustomContext context) {
            ArrayList<Diagnostic> diagnostics;
            PictogramElement pe = context.getPictogramElements()[0];
            Object bo = this.getBusinessObjectForPictogramElement(pe);
            ArrayList<Object> result = new ArrayList<Object>();
            if (bo instanceof State) {
                State s = (State)bo;
                ModelComponent mc = FSMSupportUtil.getInstance().getModelComponent(this.getDiagramTypeProvider().getDiagram());
                boolean editable = FSMSupportUtil.getInstance().getFSMHelpers().getModelComponent((StateGraphItem)s) == mc;
                result.add((Object)new PropertyFeature(this.fp, editable));
                if (!editable) {
                    result.add((Object)new CreateRefinedStateFeature(this.fp));
                }
                if (FSMSupportUtil.getInstance().getFSMHelpers().hasSubStructure(s, mc)) {
                    result.add((Object)new GoDownFeature(this.fp));
                } else {
                    result.add((Object)new CreateSubGraphFeature(this.fp));
                }
            }
            if ((diagnostics = ((AbstractFSMEditor)this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer()).getDiagnosingModelObserver().getElementDiagonsticMap().get(bo)) != null) {
                result.add((Object)new QuickFixFeature(this.fp));
            }
            ICustomFeature[] features = new ICustomFeature[result.size()];
            return result.toArray(features);
        }

        private class AddFeature
        extends AbstractAddFeature {
            public AddFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canAdd(IAddContext context) {
                EObject obj;
                return context.getNewObject() instanceof State && context.getTargetContainer().getLink().getBusinessObjects().size() == 1 && (obj = (EObject)context.getTargetContainer().getLink().getBusinessObjects().get(0)) instanceof StateGraph;
            }

            public PictogramElement add(IAddContext context) {
                State s = (State)context.getNewObject();
                ContainerShape acShape = context.getTargetContainer();
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                ContainerShape containerShape = peCreateService.createContainerShape(acShape, true);
                Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, "obj-type", "state");
                int x = context.getX();
                int y = context.getY();
                int width = context.getWidth();
                int height = context.getHeight();
                if (width <= 0) {
                    width = 60;
                    IDimension sz = GraphitiUi.getUiLayoutService().calculateTextSize(s.getName(), (Font)this.getDiagram().getFonts().get(0));
                    if (width < sz.getWidth() + 10) {
                        width = sz.getWidth() + 10;
                    }
                } else {
                    x += width / 2;
                }
                if (height <= 0) {
                    height = 30;
                } else {
                    y += height / 2;
                }
                boolean showInherited = FSMSupportUtil.getInstance().showAsInherited(this.getDiagram(), s);
                Color lineColor = this.manageColor(showInherited ? INHERITED_COLOR : LINE_COLOR);
                Color bgColor = this.manageColor(showInherited ? INHERITED_BACKGROUND : BACKGROUND);
                IGaService gaService = Graphiti.getGaService();
                Rectangle invisibleRectangle = gaService.createInvisibleRectangle((PictogramElement)containerShape);
                gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRectangle, x - (width / 2 + 30), y - (height / 2 + 30), width + 60, height + 60);
                RoundedRectangle rect = FeatureProvider.createFigure(s, (GraphicsAlgorithm)invisibleRectangle, lineColor, bgColor);
                ChopboxAnchor anchor = peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
                anchor.setReferencedGraphicsAlgorithm((GraphicsAlgorithm)rect);
                this.link((PictogramElement)containerShape, s);
                Shape labelShape = peCreateService.createShape(containerShape, false);
                Text label = gaService.createDefaultText(this.getDiagram(), (GraphicsAlgorithmContainer)labelShape, s.getName());
                label.setForeground(lineColor);
                label.setBackground(lineColor);
                label.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
                label.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
                gaService.setLocationAndSize((GraphicsAlgorithm)label, 30, 30, width, height);
                this.layoutPictogramElement((PictogramElement)containerShape);
                return containerShape;
            }
        }

        private class CreateFeature
        extends ChangeAwareCreateFeature {
            public CreateFeature(IFeatureProvider fp) {
                super(fp, "State", "create State");
            }

            public String getCreateImageId() {
                return "org.eclipse.etrice.ui.behavior.state";
            }

            public boolean canCreate(ICreateContext context) {
                EObject obj;
                if (context.getTargetConnection() != null) {
                    return false;
                }
                return context.getTargetContainer().getLink() != null && context.getTargetContainer().getLink().getBusinessObjects().size() == 1 && (obj = (EObject)context.getTargetContainer().getLink().getBusinessObjects().get(0)) instanceof StateGraph;
            }

            public Object[] doCreate(ICreateContext context) {
                ContainerShape targetContainer = context.getTargetContainer();
                ModelComponent mc = FSMSupportUtil.getInstance().getModelComponent(this.getDiagram());
                StateGraph sg = (StateGraph)targetContainer.getLink().getBusinessObjects().get(0);
                if (!FSMSupportUtil.getInstance().isOwnedBy(mc, (EObject)sg)) {
                    sg = ModelEditingUtil.insertRefinedState(sg, mc, targetContainer, this.getFeatureProvider());
                }
                SimpleState s = FSMFactory.eINSTANCE.createSimpleState();
                s.setName(FSMSupportUtil.getInstance().getFSMNewNamingUtil().getUniqueName("state", sg));
                sg.getStates().add((Object)s);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                Injector injector = ((IInjectorProvider)this.getFeatureProvider()).getInjector();
                IFSMDialogFactory factory = (IFSMDialogFactory)injector.getInstance(IFSMDialogFactory.class);
                IStatePropertyDialog dlg = factory.createStatePropertyDialog(shell, mc, (State)s, true);
                if (dlg.open() == 0) {
                    this.addGraphicalRepresentation((IAreaContext)context, s);
                    return new Object[]{s};
                }
                return null;
            }
        }

        private static class CreateRefinedStateFeature
        extends AbstractCustomFeature
        implements ICustomFeature {
            public CreateRefinedStateFeature(IFeatureProvider fp) {
                super(fp);
            }

            public String getName() {
                return "Refine and Edit State";
            }

            public String getDescription() {
                return "Refine and edit this inherited state";
            }

            public boolean canExecute(ICustomContext context) {
                PictogramElement pe = context.getPictogramElements()[0];
                Object bo = this.getBusinessObjectForPictogramElement(pe);
                if (bo instanceof State) {
                    ModelComponent mc = FSMSupportUtil.getInstance().getModelComponent(this.getDiagram());
                    boolean isBaseClassState = FSMSupportUtil.getInstance().getFSMHelpers().getModelComponent((StateGraphItem)((State)bo)) != mc;
                    return isBaseClassState;
                }
                return false;
            }

            public void execute(ICustomContext context) {
                ICustomFeature[] features;
                this.getDiagramBehavior().getDiagramContainer().selectPictogramElements(new PictogramElement[0]);
                ContainerShape container = (ContainerShape)context.getPictogramElements()[0];
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)container);
                State s = (State)bo;
                RefinedState rs = ModelEditingUtil.getOrCreateRefinedStateFor(s, FSMSupportUtil.getInstance().getModelComponent(this.getDiagram()));
                this.link((PictogramElement)container, rs);
                ICustomFeature[] iCustomFeatureArray = features = this.getFeatureProvider().getCustomFeatures(context);
                int n = features.length;
                int n2 = 0;
                while (n2 < n) {
                    ICustomFeature cf = iCustomFeatureArray[n2];
                    if (cf instanceof PropertyFeature) {
                        cf.execute(context);
                        if (cf.hasDoneChanges()) break;
                        this.link((PictogramElement)container, s);
                        EcoreUtil.remove((EObject)rs);
                        break;
                    }
                    ++n2;
                }
            }
        }

        private static class CreateSubGraphFeature
        extends AbstractCustomFeature
        implements ICustomFeature {
            public CreateSubGraphFeature(IFeatureProvider fp) {
                super(fp);
            }

            public String getName() {
                return "Create SubGraph";
            }

            public String getDescription() {
                return "Create and Switch to New SubGraph";
            }

            public boolean canExecute(ICustomContext context) {
                PictogramElement pe = context.getPictogramElements()[0];
                Object bo = this.getBusinessObjectForPictogramElement(pe);
                if (bo instanceof State) {
                    boolean isBaseClassState;
                    ModelComponent mc = FSMSupportUtil.getInstance().getModelComponent(this.getDiagram());
                    boolean bl = isBaseClassState = FSMSupportUtil.getInstance().getFSMHelpers().getModelComponent((StateGraphItem)((State)bo)) != mc;
                    return isBaseClassState || !FSMSupportUtil.getInstance().getFSMHelpers().hasSubStructure((State)bo, mc);
                }
                return false;
            }

            public void execute(ICustomContext context) {
                this.getDiagramBehavior().getDiagramContainer().selectPictogramElements(new PictogramElement[0]);
                ContainerShape container = (ContainerShape)context.getPictogramElements()[0];
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)container);
                if (bo instanceof State) {
                    boolean isBaseClassState;
                    State s = (State)bo;
                    StateGraph newSG = null;
                    boolean bl = isBaseClassState = FSMSupportUtil.getInstance().getFSMHelpers().getModelComponent((StateGraphItem)s) != FSMSupportUtil.getInstance().getModelComponent(this.getDiagram());
                    if (isBaseClassState) {
                        newSG = ModelEditingUtil.getOrCreateSubGraphOfRefinedStateFor(s, FSMSupportUtil.getInstance().getModelComponent(this.getDiagram()));
                        s = (State)newSG.eContainer();
                        this.link((PictogramElement)container, s);
                    } else {
                        s.setSubgraph(FSMFactory.eINSTANCE.createStateGraph());
                        newSG = s.getSubgraph();
                    }
                    AddContext addContext = new AddContext();
                    addContext.setNewObject((Object)newSG);
                    addContext.setTargetContainer((ContainerShape)this.getDiagram());
                    addContext.setX(40);
                    addContext.setY(40);
                    PictogramElement subGraphShape = this.getFeatureProvider().addIfPossible((IAddContext)addContext);
                    if (subGraphShape != null) {
                        RoundedRectangle borderRect = (RoundedRectangle)container.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
                        StateSupport.updateHints(s, (GraphicsAlgorithm)borderRect);
                        SimpleState initialState = FSMFactory.eINSTANCE.createSimpleState();
                        initialState.setName("InitialState");
                        newSG.getStates().add((Object)initialState);
                        InitialTransition initialTransition = FSMFactory.eINSTANCE.createInitialTransition();
                        initialTransition.setName("init");
                        StateTerminal stateTerminal = FSMFactory.eINSTANCE.createStateTerminal();
                        stateTerminal.setState((State)initialState);
                        initialTransition.setTo((TransitionTerminal)stateTerminal);
                        newSG.getTransitions().add((Object)initialTransition);
                        UpdateContext ctx = new UpdateContext((PictogramElement)this.getDiagram());
                        this.getFeatureProvider().getUpdateFeature((IUpdateContext)ctx).update((IUpdateContext)ctx);
                    }
                    ContextSwitcher.switchTo(this.getDiagram(), s.getSubgraph());
                }
            }
        }

        protected static class DeleteFeature
        extends DeleteWithoutConfirmFeature {
            public DeleteFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canDelete(IDeleteContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof State) {
                    State state = (State)bo;
                    return !FSMSupportUtil.getInstance().isInherited(this.getDiagram(), (EObject)state);
                }
                return false;
            }

            public void preDelete(IDeleteContext context) {
                super.preDelete(context);
                if (!(context.getPictogramElement() instanceof ContainerShape)) {
                    return;
                }
                State s = (State)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                IFeatureProvider fp = this.getFeatureProvider();
                Diagram diagram = this.getDiagram();
                ModelComponent mc = FSMSupportUtil.getInstance().getFSMHelpers().getModelComponent((StateGraphItem)s);
                DiagramEditingUtil.getInstance().deleteSubStructureRecursive(s, mc, diagram, fp);
                ContainerShape container = (ContainerShape)context.getPictogramElement();
                CommonSupportUtil.deleteConnectionsRecursive((ContainerShape)container, (IFeatureProvider)fp);
            }
        }

        private static class GoDownFeature
        extends AbstractCustomFeature
        implements ICustomFeature {
            public GoDownFeature(IFeatureProvider fp) {
                super(fp);
            }

            public String getName() {
                return "Switch to SubGraph";
            }

            public String getDescription() {
                return "Switch Context to SubGraph";
            }

            public boolean canExecute(ICustomContext context) {
                PictogramElement pe = context.getPictogramElements()[0];
                Object bo = this.getBusinessObjectForPictogramElement(pe);
                return bo instanceof State && FSMSupportUtil.getInstance().getFSMHelpers().hasSubStructure((State)bo, FSMSupportUtil.getInstance().getModelComponent(this.getDiagram()));
            }

            public void execute(ICustomContext context) {
                this.getDiagramBehavior().getDiagramContainer().selectPictogramElements(new PictogramElement[0]);
                ContainerShape container = (ContainerShape)context.getPictogramElements()[0];
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)container);
                if (bo instanceof State) {
                    State hasSub = (State)bo;
                    while (!FSMSupportUtil.getInstance().getFSMHelpers().hasDirectSubStructure(hasSub)) {
                        if (hasSub instanceof RefinedState) {
                            hasSub = ((RefinedState)hasSub).getTarget();
                            continue;
                        }
                        return;
                    }
                    if (hasSub.getSubgraph() != null) {
                        ContextSwitcher.switchTo(this.getDiagram(), hasSub.getSubgraph());
                    }
                }
            }

            public boolean hasDoneChanges() {
                return false;
            }
        }

        private class LayoutFeature
        extends AbstractLayoutFeature {
            public LayoutFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canLayout(ILayoutContext context) {
                PictogramElement pe = context.getPictogramElement();
                if (!(pe instanceof ContainerShape)) {
                    return false;
                }
                Object bo = this.getBusinessObjectForPictogramElement(pe);
                return bo instanceof State;
            }

            public boolean layout(ILayoutContext context) {
                boolean anythingChanged = false;
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                GraphicsAlgorithm containerGa = containerShape.getGraphicsAlgorithm();
                int w = containerGa.getWidth();
                int h = containerGa.getHeight();
                if (containerGa.getGraphicsAlgorithmChildren().size() >= 1) {
                    GraphicsAlgorithm borderGA = (GraphicsAlgorithm)containerGa.getGraphicsAlgorithmChildren().get(0);
                    int nw = w - 60;
                    int nh = h - 60;
                    borderGA.setWidth(nw);
                    borderGA.setHeight(nh);
                    Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                    if (bo instanceof State) {
                        State s = (State)bo;
                        while (!borderGA.getGraphicsAlgorithmChildren().isEmpty()) {
                            EcoreUtil.delete((EObject)((EObject)borderGA.getGraphicsAlgorithmChildren().get(0)), (boolean)true);
                        }
                        Color lineColor = this.manageColor(FSMSupportUtil.getInstance().showAsInherited(this.getDiagram(), s) ? INHERITED_COLOR : LINE_COLOR);
                        StateSupport.addHints(s, (RoundedRectangle)borderGA, lineColor);
                    }
                    if (!containerShape.getChildren().isEmpty()) {
                        GraphicsAlgorithm childGA = ((Shape)containerShape.getChildren().get(0)).getGraphicsAlgorithm();
                        assert (childGA instanceof Text) : "label expected";
                        childGA.setWidth(nw);
                        childGA.setHeight(nh);
                    }
                    anythingChanged = true;
                }
                return anythingChanged;
            }
        }

        private class MoveShapeFeature
        extends DefaultMoveShapeFeature {
            public MoveShapeFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canMoveShape(IMoveShapeContext context) {
                Object bo;
                boolean canMove = super.canMoveShape(context);
                if (canMove && (bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement())) instanceof State) {
                    State s = (State)bo;
                    return !FSMSupportUtil.getInstance().isInherited(this.getDiagram(), (EObject)s);
                }
                return canMove;
            }
        }

        private static class PropertyFeature
        extends ChangeAwareCustomFeature {
            private boolean editable;

            public PropertyFeature(IFeatureProvider fp, boolean editable) {
                super(fp);
                this.editable = editable;
            }

            public String getName() {
                return this.editable ? "Edit State..." : "View State";
            }

            public String getDescription() {
                return this.editable ? "Edit State Properties" : "View State Properties";
            }

            public boolean canExecute(ICustomContext context) {
                Object bo;
                PictogramElement[] pes = context.getPictogramElements();
                return pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof State;
            }

            public boolean doExecute(ICustomContext context) {
                ModelComponent mc = FSMSupportUtil.getInstance().getModelComponent(this.getDiagram());
                State s = (State)this.getBusinessObjectForPictogramElement(context.getPictogramElements()[0]);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                Injector injector = ((IInjectorProvider)this.getFeatureProvider()).getInjector();
                IFSMDialogFactory factory = (IFSMDialogFactory)injector.getInstance(IFSMDialogFactory.class);
                IStatePropertyDialog dlg = factory.createStatePropertyDialog(shell, mc, s, this.editable);
                if (dlg.open() == 0) {
                    this.updateFigure(s, context);
                    this.adjustSubgraphLabels(s, mc);
                    return true;
                }
                return false;
            }

            private void adjustSubgraphLabels(State s, ModelComponent mc) {
                if (s instanceof RefinedState) {
                    return;
                }
                if (FSMSupportUtil.getInstance().getFSMHelpers().hasDirectSubStructure(s)) {
                    Shape labelShape;
                    GraphicsAlgorithm ga;
                    ContainerShape subShape = ContextSwitcher.getContext(this.getDiagram(), s.getSubgraph());
                    if (subShape != null && !subShape.getChildren().isEmpty() && (ga = (labelShape = (Shape)subShape.getChildren().get(0)).getGraphicsAlgorithm()) instanceof Text) {
                        ((Text)ga).setValue(FSMSupportUtil.getInstance().getFSMNameProvider().getStateGraphLabel(s.getSubgraph()));
                    }
                    if (s.getSubgraph() != null) {
                        for (State sub : s.getSubgraph().getStates()) {
                            this.adjustSubgraphLabels(sub, mc);
                        }
                    }
                }
            }

            private void updateFigure(State s, ICustomContext context) {
                ContainerShape container = (ContainerShape)context.getPictogramElements()[0];
                GraphicsAlgorithm invisibleRect = context.getPictogramElements()[0].getGraphicsAlgorithm();
                while (!invisibleRect.getGraphicsAlgorithmChildren().isEmpty()) {
                    EcoreUtil.delete((EObject)((EObject)invisibleRect.getGraphicsAlgorithmChildren().get(0)), (boolean)true);
                }
                boolean showInherite = FSMSupportUtil.getInstance().showAsInherited(this.getDiagram(), s);
                Color lineColor = this.manageColor(showInherite ? INHERITED_COLOR : LINE_COLOR);
                Color bgColor = this.manageColor(showInherite ? INHERITED_BACKGROUND : BACKGROUND);
                FeatureProvider.createFigure(s, invisibleRect, lineColor, bgColor);
                GraphicsAlgorithm ga = ((Shape)container.getChildren().get(0)).getGraphicsAlgorithm();
                if (ga instanceof Text) {
                    ((Text)ga).setValue(s.getName());
                }
            }
        }

        protected static class RemoveFeature
        extends DefaultRemoveFeature {
            public RemoveFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canRemove(IRemoveContext context) {
                return false;
            }
        }

        private class ResizeFeature
        extends DefaultResizeShapeFeature {
            public ResizeFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canResizeShape(IResizeShapeContext context) {
                if (!super.canResizeShape(context)) {
                    return false;
                }
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof State) {
                    State s = (State)bo;
                    if (FSMSupportUtil.getInstance().isInherited(this.getDiagram(), (EObject)s)) {
                        return false;
                    }
                    int width = context.getWidth() - 30;
                    int height = context.getHeight() - 30;
                    return width <= 0 || height <= 0 || width >= 90 && height >= 60;
                }
                return false;
            }

            public void resizeShape(IResizeShapeContext context) {
                GraphicsAlgorithm containerGa;
                Shape shape = context.getShape();
                if (shape.getGraphicsAlgorithm() != null && (containerGa = shape.getGraphicsAlgorithm()).getGraphicsAlgorithmChildren().size() == 1) {
                    GraphicsAlgorithm ga = (GraphicsAlgorithm)containerGa.getGraphicsAlgorithmChildren().get(0);
                    double sx = (double)(context.getWidth() - 60) / (double)ga.getWidth();
                    double sy = (double)(context.getHeight() - 60) / (double)ga.getHeight();
                    for (Shape childShape : ((ContainerShape)context.getShape()).getChildren()) {
                        Object childBo = this.getBusinessObjectForPictogramElement((PictogramElement)childShape);
                        if (!(childBo instanceof TrPoint)) continue;
                        ga = childShape.getGraphicsAlgorithm();
                        int midX = ga.getX() + ga.getWidth() / 2 - 30;
                        int midY = ga.getY() + ga.getHeight() / 2 - 30;
                        midX = (int)((double)midX * sx);
                        midY = (int)((double)midY * sy);
                        midX = midX - ga.getWidth() / 2 + 30;
                        midY = midY - ga.getHeight() / 2 + 30;
                        Graphiti.getGaService().setLocation(ga, midX, midY);
                        this.updatePictogramElement((PictogramElement)childShape);
                    }
                }
                super.resizeShape(context);
            }
        }

        private class UpdateFeature
        extends AbstractUpdateFeature {
            public UpdateFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canUpdate(IUpdateContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return true;
                }
                return bo instanceof State;
            }

            public IReason updateNeeded(IUpdateContext context) {
                GraphicsAlgorithm ga;
                int last;
                GraphicsAlgorithm borderRect;
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return Reason.createTrueReason((String)"State deleted from model");
                }
                State s = (State)bo;
                ModelComponent mainAc = FSMSupportUtil.getInstance().getModelComponent(this.getDiagram());
                boolean hasSubStruct = FSMSupportUtil.getInstance().getFSMHelpers().hasSubStructure(s, mainAc);
                GraphicsAlgorithm invisibleRect = containerShape.getGraphicsAlgorithm();
                if (!invisibleRect.getGraphicsAlgorithmChildren().isEmpty() && !(borderRect = (GraphicsAlgorithm)invisibleRect.getGraphicsAlgorithmChildren().get(0)).getGraphicsAlgorithmChildren().isEmpty()) {
                    GraphicsAlgorithm hint = (GraphicsAlgorithm)borderRect.getGraphicsAlgorithmChildren().get(0);
                    if (hasSubStruct && !hint.getLineVisible().booleanValue()) {
                        return Reason.createTrueReason((String)"state has sub structure now");
                    }
                    if (!hasSubStruct && hint.getLineVisible().booleanValue()) {
                        return Reason.createTrueReason((String)"state has no sub structure anymore");
                    }
                }
                if ((last = containerShape.getChildren().size() - 1) >= 0 && (ga = ((Shape)containerShape.getChildren().get(last)).getGraphicsAlgorithm()) instanceof Text && !((Text)ga).getValue().equals(s.getName())) {
                    return Reason.createTrueReason((String)"State name is out of date");
                }
                return Reason.createFalseReason();
            }

            public boolean update(IUpdateContext context) {
                GraphicsAlgorithm ga;
                int last;
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    RemoveContext rc = new RemoveContext((PictogramElement)containerShape);
                    IFeatureProvider featureProvider = this.getFeatureProvider();
                    IRemoveFeature removeFeature = featureProvider.getRemoveFeature((IRemoveContext)rc);
                    if (removeFeature != null) {
                        removeFeature.remove((IRemoveContext)rc);
                    }
                    EcoreUtil.delete((EObject)((EObject)bo));
                    return true;
                }
                State s = (State)bo;
                GraphicsAlgorithm invisibleRect = containerShape.getGraphicsAlgorithm();
                if (!invisibleRect.getGraphicsAlgorithmChildren().isEmpty()) {
                    GraphicsAlgorithm borderRect = (GraphicsAlgorithm)invisibleRect.getGraphicsAlgorithmChildren().get(0);
                    StateSupport.updateHints(s, borderRect);
                }
                if ((last = containerShape.getChildren().size() - 1) >= 0 && (ga = ((Shape)containerShape.getChildren().get(last)).getGraphicsAlgorithm()) instanceof Text) {
                    ((Text)ga).setValue(s.getName());
                }
                return true;
            }
        }
    }
}

