/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.fsm.support.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.fsm.fSM.ChoicePoint;
import org.eclipse.etrice.core.fsm.fSM.ChoicepointTerminal;
import org.eclipse.etrice.core.fsm.fSM.EntryPoint;
import org.eclipse.etrice.core.fsm.fSM.ExitPoint;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.NonInitialTransition;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateGraphItem;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.fsm.fSM.StateTerminal;
import org.eclipse.etrice.core.fsm.fSM.SubStateTrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.TrPoint;
import org.eclipse.etrice.core.fsm.fSM.TrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.TransitionTerminal;
import org.eclipse.etrice.core.fsm.naming.FSMNameProvider;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.ui.behavior.fsm.support.ContextSwitcher;
import org.eclipse.etrice.ui.behavior.fsm.support.IPositionProvider;
import org.eclipse.etrice.ui.behavior.fsm.support.IStateGraphContext;
import org.eclipse.etrice.ui.behavior.fsm.support.util.FSMSizeAndPositionUtil;
import org.eclipse.etrice.ui.behavior.fsm.support.util.FSMSupportUtil;
import org.eclipse.etrice.ui.common.base.support.CommonSupportUtil;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.ILinkService;

public class DiagramEditingUtil {
    private static final String INITIAL = "init";
    private static final String STATE = "state:";
    private static final String TP = "tp:";
    private static final String CP = "cp:";
    private static final String SEP = ".";
    private static DiagramEditingUtil instance = null;
    private static FSMHelpers fsmHelpers = new FSMHelpers();

    public static DiagramEditingUtil getInstance() {
        if (instance == null) {
            instance = new DiagramEditingUtil();
        }
        return instance;
    }

    public void updateStateGraph(StateGraph sg, IStateGraphContext ctx, ContainerShape sgShape, IFeatureProvider fp) {
        Object expected;
        State item2;
        HashMap<String, Anchor> node2anchor = new HashMap<String, Anchor>();
        GraphicsAlgorithm borderRect = (GraphicsAlgorithm)sgShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
        ctx.getPositionProvider().setScale(borderRect.getWidth(), borderRect.getHeight());
        ctx.getPositionProvider().setPosition(sgShape.getGraphicsAlgorithm().getX(), sgShape.getGraphicsAlgorithm().getY());
        ArrayList<Object> shapes = new ArrayList<Shape>();
        List<State> present = this.getStates(sgShape, fp, node2anchor, shapes);
        this.checkDuplicates(present);
        Object expected2 = ctx.getStates();
        ArrayList<State> toAdd = new ArrayList<State>();
        ArrayList<State> toUpdate = new ArrayList<State>();
        ArrayList<State> toRemove = new ArrayList<State>();
        Iterator<State> iterator = expected2.iterator();
        while (iterator.hasNext()) {
            item2 = iterator.next();
            if (present.contains(item2)) {
                toUpdate.add(item2);
                continue;
            }
            toAdd.add(item2);
        }
        for (State item2 : present) {
            if (expected2.contains(item2)) continue;
            toRemove.add(item2);
        }
        this.addStateGraphNodes(toAdd, ctx.getPositionProvider(), sgShape, fp, node2anchor);
        this.updateStateGraphNodes(toUpdate, shapes, ctx.getPositionProvider(), fp);
        this.removeGraphicalRepresentation(toRemove, shapes, fp);
        shapes = new ArrayList();
        present = this.getTrPoints(sg, sgShape, fp, node2anchor, shapes);
        this.checkDuplicates(present);
        expected2 = ctx.getTrPoints();
        toAdd = new ArrayList();
        toUpdate = new ArrayList();
        toRemove = new ArrayList();
        iterator = expected2.iterator();
        while (iterator.hasNext()) {
            item2 = (TrPoint)iterator.next();
            if (present.contains(item2)) {
                toUpdate.add(item2);
                continue;
            }
            toAdd.add(item2);
        }
        for (State item2 : present) {
            if (expected2.contains(item2)) continue;
            toRemove.add(item2);
        }
        this.addStateGraphNodes(toAdd, ctx.getPositionProvider(), sgShape, fp, node2anchor);
        this.updateStateGraphNodes(toUpdate, shapes, ctx.getPositionProvider(), fp);
        this.removeGraphicalRepresentation(toRemove, shapes, fp);
        shapes = new ArrayList();
        present = this.getChoicePoints(sgShape, fp, node2anchor, shapes);
        this.checkDuplicates(present);
        expected2 = ctx.getChPoints();
        toAdd = new ArrayList();
        toUpdate = new ArrayList();
        toRemove = new ArrayList();
        iterator = expected2.iterator();
        while (iterator.hasNext()) {
            item2 = (ChoicePoint)iterator.next();
            if (present.contains(item2)) {
                toUpdate.add(item2);
                continue;
            }
            toAdd.add(item2);
        }
        for (State item2 : present) {
            if (expected2.contains(item2)) continue;
            toRemove.add(item2);
        }
        this.addStateGraphNodes(toAdd, ctx.getPositionProvider(), sgShape, fp, node2anchor);
        this.updateStateGraphNodes(toUpdate, shapes, ctx.getPositionProvider(), fp);
        this.removeGraphicalRepresentation(toRemove, shapes, fp);
        this.getSubTpAnchors(sgShape, node2anchor);
        Object present2 = null;
        for (Shape ch : sgShape.getChildren()) {
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)ch);
            if (!(bo instanceof StateGraph)) continue;
            present2 = ch;
        }
        if (present2 != null) {
            node2anchor.put(INITIAL, (Anchor)present2.getAnchors().get(0));
        }
        if ((expected = ctx.getInitialPoint()) == null) {
            expected = ctx.getPositionProvider().getInitialPoint(ctx.getStateGraph());
        }
        if (expected != null && present2 == null) {
            this.addInitialPointIff(ctx, ctx.getPositionProvider(), sgShape, fp, node2anchor);
        } else {
            this.updateInitialPoint((Shape)present2, ctx.getPositionProvider(), fp);
        }
        present2 = this.getTransitionsMap(sgShape, fp);
        expected = ctx.getTransitions();
        ArrayList<Transition> toAdd2 = new ArrayList<Transition>();
        ArrayList<Transition> toRemove2 = new ArrayList<Transition>();
        Iterator<Object> iterator2 = expected.iterator();
        while (iterator2.hasNext()) {
            Transition trans = (Transition)iterator2.next();
            if (present2.containsKey(trans)) continue;
            toAdd2.add(trans);
        }
        for (Transition item3 : present2.keySet()) {
            if (expected.contains(item3)) continue;
            toRemove2.add(item3);
        }
        this.addTransitions(toAdd2, ctx.getPositionProvider(), sgShape, fp, node2anchor);
        this.updateTransitions((Map<Transition, Connection>)present2, ctx.getPositionProvider(), sgShape, fp, node2anchor);
        this.removeGraphicalRepresentation(toRemove2, present2.values(), fp);
    }

    public void removeGraphicalRepresentation(Collection<? extends EObject> toRemove, Collection<? extends PictogramElement> pictograms, IFeatureProvider fp) {
        block0: for (EObject eObject : toRemove) {
            for (PictogramElement pictogramElement : pictograms) {
                if (fp.getBusinessObjectForPictogramElement(pictogramElement) != eObject) continue;
                RemoveContext rc = new RemoveContext(pictogramElement);
                IRemoveFeature removeFeature = fp.getRemoveFeature((IRemoveContext)rc);
                if (removeFeature == null) continue block0;
                removeFeature.remove((IRemoveContext)rc);
                continue block0;
            }
        }
    }

    public void deleteSubStructureRecursive(State s, ModelComponent mc, Diagram diagram, IFeatureProvider fp) {
        if (FSMSupportUtil.getInstance().getFSMHelpers().hasSubStructure(s, mc)) {
            StateGraph subgraph = s.getSubgraph();
            for (State st : subgraph.getStates()) {
                this.deleteSubStructureRecursive(st, mc, diagram, fp);
            }
            ContainerShape subShape = ContextSwitcher.getContext(diagram, subgraph);
            CommonSupportUtil.deleteConnectionsRecursive((ContainerShape)subShape, (IFeatureProvider)fp);
            EcoreUtil.delete((EObject)subShape, (boolean)true);
        }
    }

    public ContainerShape addStateGraph(IStateGraphContext ctx, Diagram diagram, IFeatureProvider fp) {
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)ctx.getStateGraph());
        addContext.setTargetContainer((ContainerShape)diagram);
        IPositionProvider.PosAndSize graphPosAndSize = ctx.getPositionProvider().getGraphPosAndSize(ctx.getStateGraph());
        if (graphPosAndSize != null) {
            addContext.setX(graphPosAndSize.getX());
            addContext.setY(graphPosAndSize.getY());
            addContext.setWidth(graphPosAndSize.getWidth());
            addContext.setHeight(graphPosAndSize.getHeight());
        } else {
            addContext.setX(40);
            addContext.setY(40);
        }
        ContainerShape sgShape = (ContainerShape)fp.addIfPossible((IAddContext)addContext);
        if (sgShape == null) {
            return null;
        }
        HashMap<String, Anchor> node2anchor = new HashMap<String, Anchor>();
        GraphicsAlgorithm borderRect = (GraphicsAlgorithm)sgShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
        ctx.getPositionProvider().setScale(borderRect.getWidth(), borderRect.getHeight());
        ctx.getPositionProvider().setPosition(sgShape.getGraphicsAlgorithm().getX(), sgShape.getGraphicsAlgorithm().getY());
        this.addInitialPointIff(ctx, ctx.getPositionProvider(), sgShape, fp, node2anchor);
        LinkedList<Object> allNodes = new LinkedList<Object>();
        allNodes.addAll(ctx.getTrPoints());
        allNodes.addAll(ctx.getStates());
        allNodes.addAll(ctx.getChPoints());
        this.addStateGraphNodes(allNodes, ctx.getPositionProvider(), sgShape, fp, node2anchor);
        for (IStateGraphContext sub : ctx.getChildren()) {
            this.addStateGraph(sub, diagram, fp);
        }
        this.getSubTpAnchors(sgShape, node2anchor);
        this.addTransitions(ctx.getTransitions(), ctx.getPositionProvider(), sgShape, fp, node2anchor);
        FSMSizeAndPositionUtil.resizeDiagramFrame(sgShape);
        fp.layoutIfPossible((ILayoutContext)new LayoutContext((PictogramElement)sgShape));
        return sgShape;
    }

    public List<State> getStates(ContainerShape shape, IFeatureProvider fp) {
        return this.getStates(shape, fp, null, null);
    }

    public List<ChoicePoint> getChoicePoints(ContainerShape shape, IFeatureProvider fp) {
        return this.getChoicePoints(shape, fp, null, null);
    }

    public List<TrPoint> getTrPoints(StateGraph sg, ContainerShape shape, IFeatureProvider fp) {
        return this.getTrPoints(sg, shape, fp, null, null);
    }

    private List<State> getStates(ContainerShape shape, IFeatureProvider fp, Map<String, Anchor> item2anchor, List<Shape> stateShapes) {
        ArrayList<State> items = new ArrayList<State>();
        for (Shape ch : shape.getChildren()) {
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)ch);
            if (!(bo instanceof State)) continue;
            items.add((State)bo);
            if (item2anchor != null) {
                item2anchor.put(this.getKey((EObject)((State)bo)), (Anchor)ch.getAnchors().get(0));
            }
            if (stateShapes == null) continue;
            stateShapes.add(ch);
        }
        return items;
    }

    private List<ChoicePoint> getChoicePoints(ContainerShape shape, IFeatureProvider fp, Map<String, Anchor> item2anchor, List<Shape> cpShapes) {
        ArrayList<ChoicePoint> items = new ArrayList<ChoicePoint>();
        for (Shape ch : shape.getChildren()) {
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)ch);
            if (!(bo instanceof ChoicePoint)) continue;
            items.add((ChoicePoint)bo);
            if (item2anchor != null) {
                item2anchor.put(this.getKey((EObject)((ChoicePoint)bo)), (Anchor)ch.getAnchors().get(0));
            }
            if (cpShapes == null) continue;
            cpShapes.add(ch);
        }
        return items;
    }

    private List<TrPoint> getTrPoints(StateGraph sg, ContainerShape shape, IFeatureProvider fp, Map<String, Anchor> item2anchor, List<Shape> tpShapes) {
        ArrayList<TrPoint> items = new ArrayList<TrPoint>();
        for (Shape ch : shape.getChildren()) {
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)ch);
            if (!(bo instanceof TrPoint)) continue;
            items.add((TrPoint)bo);
            if (item2anchor != null) {
                item2anchor.put(this.getKey((EObject)((TrPoint)bo)), (Anchor)ch.getAnchors().get(0));
            }
            if (tpShapes == null) continue;
            tpShapes.add(ch);
        }
        return items;
    }

    private Map<Transition, Connection> getTransitionsMap(ContainerShape sgShape, IFeatureProvider fp) {
        Diagram diagram = (Diagram)sgShape.eContainer();
        HashMap<Transition, Connection> transitions = new HashMap<Transition, Connection>();
        for (Connection conn : diagram.getConnections()) {
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)conn);
            if (!(bo instanceof Transition) || !EcoreUtil.isAncestor((EObject)sgShape, (EObject)conn.getStart())) continue;
            transitions.put((Transition)bo, conn);
        }
        return transitions;
    }

    private void getSubTpAnchors(ContainerShape sgShape, HashMap<String, Anchor> node2anchor) {
        for (Shape childShape : sgShape.getChildren()) {
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)childShape);
            if (!(bo instanceof State)) continue;
            this.getAnchors((State)bo, (PictogramElement)childShape, node2anchor);
        }
    }

    private void addInitialPointIff(IStateGraphContext ctx, IPositionProvider positionProvider, ContainerShape sgShape, IFeatureProvider fp, HashMap<String, Anchor> node2anchor) {
        StateGraph sg = ctx.getInitialPoint();
        if (sg == null) {
            sg = positionProvider.getInitialPoint(ctx.getStateGraph());
        }
        if (sg == null) {
            return;
        }
        IPositionProvider.PosAndSize pos = positionProvider.getPosition(sg);
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)sg);
        addContext.setTargetContainer(sgShape);
        if (pos != null) {
            addContext.setX(pos.getX());
            addContext.setY(pos.getY());
            if (pos.getWidth() > 0 && pos.getHeight() > 0) {
                addContext.setWidth(pos.getWidth());
                addContext.setHeight(pos.getHeight());
            }
        } else {
            addContext.setX(120);
            addContext.setY(120);
        }
        ContainerShape pe = (ContainerShape)fp.addIfPossible((IAddContext)addContext);
        assert (pe != null) : "initial point should have been created";
        assert (!pe.getAnchors().isEmpty()) : "initial point should have an anchor";
        node2anchor.put(INITIAL, (Anchor)pe.getAnchors().get(0));
    }

    private String getTerminalName(TransitionTerminal terminal) {
        String terminalNodeName = fsmHelpers.getTerminalState(terminal).getName();
        return terminalNodeName;
    }

    private boolean transitionHasStandardDirection(Transition trans) {
        String destName;
        String srcName = trans instanceof InitialTransition ? "INIT" : this.getTerminalName(((NonInitialTransition)trans).getFrom());
        return srcName.compareTo(destName = this.getTerminalName(trans.getTo())) > 0;
    }

    private String getTransitionPathName(Transition trans) {
        String destName;
        String srcName = trans instanceof InitialTransition ? "INIT" : this.getTerminalName(((NonInitialTransition)trans).getFrom());
        if (srcName.compareTo(destName = this.getTerminalName(trans.getTo())) > 0) {
            return String.valueOf(srcName) + "->" + destName;
        }
        return String.valueOf(destName) + "->" + srcName;
    }

    private void addTransitions(List<Transition> transitions, IPositionProvider positionProvider, ContainerShape sgShape, IFeatureProvider fp, HashMap<String, Anchor> node2anchor) {
        if (transitions.isEmpty()) {
            return;
        }
        LinkedList<Transition> doneTransitions = new LinkedList<Transition>();
        HashMap<String, Integer> samePathCounts = new HashMap<String, Integer>();
        StateGraph sg = (StateGraph)transitions.get(0).eContainer();
        for (StateGraphNode node : fsmHelpers.getAllNodes(sg)) {
            LinkedList<Transition> transitionsToPlace = new LinkedList<Transition>();
            for (Transition trans : fsmHelpers.getTransitionsFromGraphNode(sg, node)) {
                if (doneTransitions.contains(trans)) continue;
                int samePathCount = samePathCounts.getOrDefault(this.getTransitionPathName(trans), -1);
                if (samePathCount < 0 && (samePathCount = fsmHelpers.getSamePathTransitionCount(sg, trans)) > 1) {
                    samePathCounts.put(this.getTransitionPathName(trans), samePathCount);
                }
                if (!fsmHelpers.isSelfTransition(trans)) continue;
                transitionsToPlace.add(trans);
            }
            double angleDiff_rad = 1.5707963267948966 / (double)transitionsToPlace.size();
            int i = 0;
            for (Transition trans : transitionsToPlace) {
                doneTransitions.add(trans);
                String from = trans instanceof InitialTransition ? INITIAL : this.getKey((EObject)((NonInitialTransition)trans).getFrom());
                String to = this.getKey((EObject)trans.getTo());
                Anchor src = node2anchor.get(from);
                Anchor dst = node2anchor.get(to);
                AddConnectionContext context = new AddConnectionContext(src, dst);
                context.setNewObject((Object)trans);
                PictogramElement pe = fp.addIfPossible((IAddContext)context);
                if (pe instanceof FreeFormConnection) {
                    FreeFormConnection conn = (FreeFormConnection)pe;
                    conn.getBendpoints().clear();
                    ILocation begin = Graphiti.getPeService().getLocationRelativeToDiagram(conn.getStart());
                    Point pt = Graphiti.getGaService().createPoint((int)((double)begin.getX() + 120.0 * Math.sin(angleDiff_rad * (double)i)), (int)((double)begin.getY() + 120.0 * Math.cos(angleDiff_rad * (double)i)));
                    conn.getBendpoints().add((Object)pt);
                }
                ++i;
            }
        }
        for (Transition trans : transitions) {
            if (doneTransitions.contains(trans)) continue;
            String from = trans instanceof InitialTransition ? INITIAL : this.getKey((EObject)((NonInitialTransition)trans).getFrom());
            String to = this.getKey((EObject)trans.getTo());
            Anchor src = node2anchor.get(from);
            Anchor dst = node2anchor.get(to);
            assert (src != null && dst != null) : "transition endpoints must be present";
            AddConnectionContext context = new AddConnectionContext(src, dst);
            context.setNewObject((Object)trans);
            PictogramElement pe = fp.addIfPossible((IAddContext)context);
            if (!(pe instanceof FreeFormConnection)) continue;
            FreeFormConnection conn = (FreeFormConnection)pe;
            conn.getBendpoints().clear();
            List<IPositionProvider.Pos> points = positionProvider.getPoints(trans);
            if (points != null && !points.isEmpty()) {
                Iterator<IPositionProvider.Pos> it = points.iterator();
                IPositionProvider.Pos pos = it.next();
                ConnectionDecorator cd = (ConnectionDecorator)conn.getConnectionDecorators().get(1);
                Graphiti.getGaService().setLocation(cd.getGraphicsAlgorithm(), pos.getX(), pos.getY());
                while (it.hasNext()) {
                    pos = it.next();
                    Point pt = Graphiti.getGaService().createPoint(pos.getX(), pos.getY());
                    conn.getBendpoints().add((Object)pt);
                }
                continue;
            }
            int samePathCount = samePathCounts.getOrDefault(this.getTransitionPathName(trans), -1);
            if (samePathCount <= -1) continue;
            samePathCounts.put(this.getTransitionPathName(trans), samePathCount - 1);
            ILocation begin = Graphiti.getPeService().getLocationRelativeToDiagram(conn.getStart());
            ILocation end = Graphiti.getPeService().getLocationRelativeToDiagram(conn.getEnd());
            int spreadDist = 15;
            if (!this.transitionHasStandardDirection(trans)) {
                ILocation tmp = begin;
                begin = end;
                end = tmp;
            }
            int offsetX = begin.getX() - end.getX();
            int offsetY = begin.getY() - end.getY();
            double spreadAngle_rad = Math.atan2(offsetY, offsetX) + 1.5707963267948966;
            double offsetFactor = 1.0;
            if (samePathCount == 0) {
                offsetFactor = 0.0;
            } else if (samePathCount % 2 == 0) {
                offsetFactor = -1.0;
            }
            offsetX /= 2;
            offsetY /= 2;
            offsetX = (int)((double)offsetX + (double)(samePathCount * spreadDist) * Math.cos(spreadAngle_rad) * offsetFactor);
            offsetY = (int)((double)offsetY + (double)(samePathCount * spreadDist) * Math.sin(spreadAngle_rad) * offsetFactor);
            Point pt = Graphiti.getGaService().createPoint(end.getX() + offsetX, end.getY() + offsetY);
            conn.getBendpoints().add((Object)pt);
        }
    }

    private boolean hasUnpositionedSuccessors(StateGraphNode node, Set<StateGraph> sgs, Map<StateGraphNode, IPositionProvider.PosAndSize> positions, Set<StateGraphNode> visitedNodes) {
        for (Transition t : fsmHelpers.getTransitionsFromGraphNode(sgs, node)) {
            StateGraphNode target = fsmHelpers.getTerminalState(t.getTo());
            if (visitedNodes.contains(target)) continue;
            visitedNodes.add(target);
            if (positions.containsKey(target) && !this.hasUnpositionedSuccessors(node, sgs, positions, visitedNodes)) continue;
            return true;
        }
        return false;
    }

    private <T extends StateGraphNode> List<IPositionProvider.PosAndSize> getPositions(List<T> nodes, IPositionProvider positionProvider, double scaleX, Diagram diagram) {
        ArrayList<IPositionProvider.PosAndSize> result = new ArrayList<IPositionProvider.PosAndSize>(nodes.size());
        if (nodes.isEmpty()) {
            return result;
        }
        HashMap<StateGraphNode, IPositionProvider.PosAndSize> positions = new HashMap<StateGraphNode, IPositionProvider.PosAndSize>();
        HashSet<StateGraph> sgSet = new HashSet<StateGraph>();
        for (StateGraphNode node : nodes) {
            sgSet.add((StateGraph)node.eContainer());
        }
        HashSet<T> allGraphNodes = new HashSet<T>(nodes);
        for (StateGraph sg : sgSet) {
            allGraphNodes.addAll((Collection<T>)sg.getStates());
            allGraphNodes.addAll((Collection<T>)sg.getTrPoints());
        }
        for (StateGraphNode node : allGraphNodes) {
            IPositionProvider.PosAndSize pt = positionProvider.getPosition(node);
            if (pt == null) continue;
            positions.put(node, pt);
        }
        int h = 200;
        Transition initTransition = fsmHelpers.getInitTransitionForNodeList(sgSet, nodes);
        int unconnectedItemOffset = 80;
        int unconnectedStatesCount = 0;
        int unconnectedTransitionPointsCount = 0;
        if (initTransition == null) {
            for (StateGraphNode node : nodes) {
                List transitions = fsmHelpers.getTransitionsFromGraphNode(sgSet, node);
                if (!(node instanceof TrPoint) || transitions.size() <= 0) continue;
                initTransition = (Transition)transitions.get(0);
                positions.put(node, new IPositionProvider.PosAndSize(h + unconnectedItemOffset * unconnectedTransitionPointsCount, 0, 0, 0));
                ++unconnectedTransitionPointsCount;
                break;
            }
        }
        if (initTransition != null) {
            LinkedList<Transition> taskList = new LinkedList<Transition>();
            LinkedList nodesToPlace = new LinkedList();
            taskList.add(initTransition);
            IPositionProvider.PosAndSize currentPos = new IPositionProvider.PosAndSize(h, h, 0, 0);
            positions.put(fsmHelpers.getTerminalState(initTransition.getTo()), currentPos);
            while (!taskList.isEmpty()) {
                nodesToPlace.clear();
                Transition task = (Transition)taskList.remove();
                StateGraphNode currentTargetNode = fsmHelpers.getTerminalState(task.getTo());
                currentPos = positions.getOrDefault(currentTargetNode, currentPos);
                for (Transition t : fsmHelpers.getTransitionsFromGraphNode(sgSet, currentTargetNode)) {
                    StateGraphNode tTarget = fsmHelpers.getTerminalState(t.getTo());
                    if (!positions.containsKey(tTarget)) {
                        nodesToPlace.add(tTarget);
                        taskList.add(t);
                        continue;
                    }
                    if (!this.hasUnpositionedSuccessors(tTarget, sgSet, positions, new HashSet<StateGraphNode>())) continue;
                    taskList.add(t);
                }
                for (Transition t : fsmHelpers.getTransitionsToGraphNode(sgSet, currentTargetNode)) {
                    StateGraphNode tPrev;
                    if (!(t instanceof NonInitialTransition) || positions.containsKey(tPrev = fsmHelpers.getTerminalState(((NonInitialTransition)t).getFrom())) || nodesToPlace.contains(tPrev)) continue;
                    nodesToPlace.add(tPrev);
                }
                if (nodesToPlace.isEmpty()) continue;
                int numPlacementSlots = nodesToPlace.size();
                double angleDelta_rad = 1.5707963267948966 / (double)numPlacementSlots;
                int offsetX = 200;
                int offsetY = 150;
                int currentOffsetY = 0;
                int i = 0;
                nodesToPlace.sort((o1, o2) -> {
                    if (o1 instanceof TrPoint && !(o2 instanceof TrPoint)) {
                        return -1;
                    }
                    return 0;
                });
                LinkedList<StateGraphNode> listOfAlreadyHandledNodes = new LinkedList<StateGraphNode>(positions.keySet());
                listOfAlreadyHandledNodes.addAll(nodesToPlace);
                Iterator iterator = nodesToPlace.iterator();
                while (iterator.hasNext()) {
                    int y;
                    StateGraphNode node = (StateGraphNode)iterator.next();
                    int childNodeSuccessorLevel = this.findSuccessorLevel(node, sgSet, 0, listOfAlreadyHandledNodes);
                    System.out.println(String.valueOf(node.getName()) + " ancestor level " + childNodeSuccessorLevel);
                    int requiredHeight = offsetY * childNodeSuccessorLevel;
                    int offsetCorrection = 0;
                    int x = (int)((double)currentPos.getX() + (double)offsetX * Math.cos(angleDelta_rad * (double)i));
                    if (node instanceof TrPoint) {
                        x = (int)scaleX;
                    }
                    if ((y = (int)((double)currentPos.getY() + (double)offsetY * Math.sin(angleDelta_rad * (double)i))) < currentOffsetY + currentPos.getY()) {
                        offsetCorrection = offsetY / 2 + (currentOffsetY + currentPos.getY()) - y;
                        y += offsetCorrection;
                    }
                    IPositionProvider.PosAndSize newPos = new IPositionProvider.PosAndSize(x, y, 0, 0);
                    while (numPlacementSlots < 10 && positions.containsValue(newPos)) {
                        System.out.println("Position taken, adjusting slots");
                        angleDelta_rad = 1.5707963267948966 / (double)(++numPlacementSlots);
                        x = (int)((double)currentPos.getX() + (double)offsetX * Math.cos(angleDelta_rad * (double)i));
                        if (node instanceof TrPoint) {
                            x = (int)scaleX;
                        }
                        if ((y = (int)((double)currentPos.getY() + (double)offsetY * Math.sin(angleDelta_rad * (double)i))) < currentOffsetY + currentPos.getY()) {
                            offsetCorrection = offsetY / 2 + (currentOffsetY + currentPos.getY()) - y;
                            y += offsetCorrection;
                        }
                        newPos = new IPositionProvider.PosAndSize(x, y, 0, 0);
                    }
                    currentOffsetY += requiredHeight + offsetCorrection;
                    System.out.println(String.valueOf(node.getName()) + " placed by " + currentTargetNode.getName() + " in slot " + i);
                    positions.put(node, newPos);
                    ++i;
                }
            }
        }
        for (StateGraphNode node : nodes) {
            IPositionProvider.PosAndSize newPos;
            if (positions.containsKey(node)) continue;
            if (node instanceof State) {
                newPos = new IPositionProvider.PosAndSize(120, h + unconnectedItemOffset * ++unconnectedStatesCount, 0, 0);
                while (positions.containsValue(newPos) && unconnectedStatesCount < 10) {
                    newPos = new IPositionProvider.PosAndSize(120, h + unconnectedItemOffset * ++unconnectedStatesCount, 0, 0);
                }
                positions.put(node, newPos);
                continue;
            }
            newPos = new IPositionProvider.PosAndSize(h + unconnectedItemOffset * unconnectedTransitionPointsCount, 0, 0, 0);
            while (positions.containsValue(newPos) && unconnectedTransitionPointsCount < 10) {
                newPos = new IPositionProvider.PosAndSize(h + unconnectedItemOffset * ++unconnectedTransitionPointsCount, 0, 0, 0);
            }
            positions.put(node, newPos);
            ++unconnectedTransitionPointsCount;
        }
        int i = 0;
        while (i < nodes.size()) {
            IPositionProvider.PosAndSize pos = (IPositionProvider.PosAndSize)positions.get(nodes.get(i));
            result.add(pos);
            ++i;
        }
        return result;
    }

    private int findSuccessorLevel(StateGraphNode node, Set<StateGraph> sgs, int currentLevel, List<StateGraphNode> visitedNodes) {
        visitedNodes.add(node);
        int result = 0;
        for (Transition trans : fsmHelpers.getTransitionsFromGraphNode(sgs, node)) {
            StateGraphNode nextNode = fsmHelpers.getTerminalNode(trans.getTo());
            if (visitedNodes.contains(nextNode)) continue;
            ++result;
            result += this.findSuccessorLevel(nextNode, sgs, result, visitedNodes);
        }
        return result - 1 >= 0 ? result - 1 : 0;
    }

    private void addStateGraphNodes(List<? extends StateGraphNode> nodes, IPositionProvider positionProvider, ContainerShape sgShape, IFeatureProvider fp, HashMap<String, Anchor> node2anchor) {
        Diagram diagram = FSMSupportUtil.getInstance().getDiagram((PictogramElement)sgShape);
        List<IPositionProvider.PosAndSize> positions = this.getPositions(nodes, positionProvider, sgShape.getGraphicsAlgorithm().getWidth(), diagram);
        int idx = 0;
        for (StateGraphNode stateGraphNode : nodes) {
            this.addStateGraphNode(stateGraphNode, sgShape, positions.get(idx), fp, node2anchor);
            ++idx;
        }
    }

    private void addStateGraphNode(StateGraphNode tp, ContainerShape sgShape, IPositionProvider.PosAndSize pos, IFeatureProvider fp, HashMap<String, Anchor> node2anchor) {
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)tp);
        addContext.setTargetContainer(sgShape);
        addContext.setX(pos.getX());
        addContext.setY(pos.getY());
        if (pos.getWidth() > 0 && pos.getHeight() > 0) {
            addContext.setWidth(pos.getWidth());
            addContext.setHeight(pos.getHeight());
        }
        ContainerShape pe = (ContainerShape)fp.addIfPossible((IAddContext)addContext);
        assert (pe != null) : String.valueOf(tp.eClass().getName()) + " should have been created";
        assert (!pe.getAnchors().isEmpty()) : String.valueOf(tp.eClass().getName()) + " should have an anchor";
        node2anchor.put(this.getKey((EObject)tp), (Anchor)pe.getAnchors().get(0));
    }

    private void updateInitialPoint(Shape shape, IPositionProvider positionProvider, IFeatureProvider fp) {
        if (shape == null) {
            return;
        }
        StateGraph sg = (StateGraph)fp.getBusinessObjectForPictogramElement((PictogramElement)shape);
        IPositionProvider.PosAndSize ps = positionProvider.getPosition(sg);
        if (ps == null) {
            return;
        }
        GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
        Graphiti.getLayoutService().setLocationAndSize(ga, ps.getX(), ps.getY(), ps.getWidth(), ps.getHeight());
        LayoutContext lc = new LayoutContext((PictogramElement)shape);
        fp.layoutIfPossible((ILayoutContext)lc);
    }

    private void updateStateGraphNodes(List<? extends StateGraphNode> nodes, List<Shape> shapes, IPositionProvider positionProvider, IFeatureProvider fp) {
        ILinkService linkService = Graphiti.getLinkService();
        IGaService gaService = Graphiti.getGaService();
        block0: for (StateGraphNode stateGraphNode : nodes) {
            IPositionProvider.PosAndSize ps = positionProvider.getPosition(stateGraphNode);
            if (ps == null) continue;
            for (Shape shape : shapes) {
                EObject bo = linkService.getBusinessObjectForLinkedPictogramElement((PictogramElement)shape);
                if (bo != stateGraphNode) continue;
                GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
                int margin = 0;
                if (stateGraphNode instanceof State) {
                    margin = 30;
                } else if (stateGraphNode instanceof TrPoint) {
                    margin = 40;
                }
                gaService.setLocationAndSize(ga, ps.getX() - margin, ps.getY() - margin, ps.getWidth() + 2 * margin, ps.getHeight() + 2 * margin);
                LayoutContext lc = new LayoutContext((PictogramElement)shape);
                fp.layoutIfPossible((ILayoutContext)lc);
                if (!(shape instanceof ContainerShape)) continue block0;
                ContainerShape container = (ContainerShape)shape;
                for (Shape child : container.getChildren()) {
                    double[] relPos;
                    EObject childBo = linkService.getBusinessObjectForLinkedPictogramElement((PictogramElement)child);
                    if (!(childBo instanceof StateGraphNode) || (relPos = positionProvider.getSubPosition((StateGraphNode)childBo)) == null) continue;
                    gaService.setLocation(child.getGraphicsAlgorithm(), (int)(relPos[0] * (double)ps.getWidth()), (int)(relPos[1] * (double)ps.getHeight()));
                }
                continue block0;
            }
        }
    }

    private void updateTransitions(Map<Transition, Connection> transitions, IPositionProvider positionProvider, ContainerShape sgShape, IFeatureProvider fp, HashMap<String, Anchor> node2anchor) {
        for (Map.Entry<Transition, Connection> e : transitions.entrySet()) {
            Transition trans = e.getKey();
            Connection conn = e.getValue();
            String from = trans instanceof InitialTransition ? INITIAL : this.getKey((EObject)((NonInitialTransition)trans).getFrom());
            String to = this.getKey((EObject)trans.getTo());
            Anchor newSrc = node2anchor.get(from);
            Anchor newDst = node2anchor.get(to);
            assert (newSrc != null && newDst != null) : "transition endpoints must be present";
            if (conn.getStart() != newSrc) {
                conn.setStart(newSrc);
            }
            if (conn.getEnd() != newDst) {
                conn.setEnd(newDst);
            }
            List<IPositionProvider.Pos> points = positionProvider.getPoints(trans);
            Iterator<IPositionProvider.Pos> it = points.iterator();
            if (points == null || points.isEmpty()) continue;
            IPositionProvider.Pos pos = it.next();
            ConnectionDecorator cd = (ConnectionDecorator)conn.getConnectionDecorators().get(1);
            Graphiti.getGaService().setLocation(cd.getGraphicsAlgorithm(), pos.getX(), pos.getY());
            if (!(conn instanceof FreeFormConnection)) continue;
            FreeFormConnection fconn = (FreeFormConnection)conn;
            fconn.getBendpoints().clear();
            ArrayList<Point> bendpoints = new ArrayList<Point>();
            while (it.hasNext()) {
                pos = it.next();
                Point pt = Graphiti.getGaService().createPoint(pos.getX(), pos.getY());
                bendpoints.add(pt);
            }
            fconn.getBendpoints().addAll(bendpoints);
        }
    }

    private void getAnchors(State state, PictogramElement stateShape, HashMap<String, Anchor> node2anchor) {
        if (stateShape instanceof ContainerShape) {
            node2anchor.put(this.getKey((EObject)state), (Anchor)((ContainerShape)stateShape).getAnchors().get(0));
            for (Shape child : ((ContainerShape)stateShape).getChildren()) {
                EObject obj;
                ContainerShape childShape;
                if (!(child instanceof ContainerShape) || (childShape = (ContainerShape)child).getAnchors().isEmpty() || childShape.getLink().getBusinessObjects().isEmpty() || !((obj = (EObject)childShape.getLink().getBusinessObjects().get(0)) instanceof EntryPoint) && !(obj instanceof ExitPoint)) continue;
                node2anchor.put(this.getKey(obj, true), (Anchor)childShape.getAnchors().get(0));
            }
        }
    }

    private String getKey(EObject obj) {
        return this.getKey(obj, false);
    }

    private String getKey(EObject obj, boolean subTp) {
        if (obj instanceof TrPoint) {
            TrPoint tp = (TrPoint)obj;
            if (!subTp) {
                return TP + tp.getName();
            }
            if (tp.eContainer().eContainer() instanceof State) {
                State s = (State)tp.eContainer().eContainer();
                return TP + tp.getName() + SEP + s.getName();
            }
            assert (false) : "State expected";
        } else {
            if (obj instanceof State) {
                return STATE + ((State)obj).getName();
            }
            if (obj instanceof ChoicePoint) {
                return CP + ((ChoicePoint)obj).getName();
            }
            if (obj instanceof TransitionTerminal) {
                TransitionTerminal tt = (TransitionTerminal)obj;
                if (tt instanceof ChoicepointTerminal) {
                    return CP + ((ChoicepointTerminal)tt).getCp().getName();
                }
                if (tt instanceof StateTerminal) {
                    return STATE + ((StateTerminal)tt).getState().getName();
                }
                if (tt instanceof SubStateTrPointTerminal) {
                    SubStateTrPointTerminal sstt = (SubStateTrPointTerminal)tt;
                    return TP + sstt.getTrPoint().getName() + SEP + sstt.getState().getName();
                }
                if (tt instanceof TrPointTerminal) {
                    return TP + ((TrPointTerminal)tt).getTrPoint().getName();
                }
                assert (false) : "unexpected sub type";
            }
        }
        assert (false) : "unexpected type";
        return null;
    }

    private void checkDuplicates(List<? extends StateGraphItem> items) {
        FSMNameProvider fsmNameProvider = FSMSupportUtil.getInstance().getFSMNameProvider();
        for (StateGraphItem stateGraphItem : items) {
            if (items.indexOf(stateGraphItem) == items.lastIndexOf(stateGraphItem)) continue;
            Assert.isTrue((items.indexOf(stateGraphItem) == items.lastIndexOf(stateGraphItem) ? 1 : 0) != 0, (String)("multiple occurrences of " + fsmNameProvider.getFullPath(stateGraphItem)));
        }
    }
}

