/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.quickfix;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.common.base.BasePackage;
import org.eclipse.etrice.core.common.base.Import;
import org.eclipse.etrice.core.common.base.util.ImportHelpers;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.ui.quickfix.RoomQuickfixProvider;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class RoomQuickFixProviderXtend
extends RoomQuickfixProvider {
    @Inject
    private ImportHelpers importHelpers;
    private static final Set<EClass> importQuickFixClasses = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new EClass[]{RoomPackage.Literals.ROOM_CLASS, BasePackage.Literals.ANNOTATION_TYPE}));

    public List<IssueResolution> getResolutionsForLinkingIssue(Issue issue) {
        IXtextDocument xtextDocument = this.getModificationContextFactory().createModificationContext(issue).getXtextDocument();
        List list = null;
        if (xtextDocument != null) {
            IUnitOfWork iUnitOfWork = resource -> {
                List list = null;
                String issueString = xtextDocument.get(issue.getOffset().intValue(), issue.getLength().intValue());
                IssueResolutionAcceptor acceptor = (IssueResolutionAcceptor)this.getIssueResolutionAcceptorProvider().get();
                this.createLinkingQuickFixes(issue, issueString, (XtextResource)resource, acceptor);
                list = acceptor.getIssueResolutions();
                return list;
            };
            list = (List)xtextDocument.readOnly(iUnitOfWork);
        }
        List resolutions = list;
        List list2 = super.getResolutionsForLinkingIssue(issue);
        return IterableExtensions.toList((Iterable)Iterables.concat(resolutions, (Iterable)list2));
    }

    protected void createLinkingQuickFixes(Issue issue, String issueString, XtextResource resource, IssueResolutionAcceptor acceptor) {
        EObject target = resource.getEObject(issue.getUriToProblem().fragment());
        EReference reference = this.getUnresolvedEReference(issue, target);
        if (reference != null && IterableExtensions.exists(importQuickFixClasses, it -> it.isSuperTypeOf(reference.getEReferenceType()))) {
            this.createLinkingImports(issue, issueString, resource, reference.getEReferenceType(), false, acceptor);
        }
    }

    protected void createLinkingImports(Issue issue, String issueString, XtextResource resource, EClass type, boolean wildcard, IssueResolutionAcceptor acceptor) {
        List elementImports = this.importHelpers.createModelPathImports(issueString, (Resource)resource, type, false);
        Consumer<Import> consumer = imp -> {
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("Import '");
            String string = imp.getImportedNamespace();
            stringConcatenation.append(string);
            stringConcatenation.append("' ");
            ISemanticModification iSemanticModification = (elem, ctx) -> {
                RoomModel model = (RoomModel)EcoreUtil2.getContainerOfType((EObject)elem, RoomModel.class);
                EList eList = model.getImports();
                eList.add(imp);
            };
            acceptor.accept(issue, stringConcatenation.toString(), "", null, iSemanticModification);
        };
        elementImports.forEach(consumer);
        boolean bl = elementImports.isEmpty();
        if (bl) {
            Consumer<Import> consumer2 = imp -> {
                StringConcatenation stringConcatenation = new StringConcatenation();
                stringConcatenation.append("Import namespace '");
                String string = imp.getImportedNamespace();
                stringConcatenation.append(string);
                stringConcatenation.append("' from '");
                String string2 = imp.getImportURI();
                stringConcatenation.append(string2);
                stringConcatenation.append("' ");
                ISemanticModification iSemanticModification = (elem, ctx) -> {
                    RoomModel model = (RoomModel)EcoreUtil2.getContainerOfType((EObject)elem, RoomModel.class);
                    EList eList = model.getImports();
                    eList.add(imp);
                };
                acceptor.accept(issue, stringConcatenation.toString(), "", null, iSemanticModification);
            };
            this.importHelpers.createURIImports((Resource)resource, issueString, type, resource.getURI()).forEach(consumer2);
        }
    }
}

