/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.base.support;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.BasicChangeRecorder;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.ui.common.base.UIBaseActivator;
import org.eclipse.ui.statushandlers.StatusManager;

public class ResourceChangeRecorder {
    private static final String DEBUG_OPTION_RCR = "org.eclipse.etrice.ui.common.base/trace/ResourceChangeRecorder";
    private static final boolean DEBUG = ResourceChangeRecorder.isDebugging();
    private Resource resource;
    private boolean wasResourceModifiedBefore;
    private BasicChangeRecorder changeRecorder;
    private boolean result_resourceChanged = false;

    private static boolean isDebugging() {
        return UIBaseActivator.getDefault().isDebugging() && Boolean.valueOf(Platform.getDebugOption((String)DEBUG_OPTION_RCR)) != false;
    }

    public ResourceChangeRecorder(Resource resource) {
        this.resource = resource;
        this.wasResourceModifiedBefore = resource.isModified();
        this.changeRecorder = new ChangeRecorder(resource);
    }

    public void endRecording(boolean doReverse) {
        boolean hasRecordedChange;
        ChangeDescription cd = this.changeRecorder.endRecording();
        boolean bl = hasRecordedChange = !cd.getObjectChanges().isEmpty() || !cd.getObjectsToAttach().isEmpty() || !cd.getObjectsToDetach().isEmpty() || !cd.getResourceChanges().isEmpty();
        if (DEBUG && !this.wasResourceModifiedBefore && this.resource.isModified() != hasRecordedChange) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.etrice.ui.common.base", "ResourceChangeRecorder: Mismatch between recording and modification flag"), 1);
        }
        if (hasRecordedChange && doReverse) {
            cd.apply();
            if (!this.wasResourceModifiedBefore) {
                this.resource.setModified(false);
            }
        }
        if (!doReverse && hasRecordedChange) {
            this.result_resourceChanged = true;
        }
    }

    public boolean hasResourceChanged() {
        return this.result_resourceChanged;
    }
}

