/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.quickfix;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.fsm.fSM.FSMFactory;
import org.eclipse.etrice.core.fsm.fSM.MessageFromIf;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.TransitionTerminal;
import org.eclipse.etrice.core.fsm.fSM.Trigger;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.ui.behavior.dialogs.StatePropertyDialog;
import org.eclipse.etrice.ui.behavior.dialogs.TransitionPropertyDialog;
import org.eclipse.etrice.ui.behavior.fsm.support.IBehaviorQuickfixProvider;
import org.eclipse.etrice.ui.behavior.support.SupportUtil;
import org.eclipse.etrice.ui.common.base.quickfix.AbstractQuickfixProvider;
import org.eclipse.etrice.ui.common.base.quickfix.IDiagramModification;
import org.eclipse.etrice.ui.common.base.quickfix.IssueResolutionAcceptor;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.validation.FeatureBasedDiagnostic;

public class BehaviorQuickfixProvider
extends AbstractQuickfixProvider
implements IBehaviorQuickfixProvider {
    private static final String ADD_IMG = "icons/quickfix/add.gif";
    private static final String SUB_IMG = "icons/quickfix/add.gif";

    @Fix(value="etrice.receive_message")
    public void fixMissingTrigger(final FeatureBasedDiagnostic issue, IssueResolutionAcceptor acceptor) {
        final String msgName = issue.getIssueData()[1];
        final String ifItemName = issue.getIssueData()[2];
        acceptor.accept(issue, "Add the missing trigger", "Adds a new self-transition with trigger to handle message " + msgName + " from port " + ifItemName, "icons/quickfix/add.gif", new IDiagramModification(){

            public boolean apply(Diagram diagram, IFeatureProvider fp) throws Exception {
                EObject obj = issue.getSourceEObject();
                if (!(obj instanceof StateGraph)) {
                    return false;
                }
                State state = (State)((StateGraph)obj).getStates().get(issue.getIndex());
                List pes = Graphiti.getLinkService().getPictogramElements(diagram, (EObject)state);
                if (pes.size() != 1 || !(pes.get(0) instanceof ContainerShape)) {
                    return false;
                }
                ActorClass ac = SupportUtil.getInstance().getActorClass(diagram);
                List items = SupportUtil.getInstance().getRoomHelpers().getAllInterfaceItems(ac);
                for (InterfaceItem item : items) {
                    if (!item.getName().equals(ifItemName)) continue;
                    List msgs = SupportUtil.getInstance().getRoomHelpers().getIncoming(item);
                    for (Message msg : msgs) {
                        if (!msg.getName().equals(msgName)) continue;
                        TriggeredTransition trans = FSMFactory.eINSTANCE.createTriggeredTransition();
                        trans.setName(SupportUtil.getInstance().getFSMNewNamingUtil().getUniqueName("tr", (StateGraph)state.eContainer()));
                        Trigger tri = FSMFactory.eINSTANCE.createTrigger();
                        trans.getTriggers().add((Object)tri);
                        MessageFromIf mif = FSMFactory.eINSTANCE.createMessageFromIf();
                        mif.setFrom((AbstractInterfaceItem)item);
                        mif.setMessage((EObject)msg);
                        tri.getMsgFromIfPairs().add((Object)mif);
                        ((StateGraph)obj).getTransitions().add((Object)trans);
                        ContainerShape shape = (ContainerShape)pes.get(0);
                        Anchor anchor = (Anchor)shape.getAnchors().get(0);
                        TransitionTerminal src = SupportUtil.getInstance().getTransitionTerminal(anchor, fp);
                        TransitionTerminal tgt = SupportUtil.getInstance().getTransitionTerminal(anchor, fp);
                        trans.setFrom(src);
                        trans.setTo(tgt);
                        AddConnectionContext addContext = new AddConnectionContext(anchor, anchor);
                        addContext.setNewObject((Object)trans);
                        return fp.addIfPossible((IAddContext)addContext) != null;
                    }
                }
                return false;
            }
        });
    }

    @Fix(value="etrice.send_message")
    public void fixMissingMessageSend(final FeatureBasedDiagnostic issue, IssueResolutionAcceptor acceptor) {
        String msgName = issue.getIssueData()[1];
        String ifItemName = issue.getIssueData()[2];
        final String codeString = ifItemName + "." + msgName;
        acceptor.accept(issue, "Add Entry Code to send message", "Adds Entry Code to send " + msgName + " to port " + ifItemName + " in Edit State Dialog", "icons/quickfix/add.gif", new IDiagramModification(){

            public boolean apply(Diagram diagram, IFeatureProvider fp) throws Exception {
                EObject obj = issue.getSourceEObject();
                if (!(obj instanceof StateGraph)) {
                    return false;
                }
                State state = (State)((StateGraph)obj).getStates().get(issue.getIndex());
                List pes = Graphiti.getLinkService().getPictogramElements(diagram, (EObject)state);
                if (pes.size() != 1 || !(pes.get(0) instanceof ContainerShape)) {
                    return false;
                }
                ActorClass ac = SupportUtil.getInstance().getActorClass(diagram);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                StatePropertyDialog dlg = new StatePropertyDialog(shell, ac, state, true);
                dlg.setCodeSelectionString(codeString, EnumSet.of(StatePropertyDialog.Where.ENTRY));
                dlg.setAddCode(true);
                dlg.setMessageDialogContents("Please complete the code with the newly inserted and highlighted fragment.", "Quick Fix");
                return dlg.open() == 0;
            }
        });
        acceptor.accept(issue, "Add Exit Code to send message", "Adds Exit Code to send " + msgName + " to port " + ifItemName + " in Edit State Dialog", "icons/quickfix/add.gif", new IDiagramModification(){

            public boolean apply(Diagram diagram, IFeatureProvider fp) throws Exception {
                EObject obj = issue.getSourceEObject();
                if (!(obj instanceof StateGraph)) {
                    return false;
                }
                State state = (State)((StateGraph)obj).getStates().get(issue.getIndex());
                List pes = Graphiti.getLinkService().getPictogramElements(diagram, (EObject)state);
                if (pes.size() != 1 || !(pes.get(0) instanceof ContainerShape)) {
                    return false;
                }
                ActorClass ac = SupportUtil.getInstance().getActorClass(diagram);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                StatePropertyDialog dlg = new StatePropertyDialog(shell, ac, state, true);
                dlg.setCodeSelectionString(codeString, EnumSet.of(StatePropertyDialog.Where.EXIT));
                dlg.setAddCode(true);
                dlg.setMessageDialogContents("Please complete the code with the newly inserted and highlighted fragment.", "Quick Fix");
                return dlg.open() == 0;
            }
        });
    }

    @Fix(value="etrice.violation_trigger")
    public void fixViolationTrigger(final FeatureBasedDiagnostic issue, IssueResolutionAcceptor acceptor) {
        final String msgName = issue.getIssueData()[1];
        final String ifItemName = issue.getIssueData()[2];
        acceptor.accept(issue, "Remove the Violating Messgae from Trigger", "Remove the handled message " + msgName + " from port " + ifItemName + " from the trigger.\n If there are no more Messages handled by the trigger, the trigger would be removed.\n If there are no more triggers, the transition would be removed.", "icons/quickfix/add.gif", new IDiagramModification(){

            public boolean apply(Diagram diagram, IFeatureProvider fp) throws Exception {
                EObject obj = issue.getSourceEObject();
                if (!(obj instanceof Trigger)) {
                    return false;
                }
                MessageFromIf mifToDelete = null;
                Trigger trig = (Trigger)obj;
                TriggeredTransition trans = (TriggeredTransition)trig.eContainer();
                List pes = Graphiti.getLinkService().getPictogramElements(diagram, (EObject)trans);
                if (pes.size() != 1) {
                    return false;
                }
                for (MessageFromIf mif : trig.getMsgFromIfPairs()) {
                    if (((Message)mif.getMessage()).getName() != msgName || mif.getFrom().getName() != ifItemName) continue;
                    mifToDelete = mif;
                    break;
                }
                if (mifToDelete != null) {
                    if (trig.getMsgFromIfPairs().size() - 1 == 0) {
                        if (trans.getTriggers().size() - 1 == 0) {
                            Shell shell;
                            if (trans.getAction() != null && !MessageDialog.openQuestion((Shell)(shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()), (String)"Warning", (String)"Transition being removed contains Action Code. Do you want to continue?")) {
                                return false;
                            }
                            RemoveContext rc = new RemoveContext((PictogramElement)pes.get(0));
                            IRemoveFeature removeFeature = fp.getRemoveFeature((IRemoveContext)rc);
                            if (removeFeature != null) {
                                removeFeature.remove((IRemoveContext)rc);
                            }
                            EcoreUtil.delete((EObject)trans);
                            return true;
                        }
                        trans.getTriggers().remove((Object)trig);
                    } else {
                        trig.getMsgFromIfPairs().remove(mifToDelete);
                    }
                    UpdateContext updateContext = new UpdateContext((PictogramElement)pes.get(0));
                    return fp.updateIfPossible((IUpdateContext)updateContext) != null;
                }
                return false;
            }
        });
    }

    @Fix(value="etrice.violation_messagesend")
    public void fixViolationMessageSend(final FeatureBasedDiagnostic issue, IssueResolutionAcceptor acceptor) {
        String msgName = issue.getIssueData()[0];
        String ifItemName = issue.getIssueData()[1];
        final String codeString = ifItemName + "." + msgName;
        acceptor.accept(issue, "Inspect & remove the offending message", "Removes the message " + msgName + " sent to the port " + ifItemName + " in Edit State Dialog.", "icons/quickfix/add.gif", new IDiagramModification(){

            public boolean apply(Diagram diagram, IFeatureProvider fp) throws Exception {
                EObject obj = issue.getSourceEObject();
                if (obj instanceof State || obj instanceof StateGraph) {
                    State state = obj instanceof StateGraph ? (State)((StateGraph)obj).getStates().get(issue.getIndex()) : (State)obj;
                    List pes = Graphiti.getLinkService().getPictogramElements(diagram, (EObject)state);
                    if (pes.size() != 1 || !(pes.get(0) instanceof ContainerShape)) {
                        return false;
                    }
                    ActorClass ac = SupportUtil.getInstance().getActorClass(diagram);
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    StatePropertyDialog dlg = new StatePropertyDialog(shell, ac, state, true);
                    dlg.setCodeSelectionString(codeString, EnumSet.of(StatePropertyDialog.Where.ENTRY, StatePropertyDialog.Where.EXIT, StatePropertyDialog.Where.DO));
                    dlg.setMessageDialogContents("Please remove the highlighted code after inspection.", "Quick Fix");
                    return dlg.open() == 0;
                }
                if (obj instanceof Transition || obj instanceof Trigger) {
                    Transition transition = obj instanceof Trigger ? (Transition)obj.eContainer() : (Transition)obj;
                    List pes = Graphiti.getLinkService().getPictogramElements(diagram, (EObject)transition);
                    if (pes.size() != 1) {
                        return false;
                    }
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    TransitionPropertyDialog dlg = new TransitionPropertyDialog(shell, SupportUtil.getInstance().getActorClass(diagram), transition);
                    dlg.setCodeSelectionString(codeString);
                    dlg.setMessageDialogContents("Please remove the highlighted code after inspection.", "Quick Fix");
                    if (dlg.open() == 0) {
                        return true;
                    }
                }
                return false;
            }
        });
    }
}

